/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class BuildLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IFontProvider {
    final StyledString.Styler NO_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
        }
    };
    private final boolean decorateOperations;

    public BuildLabelProvider(boolean decorateOperations) {
        this.decorateOperations = decorateOperations;
    }

    public BuildLabelProvider() {
        this(false);
    }

    public Font getFont(Object element) {
        if (!this.decorateOperations) {
            return null;
        }
        if (element instanceof IBuildElement && ((IBuildElement)element).getOperations().size() > 0) {
            return CommonFonts.ITALIC;
        }
        return null;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        ImageDescriptor bottomLeftDecoration = null;
        ImageDescriptor bottomRightDecoration = null;
        ImageDescriptor topRightDecoration = null;
        if (element instanceof IBuildElement) {
            bottomLeftDecoration = this.getBottomLeftDecoration((IBuildElement)element);
        }
        if (element instanceof IBuildServer) {
            descriptor = ((IBuildServer)element).getLocation().isOffline() ? BuildImages.SERVER_DISABLED : BuildImages.SERVER;
        } else if (element instanceof IBuildPlan) {
            descriptor = BuildLabelProvider.getImageDescriptor(((IBuildPlan)element).getStatus());
            bottomRightDecoration = this.getBottomRightDecoration(((IBuildPlan)element).getState());
            topRightDecoration = this.getTopRightDecoration(((IBuildPlan)element).getFlags());
        } else if (element instanceof IBuild) {
            descriptor = BuildLabelProvider.getImageDescriptor(((IBuild)element).getStatus());
            bottomRightDecoration = this.getBottomRightDecoration(((IBuild)element).getState());
        }
        if (descriptor != null) {
            if (bottomRightDecoration != null || bottomLeftDecoration != null || topRightDecoration != null) {
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[4];
                imageDescriptorArray[1] = topRightDecoration;
                imageDescriptorArray[2] = bottomLeftDecoration;
                imageDescriptorArray[3] = bottomRightDecoration;
                descriptor = new DecorationOverlayIcon(CommonImages.getImage((ImageDescriptor)descriptor), imageDescriptorArray);
            }
            return CommonImages.getImage((ImageDescriptor)descriptor);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(BuildStatus status) {
        if (status == BuildStatus.SUCCESS) {
            return BuildImages.STATUS_PASSED;
        }
        if (status == BuildStatus.UNSTABLE) {
            return BuildImages.STATUS_UNSTABLE;
        }
        if (status == BuildStatus.FAILED) {
            return BuildImages.STATUS_FAILED;
        }
        if (status == BuildStatus.DISABLED || status == BuildStatus.ABORTED) {
            return BuildImages.STATUS_DISABLED;
        }
        return CommonImages.QUESTION;
    }

    private ImageDescriptor getBottomLeftDecoration(IBuildElement element) {
        if (element.getElementStatus() != null) {
            return CommonImages.OVERLAY_WARNING;
        }
        return null;
    }

    private ImageDescriptor getBottomRightDecoration(BuildState state) {
        if (state == BuildState.RUNNING) {
            return BuildImages.DECORATION_RUNNING;
        }
        return null;
    }

    private ImageDescriptor getTopRightDecoration(List<BuildState> flags) {
        if (flags.contains(BuildState.QUEUED)) {
            return CommonImages.OVERLAY_DATE_DUE;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text != null) {
            StyledString styledString = new StyledString(text);
            return styledString;
        }
        return new StyledString();
    }

    public String getText(Object element) {
        if (element instanceof IBuildElement) {
            return ((IBuildElement)element).getLabel();
        }
        return null;
    }
}

