/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class TaskDataHandler
extends AbstractHandler {
    public static final String POST_HANDLER_CALLBACK = "postHandlerCallback";

    public static IEvaluationContext createContext(IStructuredSelection selection, IHandlerService handlerService) {
        EvaluationContext context = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection.toList());
        context.addVariable("selection", (Object)selection);
        context.removeVariable("activeMenuSelection");
        return context;
    }

    protected TaskData getTaskData(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (first instanceof TaskData) {
                return (TaskData)first;
            }
            if (first instanceof ITask) {
                try {
                    return TasksUi.getTaskDataManager().getTaskData((ITask)first);
                }
                catch (CoreException e) {
                    return null;
                }
            }
        }
        return null;
    }

    protected boolean isEnabled(TaskData data) {
        return true;
    }

    protected void schedule(Job job, ExecutionEvent event) {
        IWorkbenchSiteProgressService progress;
        IWorkbenchPart part;
        IWorkbenchSite site = HandlerUtil.getActiveSite((ExecutionEvent)event);
        if (site == null && (part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) != null) {
            site = part.getSite();
        }
        IWorkbenchSiteProgressService iWorkbenchSiteProgressService = progress = site != null ? (IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class) : null;
        if (progress != null) {
            progress.schedule(job);
        } else {
            job.schedule();
        }
    }

    protected void executeCallback(ExecutionEvent event) {
        Object callback = HandlerUtil.getVariable((ExecutionEvent)event, (String)POST_HANDLER_CALLBACK);
        if (callback instanceof Runnable) {
            ((Runnable)callback).run();
        }
    }
}

