/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BugzillaCustomQueryWizardPage
extends AbstractRepositoryQueryPage {
    private static final Pattern URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z+.-]{0,10}://[a-zA-Z0-9%._~!$&?#'()*+,;:@/=-]*/buglist.cgi?[a-zA-Z0-9%_~!$&?#'(*+;:@/=-])");
    private Text queryText;
    private final IRepositoryQuery query;
    private Text queryTitle;

    public BugzillaCustomQueryWizardPage(TaskRepository repository, IRepositoryQuery query) {
        super(Messages.BugzillaCustomQueryWizardPage_Create_query_from_URL, repository, query);
        this.query = query;
        this.setTitle(Messages.BugzillaCustomQueryWizardPage_Create_query_from_URL);
        this.setDescription(Messages.BugzillaCustomQueryWizardPage_Enter_the_title_and_URL_for_the_query);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public BugzillaCustomQueryWizardPage(TaskRepository repository) {
        this(repository, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        ModifyListener modifyListener = e -> this.setPageComplete(this.isPageComplete());
        Label queryTitleLabel = new Label(composite, 0);
        queryTitleLabel.setText(Messages.BugzillaCustomQueryWizardPage_Query_Title);
        this.queryTitle = new Text(composite, 2048);
        this.queryTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.queryTitle.addModifyListener(modifyListener);
        this.queryTitle.setFocus();
        Label queryUrlLabel = new Label(composite, 0);
        queryUrlLabel.setText(Messages.BugzillaCustomQueryWizardPage_Query_URL);
        this.queryText = new Text(composite, 2114);
        GridData gd_queryText = new GridData(1808);
        gd_queryText.widthHint = 300;
        this.queryText.setLayoutData((Object)gd_queryText);
        this.queryText.addModifyListener(modifyListener);
        if (this.query != null) {
            this.queryTitle.setText(this.query.getSummary());
            this.queryText.setText(this.query.getUrl());
        }
        Dialog.applyDialogFont((Control)composite);
    }

    public String getQueryTitle() {
        return this.queryTitle.getText();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            if (this.queryText.getText().length() > 0) {
                Matcher m = URL_PATTERN.matcher(this.queryText.getText());
                if (m.find()) {
                    return true;
                }
                this.setErrorMessage(Messages.BugzillaCustomQueryWizardPage_No_Valid_Buglist_URL);
                return false;
            }
            this.setErrorMessage(Messages.BugzillaCustomQueryWizardPage_Please_specify_Query_URL);
        }
        return false;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getQueryTitle());
        query.setUrl(this.queryText.getText());
        query.setAttribute("bugzilla.query.custom", Boolean.TRUE.toString());
    }
}

