/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.requestfactory.server.DefaultExceptionHandler;
import com.google.gwt.requestfactory.server.DefaultSecurityProvider;
import com.google.gwt.requestfactory.server.ExceptionHandler;
import com.google.gwt.requestfactory.server.JsonRequestProcessor;
import com.google.gwt.requestfactory.server.Logging;
import com.google.gwt.requestfactory.server.ReflectionBasedOperationRegistry;
import com.google.gwt.requestfactory.server.RequestProcessingException;
import com.google.gwt.requestfactory.server.UserInformation;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestFactoryServlet
extends HttpServlet {
    private static final String JSON_CHARSET = "UTF-8";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final Logger log = Logger.getLogger(RequestFactoryServlet.class.getCanonicalName());
    private static final ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();
    private final ExceptionHandler exceptionHandler;

    public static HttpServletRequest getThreadLocalRequest() {
        return perThreadRequest.get();
    }

    public static HttpServletResponse getThreadLocalResponse() {
        return perThreadResponse.get();
    }

    public RequestFactoryServlet() {
        this(new DefaultExceptionHandler());
    }

    public RequestFactoryServlet(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            perThreadRequest.set(request);
            perThreadResponse.set(response);
            try {
                this.ensureConfig();
                String jsonRequestString = RPCServletUtils.readContent(request, JSON_CONTENT_TYPE, JSON_CHARSET);
                response.setStatus(200);
                PrintWriter writer = response.getWriter();
                try {
                    UserInformation userInfo = UserInformation.getCurrentUserInformation(request.getHeader("pageurl"));
                    if (!userInfo.isUserLoggedIn()) {
                        response.setHeader("login", userInfo.getLoginUrl());
                        response.sendError(401);
                        break block6;
                    }
                    response.setHeader("userId", String.format("%s", userInfo.getId()));
                    response.setStatus(200);
                    JsonRequestProcessor requestProcessor = new JsonRequestProcessor();
                    requestProcessor.setOperationRegistry(new ReflectionBasedOperationRegistry(new DefaultSecurityProvider()));
                    requestProcessor.setExceptionHandler(this.exceptionHandler);
                    response.setContentType("application/json; charset=utf-8");
                    writer.print(requestProcessor.decodeAndInvokeRequest(jsonRequestString));
                    writer.flush();
                }
                catch (RequestProcessingException e) {
                    writer.print((String)e.getResponse());
                    writer.flush();
                    log.log(Level.SEVERE, "Unexpected error", e);
                }
            }
            finally {
                perThreadRequest.set(null);
                perThreadResponse.set(null);
            }
        }
    }

    private void ensureConfig() {
        String symbolMapsDirectory;
        String userInfoClass = this.getServletConfig().getInitParameter("userInfoClass");
        if (userInfoClass != null) {
            UserInformation.setUserInformationImplClass(userInfoClass);
        }
        if ((symbolMapsDirectory = this.getServletConfig().getInitParameter("symbolMapsDirectory")) != null) {
            Logging.setSymbolMapsDirectory(symbolMapsDirectory);
        }
    }
}

