/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import com.google.gwt.dev.asm.AnnotationVisitor;
import com.google.gwt.dev.asm.ClassReader;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.EmptyVisitor;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.asm.signature.SignatureReader;
import com.google.gwt.dev.asm.signature.SignatureVisitor;
import com.google.gwt.dev.util.Name;
import com.google.gwt.requestfactory.client.impl.FindRequest;
import com.google.gwt.requestfactory.server.SignatureAdapter;
import com.google.gwt.requestfactory.shared.EntityProxy;
import com.google.gwt.requestfactory.shared.InstanceRequest;
import com.google.gwt.requestfactory.shared.ProxyFor;
import com.google.gwt.requestfactory.shared.ProxyForName;
import com.google.gwt.requestfactory.shared.Request;
import com.google.gwt.requestfactory.shared.RequestContext;
import com.google.gwt.requestfactory.shared.RequestFactory;
import com.google.gwt.requestfactory.shared.Service;
import com.google.gwt.requestfactory.shared.ServiceName;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestFactoryInterfaceValidator {
    static final Set<Class<?>> VALUE_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Class.class, Date.class, Enum.class, Number.class, String.class, Void.class)));
    private final Map<Type, Type> clientToDomainType = new HashMap<Type, Type>();
    private final Type entityProxyIntf = Type.getType(EntityProxy.class);
    private final Type errorType = Type.getType(MissingDomainType.class);
    private final Type instanceRequestIntf = Type.getType(InstanceRequest.class);
    private final Loader loader;
    private final Map<Type, Set<RFMethod>> methodsInHierarchy = new HashMap<Type, Set<RFMethod>>();
    private final ErrorContext parentLogger;
    private boolean poisoned;
    private final Type requestIntf = Type.getType(Request.class);
    private final Type requestContextIntf = Type.getType(RequestContext.class);
    private final Map<Type, List<Type>> supertypes = new HashMap<Type, List<Type>>();
    private final Set<String> validatedTypes = new HashSet<String>();
    private final Set<Type> valueTypes = new HashSet<Type>();

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -cp gwt-servlet.jar:your-code.jar " + RequestFactoryInterfaceValidator.class.getCanonicalName() + " com.example.MyRequestFactory");
            System.exit(1);
        }
        RequestFactoryInterfaceValidator validator = new RequestFactoryInterfaceValidator(Logger.getLogger(RequestFactoryInterfaceValidator.class.getName()), new ClassLoaderLoader(Thread.currentThread().getContextClassLoader()));
        validator.validateRequestFactory(args[0]);
        System.exit(validator.isPoisoned() ? 1 : 0);
    }

    private static String print(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestFactoryInterfaceValidator.print(method.getReturnType())).append(" ").append(method.getName()).append("(");
        for (Type t : method.getArgumentTypes()) {
            sb.append(RequestFactoryInterfaceValidator.print(t)).append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String print(Type type) {
        return Name.SourceOrBinaryName.toSourceName(type.getClassName());
    }

    public RequestFactoryInterfaceValidator(Logger logger, Loader loader) {
        this.parentLogger = new ErrorContext(logger);
        this.loader = loader;
        for (Class<?> clazz : VALUE_TYPES) {
            this.valueTypes.add(Type.getType(clazz));
        }
    }

    public boolean isPoisoned() {
        return this.poisoned;
    }

    public void validateEntityProxy(String binaryName) {
        if (!Name.isBinaryName(binaryName)) {
            this.parentLogger.poison("%s is not a binary name", binaryName);
            return;
        }
        if (!this.validatedTypes.add(binaryName)) {
            return;
        }
        Type proxyType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(proxyType);
        if (!this.isAssignable(logger, this.entityProxyIntf, proxyType)) {
            this.parentLogger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(proxyType), EntityProxy.class.getSimpleName());
            return;
        }
        Type domainType = this.getDomainType(logger, proxyType);
        if (domainType == this.errorType) {
            logger.poison("The type %s must be annotated with a @%s or @%s annotation", Name.BinaryName.toSourceName(binaryName), ProxyFor.class.getSimpleName(), ProxyForName.class.getSimpleName());
            return;
        }
        this.checkIdAndVersion(logger, domainType);
        Set<RFMethod> clientPropertyMethods = this.getMethodsInHierarchy(logger, proxyType);
        for (RFMethod clientPropertyMethod : clientPropertyMethods) {
            if ("stableId".equals(clientPropertyMethod.getName()) && clientPropertyMethod.getArgumentTypes().length == 0) continue;
            this.checkPropertyMethod(logger, clientPropertyMethod, domainType);
            this.maybeCheckReferredProxies(logger, clientPropertyMethod);
        }
    }

    public void validateRequestContext(String binaryName) {
        if (!Name.isBinaryName(binaryName)) {
            this.parentLogger.poison("%s is not a binary name", binaryName);
            return;
        }
        if (!this.validatedTypes.add(binaryName)) {
            return;
        }
        if (FindRequest.class.getName().equals(binaryName)) {
            return;
        }
        Type requestContextType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(requestContextType);
        if (!this.isAssignable(logger, this.requestContextIntf, requestContextType)) {
            logger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(requestContextType), RequestContext.class.getSimpleName());
            return;
        }
        Type domainServiceType = this.getDomainType(logger, requestContextType);
        if (domainServiceType == this.errorType) {
            logger.poison("The type %s must be annotated with a @%s or @%s annotation", Name.BinaryName.toSourceName(binaryName), Service.class.getSimpleName(), ServiceName.class.getSimpleName());
            return;
        }
        for (RFMethod method : this.getMethodsInHierarchy(logger, requestContextType)) {
            if (this.findCompatibleMethod(logger, this.requestContextIntf, method, false, true) != null) continue;
            this.checkClientMethodInDomain(logger, method, domainServiceType);
            this.maybeCheckReferredProxies(logger, method);
        }
    }

    public void validateRequestFactory(String binaryName) {
        if (!Name.isBinaryName(binaryName)) {
            this.parentLogger.poison("%s is not a binary name", binaryName);
            return;
        }
        if (!this.validatedTypes.add(binaryName)) {
            return;
        }
        Type requestFactoryType = Type.getObjectType(Name.BinaryName.toInternalName(binaryName));
        ErrorContext logger = this.parentLogger.setType(requestFactoryType);
        if (!this.isAssignable(logger, Type.getType(RequestFactory.class), requestFactoryType)) {
            logger.poison("%s is not a %s", RequestFactoryInterfaceValidator.print(requestFactoryType), RequestFactory.class.getSimpleName());
            return;
        }
        for (RFMethod contextMethod : this.getMethodsInHierarchy(logger, requestFactoryType)) {
            Type returnType = contextMethod.getReturnType();
            if (!this.isAssignable(logger, this.requestContextIntf, returnType)) continue;
            this.validateRequestContext(returnType.getClassName());
        }
    }

    private void checkClientMethodInDomain(ErrorContext logger, RFMethod method, Type domainServiceType) {
        logger = logger.setMethod(method);
        Type returnType = this.getReturnType(logger, method);
        Method searchFor = this.createDomainMethod(logger, new Method(method.getName(), returnType, method.getArgumentTypes()));
        RFMethod found = this.findCompatibleMethod(logger, domainServiceType, searchFor);
        if (found != null) {
            boolean isInstance = this.isAssignable(logger, this.instanceRequestIntf, method.getReturnType());
            if (isInstance && found.isDeclaredStatic()) {
                logger.poison("The method %s is declared to return %s, but the service method is static", method.getName(), InstanceRequest.class.getCanonicalName());
            } else if (!isInstance && !found.isDeclaredStatic) {
                logger.poison("The method %s is declared to return %s, but the service method is not static", method.getName(), Request.class.getCanonicalName());
            }
        }
    }

    private void checkIdAndVersion(ErrorContext logger, Type domainType) {
        Method getVersion;
        logger = logger.setType(domainType);
        Method getIdString = new Method("getId", "()Ljava/lang/String;");
        Method getIdLong = new Method("getId", "()Ljava/lang/Long;");
        if (this.findCompatibleMethod(logger, domainType, getIdString, false, true) == null && this.findCompatibleMethod(logger, domainType, getIdLong, false, true) == null) {
            logger.poison("Did not find a getId() method that returns a String or a Long", new Object[0]);
        }
        if (this.findCompatibleMethod(logger, domainType, getVersion = new Method("getVersion", "()Ljava/lang/Integer;")) == null) {
            logger.poison("Did not find a getVersion() method that returns an Integer", new Object[0]);
        }
    }

    private void checkPropertyMethod(ErrorContext logger, Method clientPropertyMethod, Type domainType) {
        logger = logger.setMethod(clientPropertyMethod);
        this.findCompatibleMethod(logger, domainType, this.createDomainMethod(logger, clientPropertyMethod));
    }

    private Method createDomainMethod(ErrorContext logger, Method clientMethod) {
        Type[] args = clientMethod.getArgumentTypes();
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            args[i] = this.getDomainType(logger, args[i]);
        }
        Type returnType = this.getDomainType(logger, clientMethod.getReturnType());
        return new Method(clientMethod.getName(), returnType, args);
    }

    private RFMethod findCompatibleMethod(ErrorContext logger, Type domainType, Method searchFor) {
        return this.findCompatibleMethod(logger, domainType, searchFor, true, false);
    }

    private RFMethod findCompatibleMethod(ErrorContext logger, Type domainType, Method searchFor, boolean mustFind, boolean allowOverloads) {
        StringBuilder sb;
        String methodName = searchFor.getName();
        Type[] clientArgs = searchFor.getArgumentTypes();
        Type clientReturnType = searchFor.getReturnType();
        LinkedHashMap<String, ArrayList<RFMethod>> domainLookup = new LinkedHashMap<String, ArrayList<RFMethod>>();
        for (RFMethod method : this.getMethodsInHierarchy(logger, domainType)) {
            ArrayList<RFMethod> list = (ArrayList<RFMethod>)domainLookup.get(method.getName());
            if (list == null) {
                list = new ArrayList<RFMethod>();
                domainLookup.put(method.getName(), list);
            }
            list.add(method);
        }
        List methods = (List)domainLookup.get(methodName);
        if (methods == null) {
            if (mustFind) {
                logger.poison("Could not find any methods named %s in %s", methodName, RequestFactoryInterfaceValidator.print(domainType));
            }
            return null;
        }
        if (methods.size() > 1 && !allowOverloads) {
            sb = new StringBuilder();
            sb.append(String.format("Method overloads found in type %s named %s:\n", RequestFactoryInterfaceValidator.print(domainType), methodName));
            for (RFMethod method : methods) {
                sb.append("  ").append(RequestFactoryInterfaceValidator.print(method)).append("\n");
            }
            logger.poison(sb.toString(), new Object[0]);
            return null;
        }
        for (RFMethod domainMethod : methods) {
            Type[] domainArgs = domainMethod.getArgumentTypes();
            int j = domainArgs.length;
            for (int i = 0; i < j; ++i) {
                domainArgs[i] = this.maybeBoxType(domainArgs[i]);
            }
            Type domainReturnType = this.maybeBoxType(domainMethod.getReturnType());
            if (!this.isAssignable(logger, domainArgs, clientArgs) || !this.isAssignable(logger, clientReturnType, domainReturnType)) continue;
            logger.spam("Mapped client method " + RequestFactoryInterfaceValidator.print(searchFor) + " to " + RequestFactoryInterfaceValidator.print(domainMethod), new Object[0]);
            return domainMethod;
        }
        if (mustFind) {
            sb = new StringBuilder();
            sb.append(String.format("Could not find matching method in %s:\nPossible matches:\n", RequestFactoryInterfaceValidator.print(domainType)));
            for (RFMethod domainMethod : methods) {
                sb.append("  ").append(RequestFactoryInterfaceValidator.print(domainMethod)).append("\n");
            }
            logger.poison(sb.toString(), new Object[0]);
        }
        return null;
    }

    private Type getBoxedType(Type primitive) {
        switch (primitive.getSort()) {
            case 1: {
                return Type.getType(Boolean.class);
            }
            case 3: {
                return Type.getType(Byte.class);
            }
            case 2: {
                return Type.getType(Character.class);
            }
            case 8: {
                return Type.getType(Double.class);
            }
            case 6: {
                return Type.getType(Float.class);
            }
            case 5: {
                return Type.getType(Integer.class);
            }
            case 7: {
                return Type.getType(Long.class);
            }
            case 4: {
                return Type.getType(Short.class);
            }
            case 0: {
                return Type.getType(Void.class);
            }
        }
        throw new RuntimeException(primitive.getDescriptor() + " is not a primitive type");
    }

    private Type getDomainType(ErrorContext logger, Type clientType) {
        Type toReturn = this.clientToDomainType.get(clientType);
        if (toReturn != null) {
            return toReturn;
        }
        if (this.isValueType(logger, clientType) || this.isCollectionType(logger, clientType)) {
            toReturn = clientType;
        } else {
            logger = logger.setType(clientType);
            DomainMapper pv = new DomainMapper(logger);
            this.visit(logger, clientType.getInternalName(), pv);
            if (pv.getDomainInternalName() == null) {
                logger.poison("%s has no mapping to a domain type (e.g. @%s or @%s)", RequestFactoryInterfaceValidator.print(clientType), ProxyFor.class.getSimpleName(), Service.class.getSimpleName());
                toReturn = this.errorType;
            } else {
                toReturn = Type.getObjectType(pv.getDomainInternalName());
            }
        }
        this.clientToDomainType.put(clientType, toReturn);
        return toReturn;
    }

    private Set<RFMethod> getMethodsInHierarchy(ErrorContext logger, Type domainType) {
        Set<RFMethod> toReturn = this.methodsInHierarchy.get(domainType);
        if (toReturn == null) {
            logger = logger.setType(domainType);
            toReturn = new MethodsInHierarchyCollector(logger).exec(domainType.getInternalName());
            this.methodsInHierarchy.put(domainType, Collections.unmodifiableSet(toReturn));
        }
        return toReturn;
    }

    private Type getReturnType(ErrorContext logger, RFMethod method) {
        int expectedCount;
        logger = logger.setMethod(method);
        final String[] returnType = new String[]{"java/lang/Object"};
        String signature = method.getSignature();
        if (method.getReturnType().equals(this.instanceRequestIntf)) {
            expectedCount = 2;
        } else if (method.getReturnType().equals(this.requestIntf)) {
            expectedCount = 1;
        } else {
            logger.spam("Punting on " + signature, new Object[0]);
            return Type.getObjectType(returnType[0]);
        }
        new SignatureReader(signature).accept(new SignatureAdapter(){

            public SignatureVisitor visitReturnType() {
                return new SignatureAdapter(){
                    int count;

                    public SignatureVisitor visitTypeArgument(char wildcard) {
                        if (++this.count == expectedCount) {
                            return new SignatureAdapter(){

                                public void visitClassType(String name) {
                                    returnType[0] = name;
                                }
                            };
                        }
                        return super.visitTypeArgument(wildcard);
                    }
                };
            }
        });
        logger.spam("Extracted " + returnType[0], new Object[0]);
        return Type.getObjectType(returnType[0]);
    }

    private List<Type> getSupertypes(ErrorContext logger, Type type) {
        if (type.getSort() != 10) {
            return Collections.emptyList();
        }
        List<Type> toReturn = this.supertypes.get(type);
        if (toReturn != null) {
            return toReturn;
        }
        logger = logger.setType(type);
        toReturn = new SupertypeCollector(logger).exec(type);
        this.supertypes.put(type, Collections.unmodifiableList(toReturn));
        return toReturn;
    }

    private boolean isAssignable(ErrorContext logger, Type possibleSupertype, Type possibleSubtype) {
        if (possibleSupertype.equals(possibleSubtype)) {
            return true;
        }
        if (possibleSupertype.getSort() != 10) {
            possibleSupertype = this.getBoxedType(possibleSupertype);
        }
        if (possibleSubtype.getSort() != 10) {
            possibleSubtype = this.getBoxedType(possibleSubtype);
        }
        List<Type> allSupertypes = this.getSupertypes(logger, possibleSubtype);
        return allSupertypes.contains(possibleSupertype);
    }

    private boolean isAssignable(ErrorContext logger, Type[] possibleSupertypes, Type[] possibleSubtypes) {
        if (possibleSupertypes.length != possibleSubtypes.length) {
            return false;
        }
        int j = possibleSupertypes.length;
        for (int i = 0; i < j; ++i) {
            if (this.isAssignable(logger, possibleSupertypes[i], possibleSubtypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isCollectionType(ErrorContext logger, Type type) {
        return "java/util/List".equals(type.getInternalName()) || "java/util/Set".equals(type.getInternalName());
    }

    private boolean isValueType(ErrorContext logger, Type type) {
        if (type.getSort() != 10) {
            return true;
        }
        if (this.valueTypes.contains(type)) {
            return true;
        }
        logger = logger.setType(type);
        List<Type> types = this.getSupertypes(logger, type);
        for (Type t : types) {
            if (!this.valueTypes.contains(t)) continue;
            this.valueTypes.add(type);
            return true;
        }
        return false;
    }

    private Type maybeBoxType(Type maybePrimitive) {
        if (maybePrimitive.getSort() == 10) {
            return maybePrimitive;
        }
        return this.getBoxedType(maybePrimitive);
    }

    private void maybeCheckEntityProxyType(ErrorContext logger, Type ... types) {
        for (Type type : types) {
            if (!this.isAssignable(logger, this.entityProxyIntf, type)) continue;
            this.validateEntityProxy(type.getClassName());
        }
    }

    private void maybeCheckReferredProxies(ErrorContext logger, RFMethod method) {
        Type[] argTypes = method.getArgumentTypes();
        Type returnType = this.getReturnType(logger, method);
        this.maybeCheckEntityProxyType(logger, argTypes);
        this.maybeCheckEntityProxyType(logger, returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visit(ErrorContext logger, String internalName, ClassVisitor visitor) {
        block17: {
            boolean bl;
            assert (Name.isInternalName(internalName)) : "internalName";
            logger.spam("Visiting " + internalName, new Object[0]);
            InputStream inputStream = null;
            try {
                inputStream = this.loader.getResourceAsStream(internalName + ".class");
                if (inputStream == null) {
                    logger.poison("Could not find class file for " + internalName, new Object[0]);
                    boolean bl2 = false;
                    return bl2;
                }
                ClassReader reader = new ClassReader(inputStream);
                reader.accept(visitor, 7);
                bl = true;
            }
            catch (IOException e) {
                logger.poison("Unable to open " + internalName, e);
                break block17;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return bl;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SupertypeCollector
    extends EmptyVisitor {
        private final ErrorContext logger;
        private final Set<String> seen = new HashSet<String>();
        private final List<Type> supertypes = new ArrayList<Type>();

        public SupertypeCollector(ErrorContext logger) {
            this.logger = logger;
        }

        public List<Type> exec(Type type) {
            RequestFactoryInterfaceValidator.this.visit(this.logger, type.getInternalName(), this);
            return this.supertypes;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!this.seen.add(name)) {
                return;
            }
            this.supertypes.add(Type.getObjectType(name));
            if (!"java/lang/Object".equals(name)) {
                RequestFactoryInterfaceValidator.this.visit(this.logger, superName, this);
            }
            if (interfaces != null) {
                for (String intf : interfaces) {
                    RequestFactoryInterfaceValidator.this.visit(this.logger, intf, this);
                }
            }
        }
    }

    private static class RFMethod
    extends Method {
        private boolean isDeclaredStatic;
        private String signature;

        public RFMethod(String name, String desc) {
            super(name, desc);
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isDeclaredStatic() {
            return this.isDeclaredStatic;
        }

        public void setDeclaredSignature(String signature) {
            this.signature = signature;
        }

        public void setDeclaredStatic(boolean value) {
            this.isDeclaredStatic = value;
        }

        public String toString() {
            return (this.isDeclaredStatic ? "static " : "") + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodsInHierarchyCollector
    extends EmptyVisitor {
        private final ErrorContext logger;
        private Set<RFMethod> methods = new LinkedHashSet<RFMethod>();
        private Set<String> seen = new HashSet<String>();

        private MethodsInHierarchyCollector(ErrorContext logger) {
            this.logger = logger;
        }

        public Set<RFMethod> exec(String internalName) {
            RequestFactoryInterfaceValidator.this.visit(this.logger, internalName, this);
            return this.methods;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (!this.seen.add(name)) {
                return;
            }
            if (!"java/lang/Object".equals(superName)) {
                RequestFactoryInterfaceValidator.this.visit(this.logger, superName, this);
            }
            if (interfaces != null) {
                for (String intf : interfaces) {
                    RequestFactoryInterfaceValidator.this.visit(this.logger, intf, this);
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<clinit>".equals(name) || "<init>".equals(name)) {
                return null;
            }
            RFMethod method = new RFMethod(name, desc);
            method.setDeclaredStatic((access & 8) != 0);
            method.setDeclaredSignature(signature);
            this.methods.add(method);
            return null;
        }
    }

    private class ErrorContext {
        private final Logger logger;
        private final ErrorContext parent;
        private Type currentType;
        private Method currentMethod;

        public ErrorContext(Logger logger) {
            this.logger = logger;
            this.parent = null;
        }

        private ErrorContext(ErrorContext parent) {
            this.logger = parent.logger;
            this.parent = parent;
        }

        public void poison(String msg, Object ... args) {
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), String.format(msg, args));
            RequestFactoryInterfaceValidator.this.poisoned = true;
        }

        public void poison(String msg, Throwable t) {
            this.logger.logp(Level.SEVERE, this.currentType(), this.currentMethod(), msg, t);
            RequestFactoryInterfaceValidator.this.poisoned = true;
        }

        public ErrorContext setMethod(Method method) {
            ErrorContext toReturn = new ErrorContext(this);
            toReturn.currentMethod = method;
            return toReturn;
        }

        public ErrorContext setType(Type type) {
            ErrorContext toReturn = new ErrorContext(this);
            toReturn.currentType = type;
            return toReturn;
        }

        public void spam(String msg, Object ... args) {
            this.logger.logp(Level.FINEST, this.currentType(), this.currentMethod(), String.format(msg, args));
        }

        private String currentMethod() {
            if (this.currentMethod != null) {
                return RequestFactoryInterfaceValidator.print(this.currentMethod);
            }
            if (this.parent != null) {
                return this.parent.currentMethod();
            }
            return null;
        }

        private String currentType() {
            if (this.currentType != null) {
                return RequestFactoryInterfaceValidator.print(this.currentType);
            }
            if (this.parent != null) {
                return this.parent.currentType();
            }
            return null;
        }
    }

    private class DomainMapper
    extends EmptyVisitor {
        private final ErrorContext logger;
        private String domainInternalName;

        public DomainMapper(ErrorContext logger) {
            this.logger = logger;
            logger.spam("Finding domain mapping annotation", new Object[0]);
        }

        public String getDomainInternalName() {
            return this.domainInternalName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 0x200) == 0) {
                this.logger.poison("Type must be an interface", new Object[0]);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean foundProxy = desc.equals(Type.getDescriptor(ProxyFor.class));
            boolean foundProxyName = desc.equals(Type.getDescriptor(ProxyForName.class));
            boolean foundService = desc.equals(Type.getDescriptor(Service.class));
            boolean foundServiceName = desc.equals(Type.getDescriptor(ServiceName.class));
            if (foundProxy || foundService) {
                return new EmptyVisitor(){

                    public void visit(String name, Object value) {
                        DomainMapper.this.domainInternalName = ((Type)value).getInternalName();
                    }
                };
            }
            if (foundProxyName || foundServiceName) {
                return new EmptyVisitor(){

                    public void visit(String name, Object value) {
                        String sourceName = (String)value;
                        StringBuffer desc = new StringBuffer(sourceName.replace('.', '/'));
                        while (!RequestFactoryInterfaceValidator.this.loader.exists(desc.toString() + ".class")) {
                            DomainMapper.this.logger.spam("Did not find " + desc.toString(), new Object[0]);
                            int idx = desc.lastIndexOf("/");
                            if (idx == -1) {
                                return;
                            }
                            desc.setCharAt(idx, '$');
                        }
                        DomainMapper.this.domainInternalName = desc.toString();
                        DomainMapper.this.logger.spam(DomainMapper.this.domainInternalName, new Object[0]);
                    }
                };
            }
            return null;
        }
    }

    static interface MissingDomainType {
    }

    public static interface Loader {
        public boolean exists(String var1);

        public InputStream getResourceAsStream(String var1);
    }

    public static class ClassLoaderLoader
    implements Loader {
        private final ClassLoader loader;

        public ClassLoaderLoader(ClassLoader loader) {
            this.loader = loader;
        }

        public boolean exists(String resource) {
            return this.loader.getResource(resource) != null;
        }

        public InputStream getResourceAsStream(String resource) {
            return this.loader.getResourceAsStream(resource);
        }
    }
}

