/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.mylyn.wikitext.util.WikiToStringStyle;

public class SimpleLocator
implements Locator {
    private final int lineNumber;
    private final int lineDocumentOffset;
    private final int lineLength;
    private final int lineCharacterOffset;
    private final int lineSegmentEndOffset;

    public SimpleLocator(Line line) {
        this(line, 0, line.getText().length());
    }

    public SimpleLocator(Line line, int lineCharacterOffset, int lineSegmentEndOffset) {
        Objects.requireNonNull(line);
        this.lineNumber = line.getLineNumber() + 1;
        this.lineDocumentOffset = line.getOffset();
        this.lineLength = line.getText().length();
        this.lineCharacterOffset = lineCharacterOffset;
        this.lineSegmentEndOffset = lineSegmentEndOffset;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineDocumentOffset() {
        return this.lineDocumentOffset;
    }

    public int getDocumentOffset() {
        return this.getLineDocumentOffset() + this.getLineCharacterOffset();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getLineCharacterOffset() {
        return this.lineCharacterOffset;
    }

    public int getLineSegmentEndOffset() {
        return this.lineSegmentEndOffset;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)WikiToStringStyle.WIKI_TO_STRING_STYLE).append("lineNumber", this.lineNumber).append("lineDocumentOffset", this.lineDocumentOffset).append("lineLength", this.lineLength).append("lineCharacterOffset", this.lineCharacterOffset).append("lineSegmentEndOffset", this.lineSegmentEndOffset).toString();
    }
}

