/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.text.MessageFormat;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.mylyn.commons.ui.dialogs.AbstractNotificationPopup;
import org.eclipse.mylyn.internal.github.ui.GitHubImages;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class GistNotificationPopup
extends AbstractNotificationPopup {
    private Gist gist;
    private String title;
    private TaskRepository repository;

    public GistNotificationPopup(Display display, Gist gist, String title, TaskRepository repository) {
        super(display);
        this.gist = gist;
        this.title = title;
        this.repository = repository;
    }

    protected void createContentArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format(Messages.GistNotificationPopup_GistTitle, this.title));
        Link link = new Link(composite, 64);
        link.setText(MessageFormat.format(Messages.GistNotificationPopup_GistLink, this.gist.getId()));
        link.setLayoutData((Object)new GridData(768));
        link.setBackground(composite.getBackground());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTask task = TasksUiInternal.getTask((String)GistNotificationPopup.this.repository.getRepositoryUrl(), (String)GistNotificationPopup.this.gist.getId(), (String)GistNotificationPopup.this.gist.getHtmlUrl());
                if (task != null) {
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)task);
                } else {
                    TasksUiInternal.openTask((TaskRepository)GistNotificationPopup.this.repository, (String)GistNotificationPopup.this.gist.getId(), null);
                }
            }
        });
    }

    protected String getPopupShellTitle() {
        return Messages.GistNotificationPopup_ShellTitle;
    }

    protected Image getPopupShellImage(int maximumHeight) {
        return GitHubImages.get("org.eclipse.mylyn.github.uiOBJ_GITHUB_LOGO");
    }
}

