/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands.Messages;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectReviewSiteHandler
extends AbstractHandler {
    private GerritServerUtility fServerUtil = null;

    public Object execute(ExecutionEvent aEvent) {
        GerritPlugin.Ftracer.traceInfo("Collecting the gerrit review locations");
        final GerritTableView reviewTableView = GerritTableView.getActiveView(true);
        reviewTableView.openView();
        Job job = new Job(Messages.SelectReviewSiteHandler_searchCommand){

            public boolean belongsTo(Object aFamily) {
                return Messages.SelectReviewSiteHandler_dashboardUiJob.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                aMonitor.beginTask(Messages.SelectReviewSiteHandler_searchCommand, -1);
                SelectReviewSiteHandler.this.fServerUtil = GerritServerUtility.getInstance();
                String serverToUsed = SelectReviewSiteHandler.this.fServerUtil.getLastSavedGerritServer();
                if (serverToUsed != null) {
                    reviewTableView.processCommands("my watched changes");
                } else {
                    IWorkbench workbench = GerritUi.getDefault().getWorkbench();
                    IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("org.eclipse.mylyn.gerrit.dashboard.ui.addGerritSite", null);
                    }
                    catch (Exception ex) {
                        GerritPlugin.Ftracer.traceError(NLS.bind((String)Messages.SelectReviewSiteHandler_exception, (Object)ex.toString()));
                    }
                }
                aMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

