/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCell<C>
implements Cell<C> {
    private Set<String> consumedEvents;

    public AbstractCell(String ... consumedEvents) {
        HashSet<String> events = null;
        if (consumedEvents != null && consumedEvents.length > 0) {
            events = new HashSet<String>();
            for (String event : consumedEvents) {
                events.add(event);
            }
        }
        this.init(events);
    }

    public AbstractCell(Set<String> consumedEvents) {
        this.init(consumedEvents);
    }

    @Override
    public boolean dependsOnSelection() {
        return false;
    }

    @Override
    public Set<String> getConsumedEvents() {
        return this.consumedEvents;
    }

    @Override
    public boolean handlesSelection() {
        return false;
    }

    @Override
    public boolean isEditing(Element parent, C value, Object key) {
        return false;
    }

    @Override
    public void onBrowserEvent(Element parent, C value, Object key, NativeEvent event, ValueUpdater<C> valueUpdater) {
        String eventType = event.getType();
        if ("keydown".equals(eventType) && event.getKeyCode() == 13) {
            this.onEnterKeyDown(parent, value, key, event, valueUpdater);
        }
    }

    @Override
    public abstract void render(C var1, Object var2, SafeHtmlBuilder var3);

    @Override
    public boolean resetFocus(Element parent, C value, Object key) {
        return false;
    }

    @Override
    public void setValue(Element parent, C value, Object key) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        this.render(value, key, sb);
        parent.setInnerHTML(sb.toSafeHtml().asString());
    }

    protected void onEnterKeyDown(Element parent, C value, Object key, NativeEvent event, ValueUpdater<C> valueUpdater) {
    }

    private void init(Set<String> consumedEvents) {
        if (consumedEvents != null) {
            this.consumedEvents = Collections.unmodifiableSet(consumedEvents);
        }
    }
}

