/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.internal.tasks.ui.AttachmentFileEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

class DownloadAndOpenTaskAttachmentJob
implements ICoreRunnable {
    private final ITaskAttachment attachment;
    private final IWorkbenchPage page;
    private final String editorID;
    private final String jobName;

    DownloadAndOpenTaskAttachmentJob(String jobName, ITaskAttachment attachment, IWorkbenchPage page, String editorID) {
        this.jobName = jobName;
        this.attachment = attachment;
        this.page = page;
        this.editorID = editorID;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(this.jobName, -1);
        try {
            IStatus result = this.execute((IProgressMonitor)new SubProgressMonitor(monitor, 100));
            if (result != null && !result.isOK()) {
                throw new CoreException(result);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IStatus execute(IProgressMonitor monitor) {
        String attachmentFilename = AttachmentUtil.getAttachmentFilename(this.attachment);
        File file = null;
        try {
            file = File.createTempFile("tmpattach-", "-" + attachmentFilename);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e);
        }
        file.deleteOnExit();
        boolean ok = false;
        FilterOutputStream fos = null;
        try {
            try {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                AttachmentUtil.downloadAttachment(this.attachment, fos, monitor);
                ok = true;
            }
            catch (IOException e) {
                Status status;
                block27: {
                    status = new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            if (!ok) break block27;
                            file.delete();
                            return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e2);
                        }
                    }
                }
                if (!ok) {
                    file.delete();
                }
                return status;
            }
            catch (CoreException e) {
                Status status;
                block28: {
                    int s = 4;
                    if (e.getStatus() != null && e.getStatus().getCode() == 8) {
                        throw new OperationCanceledException();
                    }
                    status = new Status(s, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e);
                    if (fos == null) break block28;
                    try {
                        fos.close();
                    }
                    catch (IOException e3) {
                        if (!ok) break block28;
                        file.delete();
                        return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e3);
                    }
                }
                if (!ok) {
                    file.delete();
                }
                return status;
            }
        }
        finally {
            block29: {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        if (!ok) break block29;
                        file.delete();
                        return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_failedToDownloadAttachment, (Throwable)e);
                    }
                }
            }
            if (!ok) {
                file.delete();
            }
        }
        file.setReadOnly();
        Display disp = this.page.getWorkbenchWindow().getWorkbench().getDisplay();
        if (disp.isDisposed()) {
            return new Status(2, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_cannotOpenEditor);
        }
        if (disp.getThread() == Thread.currentThread()) {
            return this.openEditor(file, attachmentFilename);
        }
        AtomicReference status = new AtomicReference();
        File tmpFile = file;
        disp.syncExec(() -> status.set(this.openEditor(tmpFile, attachmentFilename)));
        if (status.get() == null) {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_cannotOpenEditor);
        }
        return (IStatus)status.get();
    }

    IStatus openEditor(File file, String attachmentName) {
        try {
            String taskLabel = this.getTaskLabel(this.attachment.getTask());
            String repoLabel = this.getRepositoryLabel(this.attachment.getTask());
            String tooltip = MessageFormat.format(Messages.DownloadAndOpenTaskAttachmentJob_editorTooltip, taskLabel, repoLabel);
            this.page.openEditor((IEditorInput)new AttachmentFileEditorInput(file, attachmentName, tooltip), this.editorID);
            return Status.OK_STATUS;
        }
        catch (PartInitException e) {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.DownloadAndOpenTaskAttachmentJob_cannotOpenEditor, (Throwable)e);
        }
    }

    private String getTaskLabel(ITask task) {
        String key;
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
        StringBuilder taskLabel = new StringBuilder();
        if (connectorUi != null) {
            taskLabel.append(connectorUi.getTaskKindLabel(task));
        }
        if ((key = task.getTaskKey()) != null) {
            if (taskLabel.length() > 0) {
                taskLabel.append(" ");
            }
            taskLabel.append(key);
        }
        return taskLabel.toString();
    }

    private String getRepositoryLabel(ITask task) {
        String repositoryKind = task.getConnectorKind();
        String repositoryUrl = task.getRepositoryUrl();
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, repositoryUrl);
        if (repository != null) {
            String label = repository.getRepositoryLabel();
            if (label.indexOf("//") != -1) {
                return label.substring(repository.getRepositoryUrl().indexOf("//") + 2);
            }
            return label;
        }
        return "";
    }
}

