/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.ILocationService;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.LocationService;

public abstract class KeyringMigrator<T> {
    protected final ILocationService service = LocationService.getDefault();
    protected final String authRealm;
    protected final String authScheme;

    public KeyringMigrator(String authRealm, String authScheme) {
        this.authRealm = authRealm;
        this.authScheme = authScheme;
    }

    public void migrateCredentials(Collection<T> locations) {
        for (T location : locations) {
            this.migrateCredentials(location);
        }
    }

    protected void migrateCredentials(T location) {
        try {
            Map<String, String> properties = this.getAuthorizationInfo(this.getUrl(location));
            this.putProperties(properties, location);
        }
        catch (MalformedURLException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error migrating keyring credentials for " + this.getUrl(location), (Throwable)e));
        }
    }

    protected Map<String, String> getAuthorizationInfo(String url) throws MalformedURLException {
        return this.getAuthorizationInfo(new URL(url), this.authRealm, this.authScheme);
    }

    protected Map<String, String> getAuthorizationInfo(URL url, String realm, String scheme) throws MalformedURLException {
        return AuthorizationHandler.getAuthorizationInfo((URL)url, (String)realm, (String)scheme);
    }

    protected void putProperties(Map<String, String> properties, T location) {
        if (properties != null) {
            ICredentialsStore store = this.service.getCredentialsStore(this.getUrl(location));
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this.putKeyValue(location, entry.getKey(), entry.getValue(), store);
            }
        }
    }

    protected void putKeyValue(T location, String key, String value, ICredentialsStore store) {
        store.put(key, value, key.endsWith(".password"));
    }

    protected abstract String getUrl(T var1);
}

