/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.tasks.core.data.ITaskAttributeDiff;
import org.eclipse.mylyn.tasks.core.data.ITaskDataDiff;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationParticipant;
import org.eclipse.osgi.util.NLS;

public class SynchronizationManger {
    private final Map<String, List<SynchronizationParticipant>> participantsByConnectorKind = new HashMap<String, List<SynchronizationParticipant>>();
    private List<SynchronizationParticipant> defaultParticipants;
    private final RepositoryModel model;

    public SynchronizationManger(RepositoryModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    /*
     * WARNING - void declaration
     */
    private List<SynchronizationParticipant> loadParticipants(String connectorKind) {
        IExtension[] extensions;
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.tasks.core", 0, "Synchronization participants failed to load.", null);
        ArrayList<SynchronizationParticipant> participants = new ArrayList<SynchronizationParticipant>(1);
        ArrayList<String> attributeIds = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.tasks.core.synchronizationParticipants");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                block11: {
                    String attributeId;
                    String value;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("participant".equals(element.getName())) {
                        value = element.getAttribute("connectorKind");
                        if (value != null && value.equals(connectorKind) || value == connectorKind) {
                            try {
                                Object object;
                                Object object2 = object = element.createExecutableExtension("class");
                                if (object2 instanceof SynchronizationParticipant) {
                                    void participant;
                                    SynchronizationParticipant cfr_ignored_0 = (SynchronizationParticipant)object2;
                                    SynchronizationParticipant cfr_ignored_1 = (SynchronizationParticipant)object2;
                                    participant.setId(element.getAttribute("id"));
                                    participants.add((SynchronizationParticipant)participant);
                                    break block11;
                                }
                                status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Connector core ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                            }
                            catch (Throwable e) {
                                status.add((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Connector core failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                            }
                        }
                    } else if ("suppressIncoming".equals(element.getName()) && ((value = element.getAttribute("connectorKind")) != null && value.equals(connectorKind) || value == connectorKind) && (attributeId = element.getAttribute("attributeId")) != null) {
                        attributeIds.add(attributeId);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (attributeIds.size() > 0) {
            participants.add(new DefaultParticipant(attributeIds, connectorKind));
        }
        if (!status.isOK()) {
            StatusHandler.log((IStatus)status);
        }
        return participants;
    }

    public synchronized boolean hasParticipants(String connectorKind) {
        return this.getDefaultParticipants().size() > 0 || this.getParticipants(connectorKind).size() > 0;
    }

    public synchronized List<SynchronizationParticipant> getParticipants(String connectorKind) {
        List<SynchronizationParticipant> participants = this.participantsByConnectorKind.get(connectorKind);
        if (participants == null) {
            participants = this.loadParticipants(connectorKind);
            this.participantsByConnectorKind.put(connectorKind, participants);
        }
        return participants;
    }

    public synchronized List<SynchronizationParticipant> getDefaultParticipants() {
        if (this.defaultParticipants == null) {
            this.defaultParticipants = this.loadParticipants(null);
        }
        return this.defaultParticipants;
    }

    public synchronized List<SynchronizationParticipant> getIgnoredIncomings(String connectorKind) {
        List<SynchronizationParticipant> participants = this.participantsByConnectorKind.get(connectorKind);
        if (participants == null) {
            participants = this.loadParticipants(connectorKind);
            this.participantsByConnectorKind.put(connectorKind, participants);
        }
        return participants;
    }

    public TaskDataDiff createDiff(TaskData newTaskData, TaskData oldTaskData, final IProgressMonitor monitor) {
        final TaskDataDiff diff = new TaskDataDiff(this.model, newTaskData, oldTaskData);
        for (final SynchronizationParticipant participant : this.getDefaultParticipants()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    participant.processUpdate(diff, monitor);
                }
            });
        }
        for (final SynchronizationParticipant participant : this.getParticipants(newTaskData.getConnectorKind())) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    participant.processUpdate(diff, monitor);
                }
            });
        }
        return diff;
    }

    public static class DefaultParticipant
    extends SynchronizationParticipant {
        private final Set<String> attributeIds;

        public DefaultParticipant(List<String> attributeIds, String connectorKind) {
            Assert.isNotNull(attributeIds);
            this.attributeIds = new HashSet<String>(attributeIds);
            Object id = DefaultParticipant.class.getName();
            if (connectorKind != null) {
                id = (String)id + "." + connectorKind;
            }
            this.setId((String)id);
        }

        @Override
        public void processUpdate(ITaskDataDiff diff, IProgressMonitor monitor) {
            if (diff.getChangedAttributes().size() > 0) {
                Iterator<ITaskAttributeDiff> it = diff.getChangedAttributes().iterator();
                while (it.hasNext()) {
                    ITaskAttributeDiff attributeDiff = it.next();
                    if (!this.attributeIds.contains(attributeDiff.getAttributeId())) continue;
                    it.remove();
                }
            }
        }
    }
}

