/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.util.ArrayList;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.UserAttributeEditor;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GitlabTaskEditorCommentPart
extends TaskEditorCommentPart {
    protected TaskEditorCommentPart.CommentGroupViewer createCommentGroupViewer(CommentGroupStrategy.CommentGroup commentGroup) {
        return new GitlabCommentGroupViewer(commentGroup);
    }

    protected void setUserImage(UserAttributeEditor userImage, TaskAttribute commentAttribute, TaskEditorCommentPart.CommentViewer commentViewer) {
        String commentAuthor = this.getTaskData().getAttributeMapper().mapToRepositoryKey(commentAttribute, "task.common.comment.author");
        TaskAttribute userImageAttribute = commentAttribute.getAttribute(commentAuthor);
        TaskAttribute avatarUrl = userImageAttribute.getAttribute("avatar_url");
        if (avatarUrl != null) {
            GitlabRepositoryConnector gitlabConnector = (GitlabRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(userImageAttribute.getTaskData().getConnectorKind());
            byte[] avatarBytes = gitlabConnector.getAvatarData(avatarUrl.getValue());
            userImage.updateImage((IProfileImage)new ProfileImage(avatarBytes, 30, 30, ""));
        }
    }

    public class GitlabCommentGroupViewer
    extends TaskEditorCommentPart.CommentGroupViewer {
        public GitlabCommentGroupViewer(CommentGroupStrategy.CommentGroup commentGroup) {
            super((TaskEditorCommentPart)GitlabTaskEditorCommentPart.this, commentGroup);
        }

        protected TaskEditorCommentPart.CommentViewer createCommentViewer(TaskAttribute commentAttribute) {
            return new GitlabCommentViewer(commentAttribute);
        }
    }

    public class GitlabCommentViewer
    extends TaskEditorCommentPart.CommentViewer {
        private ArrayList<GitlabCommentViewer> subViewer;

        public GitlabCommentViewer(TaskAttribute commentAttribute) {
            super((TaskEditorCommentPart)GitlabTaskEditorCommentPart.this, commentAttribute);
            this.subViewer = new ArrayList();
        }

        protected void createUserImageControl(FormToolkit toolkit, Composite commentViewer, TaskAttribute commentAttribute) {
            String commentAuthor;
            TaskAttribute userImageAttribute;
            boolean showAvatar = Boolean.parseBoolean(GitlabTaskEditorCommentPart.this.getModel().getTaskRepository().getProperty("gitlab.avantar"));
            if (showAvatar && (userImageAttribute = commentAttribute.getAttribute(commentAuthor = GitlabTaskEditorCommentPart.this.getTaskData().getAttributeMapper().mapToRepositoryKey(commentAttribute, "task.common.comment.author"))) != null) {
                Composite userImageComposite = this.createUserImageComposite(toolkit);
                UserAttributeEditor userImage = new UserAttributeEditor(GitlabTaskEditorCommentPart.this.getModel(), userImageAttribute, 30);
                userImage.createControl(userImageComposite, toolkit);
                TaskAttribute avatarURL = userImageAttribute.getAttribute("avatar_url");
                if (avatarURL != null) {
                    GitlabRepositoryConnector gitlabConnector = (GitlabRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(userImageAttribute.getTaskData().getConnectorKind());
                    byte[] avatarBytes = gitlabConnector.getAvatarData(avatarURL.getValue());
                    userImage.updateImage((IProfileImage)new ProfileImage(avatarBytes, 30, 30, ""));
                }
            }
        }

        protected void createAdditionalControls(FormToolkit toolkit, Composite commentViewer, TaskAttribute commentAttribute) {
            TaskAttribute reply = commentAttribute.getAttribute("reply");
            if (reply != null) {
                Composite replayComposite = new Composite(commentViewer, 0);
                GridLayout replayLayout = new GridLayout(2, false);
                replayLayout.marginHeight = 0;
                replayLayout.marginWidth = 0;
                replayLayout.horizontalSpacing = 0;
                replayComposite.setLayout((Layout)replayLayout);
                replayComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                for (TaskAttribute taskAttributeReply : reply.getAttributes().values()) {
                    TaskComment replyComment = new TaskComment(GitlabTaskEditorCommentPart.this.getModel().getTaskRepository(), GitlabTaskEditorCommentPart.this.getModel().getTask(), taskAttributeReply);
                    commentAttribute.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)replyComment, taskAttributeReply);
                    GitlabCommentViewer replyCommentViewer = new GitlabCommentViewer(taskAttributeReply);
                    this.subViewer.add(replyCommentViewer);
                    replyCommentViewer.createControl(replayComposite, toolkit);
                    GridData subViewerGridData = new GridData(1);
                    subViewerGridData.horizontalSpan = 2;
                    replyCommentViewer.getControl().setLayoutData((Object)subViewerGridData);
                }
            }
        }

        protected void closeAdditionalControls() {
            this.subViewer.forEach(subView -> subView.dispose());
            this.subViewer.clear();
        }
    }
}

