/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GitlabRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private ListViewer groups;
    private ArrayList<String> groupList = new ArrayList();
    private Text groupInput;
    private Button groupRemoveButton;
    private Button groupAddButton;
    private ListViewer projects;
    private ArrayList<String> projectList = new ArrayList();
    private Text projectInput;
    private Button projectRemoveButton;
    private Button projectAddButton;
    private Button avatarSupportButton;
    private Button showActivityIconsButton;
    private Button usePersonalAccessTokenButton;
    private Text personalAccessTokenText;

    public GitlabRepositorySettingsPage(String title, String description, TaskRepository taskRepository) {
        super(title, description, taskRepository);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
        this.setNeedsProxy(false);
    }

    public String getConnectorKind() {
        return "org.eclipse.mylyn.gitlab";
    }

    protected void createAdditionalControls(Composite parent) {
        String accessTokenValue;
        String projectsValue;
        String groupsValue;
        FormToolkit toolkit = new FormToolkit(TasksUiPlugin.getDefault().getFormColors(parent.getDisplay()));
        Composite aditionalContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(3).applyTo(aditionalContainer);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)aditionalContainer);
        Label groupsLabel = new Label(aditionalContainer, 0);
        groupsLabel.setText("include Groups");
        GridData gd = new GridData(4);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        groupsLabel.setLayoutData((Object)gd);
        this.groups = new ListViewer(aditionalContainer, 768);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.groups.getList().setLayoutData((Object)gd);
        this.groups.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.groups.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        if (this.repository != null && (groupsValue = this.repository.getProperty("gitlab.groups")) != null) {
            this.groupList = new ArrayList<String>(Arrays.asList(groupsValue.split(",")));
        }
        this.groups.setInput(this.groupList);
        this.groupInput = new Text(aditionalContainer, 0);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.groupInput.setLayoutData((Object)gd);
        this.groupInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.groups.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    GitlabRepositorySettingsPage.this.groupInput.setText((String)selection.getFirstElement());
                }
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.groupAddButton = new Button(aditionalContainer, 8);
        this.groupAddButton.setText("Add");
        this.groupAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitlabRepositorySettingsPage.this.groupList.add(GitlabRepositorySettingsPage.this.groupInput.getText());
                GitlabRepositorySettingsPage.this.groupInput.setText("");
                GitlabRepositorySettingsPage.this.groups.refresh();
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.groupRemoveButton = new Button(aditionalContainer, 8);
        this.groupRemoveButton.setText("remove");
        this.groupRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GitlabRepositorySettingsPage.this.groups.getSelection();
                int lastIdx = -1;
                if (selection != null) {
                    Object firstElement = selection.getFirstElement();
                    lastIdx = GitlabRepositorySettingsPage.this.groupList.indexOf(firstElement);
                }
                GitlabRepositorySettingsPage.this.groupList.remove(GitlabRepositorySettingsPage.this.groupInput.getText());
                GitlabRepositorySettingsPage.this.groupInput.setText("");
                GitlabRepositorySettingsPage.this.groups.refresh();
                if (lastIdx >= 0 && lastIdx < GitlabRepositorySettingsPage.this.groupList.size()) {
                    GitlabRepositorySettingsPage.this.groups.setSelection((ISelection)new StructuredSelection((Object)GitlabRepositorySettingsPage.this.groupList.get(lastIdx)), true);
                }
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        Label projectsLabel = new Label(aditionalContainer, 0);
        projectsLabel.setText("include Projects");
        gd = new GridData(4);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        projectsLabel.setLayoutData((Object)gd);
        this.projects = new ListViewer(aditionalContainer, 768);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.projects.getList().setLayoutData((Object)gd);
        this.projects.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.projects.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        if (this.repository != null && (projectsValue = this.repository.getProperty("gitlab.projects")) != null) {
            this.projectList = new ArrayList<String>(Arrays.asList(projectsValue.split(",")));
        }
        this.projects.setInput(this.projectList);
        this.projectInput = new Text(aditionalContainer, 0);
        gd = new GridData(32);
        gd.widthHint = 200;
        this.projectInput.setLayoutData((Object)gd);
        this.projectInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.projects.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    GitlabRepositorySettingsPage.this.projectInput.setText((String)selection.getFirstElement());
                }
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.projectAddButton = new Button(aditionalContainer, 8);
        this.projectAddButton.setText("Add");
        this.projectAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitlabRepositorySettingsPage.this.projectList.add(GitlabRepositorySettingsPage.this.projectInput.getText());
                GitlabRepositorySettingsPage.this.projectInput.setText("");
                GitlabRepositorySettingsPage.this.projects.refresh();
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.projectRemoveButton = new Button(aditionalContainer, 8);
        this.projectRemoveButton.setText("remove");
        this.projectRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GitlabRepositorySettingsPage.this.projects.getSelection();
                int lastIdx = -1;
                if (selection != null) {
                    Object firstElement = selection.getFirstElement();
                    lastIdx = GitlabRepositorySettingsPage.this.projectList.indexOf(firstElement);
                }
                GitlabRepositorySettingsPage.this.projectList.remove(GitlabRepositorySettingsPage.this.projectInput.getText());
                GitlabRepositorySettingsPage.this.projectInput.setText("");
                GitlabRepositorySettingsPage.this.projects.refresh();
                if (lastIdx >= 0 && lastIdx < GitlabRepositorySettingsPage.this.projectList.size()) {
                    GitlabRepositorySettingsPage.this.projects.setSelection((ISelection)new StructuredSelection((Object)GitlabRepositorySettingsPage.this.projectList.get(lastIdx)), true);
                }
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.avatarSupportButton = new Button(aditionalContainer, 32);
        this.avatarSupportButton.setText("Show Avantars");
        this.avatarSupportButton.setSelection(this.getRepository() != null && Boolean.parseBoolean(this.getRepository().getProperty("gitlab.avantar")));
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.avatarSupportButton.setLayoutData((Object)gd);
        this.showActivityIconsButton = new Button(aditionalContainer, 32);
        this.showActivityIconsButton.setText("Show Activity Icons");
        if (this.getRepository() != null) {
            String value = this.getRepository().getProperty("gitlab.show.activity.icons");
            this.showActivityIconsButton.setSelection(value == null ? true : Boolean.parseBoolean(value));
        }
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.showActivityIconsButton.setLayoutData((Object)gd);
        this.usePersonalAccessTokenButton = new Button(aditionalContainer, 32);
        this.usePersonalAccessTokenButton.setText("use personal access token");
        this.usePersonalAccessTokenButton.setSelection(this.getRepository() != null && Boolean.parseBoolean(this.getRepository().getProperty("gitlab.use.personal.access.token")));
        gd = new GridData(1);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        this.usePersonalAccessTokenButton.setLayoutData((Object)gd);
        this.usePersonalAccessTokenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitlabRepositorySettingsPage.this.updateUIEnablement();
            }
        });
        this.personalAccessTokenText = new Text(aditionalContainer, 0);
        String string = accessTokenValue = this.getRepository() != null ? this.getRepository().getProperty("gitlab.personal.access.token") : null;
        if (accessTokenValue == null) {
            accessTokenValue = "";
        }
        this.personalAccessTokenText.setText(accessTokenValue);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.personalAccessTokenText.setLayoutData((Object)gd);
        this.updateUIEnablement();
    }

    private void updateUIEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.groups.getSelection();
        this.groupRemoveButton.setEnabled(selection.size() > 0);
        this.groupAddButton.setEnabled(!this.groupInput.getText().isEmpty());
        selection = (IStructuredSelection)this.projects.getSelection();
        this.projectRemoveButton.setEnabled(selection.size() > 0);
        this.projectAddButton.setEnabled(!this.projectInput.getText().isEmpty());
        this.personalAccessTokenText.setEnabled(this.usePersonalAccessTokenButton.getSelection());
    }

    public void applyTo(TaskRepository repository) {
        repository.setProperty("gitlab.groups", this.groupList.size() == 0 ? null : String.join((CharSequence)",", this.groupList));
        repository.setProperty("gitlab.projects", this.projectList.size() == 0 ? null : String.join((CharSequence)",", this.projectList));
        repository.setProperty("gitlab.avantar", Boolean.toString(this.avatarSupportButton.getSelection()));
        repository.setProperty("gitlab.show.activity.icons", Boolean.toString(this.showActivityIconsButton.getSelection()));
        repository.setProperty("gitlab.use.personal.access.token", Boolean.toString(this.usePersonalAccessTokenButton.getSelection()));
        repository.setProperty("gitlab.personal.access.token", this.personalAccessTokenText.getText());
        super.applyTo(repository);
    }
}

