/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.linker;

import com.google.gwt.core.ext.LinkerContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.linker.AbstractLinker;
import com.google.gwt.core.ext.linker.Artifact;
import com.google.gwt.core.ext.linker.ArtifactSet;
import com.google.gwt.core.ext.linker.CompilationResult;
import com.google.gwt.core.ext.linker.LinkerOrder;
import com.google.gwt.core.ext.linker.Shardable;
import com.google.gwt.core.ext.linker.SymbolData;
import com.google.gwt.core.ext.linker.SyntheticArtifact;
import com.google.gwt.rpc.linker.CastableTypeDataImpl;
import com.google.gwt.rpc.linker.RpcDataArtifact;
import com.google.gwt.rpc.server.WebModeClientOracle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LinkerOrder(value=LinkerOrder.Order.PRE)
@Shardable
public class ClientOracleLinker
extends AbstractLinker {
    private static final String SUFFIX = ".gwt.rpc";

    public String getDescription() {
        return "deRPC linker";
    }

    public ArtifactSet link(TreeLogger logger, LinkerContext context, ArtifactSet artifacts, boolean onePermutation) throws UnableToCompleteException {
        if (onePermutation) {
            artifacts = new ArtifactSet((Collection)artifacts);
            HashMap<String, List<String>> allSerializableFields = new HashMap<String, List<String>>();
            for (RpcDataArtifact data : artifacts.find(RpcDataArtifact.class)) {
                allSerializableFields.putAll(data.getOperableFields());
            }
            for (CompilationResult result : artifacts.find(CompilationResult.class)) {
                WebModeClientOracle.Builder builder = new WebModeClientOracle.Builder();
                for (Map.Entry entry : allSerializableFields.entrySet()) {
                    builder.setSerializableFields((String)entry.getKey(), (List)entry.getValue());
                }
                for (SymbolData symbolData : result.getSymbolMap()) {
                    String castableTypeMapString = symbolData.getCastableTypeMap() == null ? null : symbolData.getCastableTypeMap().toJs();
                    builder.add(symbolData.getSymbolName(), symbolData.getJsniIdent(), symbolData.getClassName(), symbolData.getMemberName(), symbolData.getQueryId(), new CastableTypeDataImpl(castableTypeMapString));
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    builder.getOracle().store(out);
                }
                catch (IOException e) {
                    logger.log(TreeLogger.ERROR, "Unable to store deRPC data", (Throwable)e);
                    throw new UnableToCompleteException();
                }
                SyntheticArtifact a = this.emitBytes(logger, out.toByteArray(), result.getStrongName() + SUFFIX);
                artifacts.add((Artifact)a);
            }
        }
        return artifacts;
    }
}

