/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.editor.client.impl.DelegateMap;
import com.google.gwt.editor.client.impl.SimpleBeanEditorDelegate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleBeanEditorDriver<T, E extends Editor<T>>
implements SimpleBeanEditorDriver<T, E> {
    private SimpleBeanEditorDelegate<T, E> delegate;
    private DelegateMap delegateMap = new DelegateMap(DelegateMap.IDENTITY);
    private E editor;
    private List<EditorError> errors;
    private T object;

    @Override
    public void edit(T object) {
        this.checkEditor();
        this.object = object;
        this.delegate = this.createDelegate();
        this.delegate.initialize("", object, this.editor, this.delegateMap);
        this.delegateMap.put(object, this.delegate);
    }

    @Override
    public T flush() {
        this.checkDelegate();
        this.errors = new ArrayList<EditorError>();
        this.delegate.flush(this.errors);
        return this.object;
    }

    @Override
    public List<EditorError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void initialize(E editor) {
        this.editor = editor;
    }

    protected abstract SimpleBeanEditorDelegate<T, E> createDelegate();

    DelegateMap getDelegateMap() {
        return this.delegateMap;
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Must call edit() first");
        }
    }

    private void checkEditor() {
        if (this.editor == null) {
            throw new IllegalStateException("Must call initialize() first");
        }
    }
}

