/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.core.op.FetchOperation;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class CheckoutPullRequestHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.checkoutPullRequest";

    private RevCommit getBase(Repository repo, PullRequest request) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walk = new RevWalk(repo);){
            return walk.parseCommit((AnyObjectId)repo.resolve(request.getBase().getSha()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final TaskData data = this.getTaskData(event);
        if (data == null) {
            return null;
        }
        Job job = new Job(MessageFormat.format(Messages.CheckoutPullRequestHandler_JobName, data.getTaskId())){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                try {
                    PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
                    if (prComp == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    PullRequest request = prComp.getRequest();
                    Repository repo = PullRequestUtils.getRepository((PullRequest)request);
                    if (repo == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        String branchName = PullRequestUtils.getBranchName((PullRequest)request);
                        Ref branchRef = repo.findRef(branchName);
                        RemoteConfig remote = null;
                        String headBranch = null;
                        if (!PullRequestUtils.isFromSameRepository((PullRequest)request)) {
                            progress.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskAddRemote, request.getHead().getRepo().getOwner().getLogin()));
                            remote = PullRequestUtils.addRemote((Repository)repo, (PullRequest)request);
                            headBranch = PullRequestUtils.getHeadBranch((PullRequest)request);
                        } else {
                            remote = PullRequestUtils.getRemoteConfig((Repository)repo, (String)"origin");
                            headBranch = request.getHead().getRef();
                        }
                        progress.worked(1);
                        if (branchRef == null) {
                            progress.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskCreateBranch, branchName));
                            PullRequestUtils.configureTopicBranch((Repository)repo, (PullRequest)request);
                            new CreateLocalBranchOperation(repo, branchName, CheckoutPullRequestHandler.this.getBase(repo, request)).execute((IProgressMonitor)progress.newChild(1));
                        }
                        if (!PullRequestUtils.isCurrentBranch((String)branchName, (Repository)repo)) {
                            progress.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskCheckoutBranch, branchName));
                            BranchOperationUI.checkout((Repository)repo, (String)branchName).run((IProgressMonitor)progress.newChild(1));
                        }
                        progress.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskFetching, remote.getName()));
                        new FetchOperation(repo, remote, GitSettings.getRemoteConnectionTimeout(), false).run((IProgressMonitor)progress.newChild(1));
                        progress.subTask(MessageFormat.format(Messages.CheckoutPullRequestHandler_TaskMerging, headBranch));
                        new MergeOperation(repo, headBranch).execute((IProgressMonitor)progress.newChild(1));
                        CheckoutPullRequestHandler.this.executeCallback(event);
                    }
                    catch (IOException e) {
                        GitHubUi.logError(e);
                    }
                    catch (CoreException e) {
                        GitHubUi.logError(e);
                    }
                    catch (URISyntaxException e) {
                        GitHubUi.logError(e);
                    }
                    catch (InvocationTargetException e) {
                        GitHubUi.logError(e);
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(job, event);
        return null;
    }
}

