/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.internal.gerrit.core.GerritQueryResultSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritReviewDetailSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.Messages;
import org.eclipse.mylyn.internal.gerrit.ui.editor.PatchSetSection;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorAttributePart;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewTaskEditorPage;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewDetailSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class GerritTaskEditorPage
extends AbstractReviewTaskEditorPage {
    public GerritTaskEditorPage(TaskEditor editor) {
        super(editor, GerritTaskEditorPage.class.getName(), Messages.GerritTaskEditorPage_Gerrit_Page, "org.eclipse.mylyn.gerrit");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmit(false);
        this.setNeedsSubmitButton(false);
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                if (taskAttribute.getId().equals(GerritTaskSchema.getDefault().CHANGE_ID.getKey())) {
                    AbstractAttributeEditor editor = super.createEditor(type, taskAttribute);
                    editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
                    return editor;
                }
                if (taskAttribute.getId().equals(GerritTaskSchema.getDefault().PROJECT.getKey())) {
                    AbstractAttributeEditor editor = super.createEditor(type, taskAttribute);
                    editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
                    return editor;
                }
                if ("person".equals(type)) {
                    return new PersonAttributeEditor(GerritTaskEditorPage.this.getModel(), taskAttribute){

                        public String getValue() {
                            if (this.isReadOnly()) {
                                return this.getModel().getTaskData().getAttributeMapper().getValueLabel(this.getTaskAttribute());
                            }
                            return this.getTaskAttribute().getValue();
                        }
                    };
                }
                return super.createEditor(type, taskAttribute);
            }
        };
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        LinkedHashSet<TaskEditorPartDescriptor> descriptors = new LinkedHashSet<TaskEditorPartDescriptor>();
        Set superDescriptors = super.createPartDescriptors();
        TaskEditorPartDescriptor commentsDescriptor = null;
        TaskEditorPartDescriptor newCommentsDescriptor = null;
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : superDescriptors) {
            TaskEditorPartDescriptor descriptor = this.getNewDescriptor(taskEditorPartDescriptor);
            if (descriptor == null) continue;
            if ("org.eclipse.mylyn.tasks.ui.editors.parts.comments".equals(descriptor.getId())) {
                commentsDescriptor = descriptor;
                continue;
            }
            if ("org.eclipse.mylyn.tasks.ui.editors.parts.newComment".equals(descriptor.getId())) {
                newCommentsDescriptor = descriptor;
                continue;
            }
            descriptors.add(descriptor);
        }
        descriptors.add(new TaskEditorPartDescriptor(ReviewDetailSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new GerritReviewDetailSection();
            }
        });
        descriptors.add(new TaskEditorPartDescriptor(ReviewSetSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new PatchSetSection();
            }
        });
        if (commentsDescriptor != null) {
            descriptors.add(commentsDescriptor);
        }
        if (newCommentsDescriptor != null) {
            descriptors.add(newCommentsDescriptor);
        }
        return descriptors;
    }

    private TaskEditorPartDescriptor getNewDescriptor(TaskEditorPartDescriptor descriptor) {
        if ("actions".equals(descriptor.getPath()) || "people".equals(descriptor.getPath())) {
            return null;
        }
        if ("org.eclipse.mylyn.tasks.ui.editors.parts.attributes".equals(descriptor.getId())) {
            return new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.attributes"){

                public AbstractTaskEditorPart createPart() {
                    return new GerritAttributePart();
                }
            };
        }
        return descriptor;
    }

    final class GerritAttributePart
    extends TaskEditorAttributePart {
        GerritAttributePart() {
        }

        protected List<TaskAttribute> getOverlayAttributes() {
            TaskAttribute root = this.getModel().getTaskData().getRoot();
            ArrayList<TaskAttribute> attributes = new ArrayList<TaskAttribute>();
            TaskAttribute project = root.getAttribute(GerritQueryResultSchema.getDefault().PROJECT.getKey());
            TaskAttribute branch = root.getAttribute(GerritQueryResultSchema.getDefault().BRANCH.getKey());
            if (project != null) {
                attributes.add(project);
            }
            if (branch != null) {
                attributes.add(branch);
            }
            return attributes;
        }
    }
}

