/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.XslfoDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class XslfoDocumentBuilderTest
extends TestCase {
    private StringWriter out;
    private XslfoDocumentBuilder documentBuilder;
    private MarkupParser parser;

    protected void setUp() throws Exception {
        this.out = new StringWriter();
        this.documentBuilder = new XslfoDocumentBuilder((XmlStreamWriter)new DefaultXmlStreamWriter((Writer)this.out));
        this.parser = new MarkupParser();
        this.parser.setBuilder((DocumentBuilder)this.documentBuilder);
    }

    public void testXslFoNoMissingBlock_bug304013() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n{{NonExistantTemplate}}\n\n= H1 =\n\n== H2 ==\n\nsome text");
        XslfoDocumentBuilderTest.assertFalse((boolean)Pattern.compile("<static-content[^>]*></static-content>").matcher(this.out.toString()).find());
    }

    public void testForXslFoBookmarks_bug336592() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n= Bookmark H1 =\n== Bookmark H2 ==\n");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n= Bookmark H1 =\n== Bookmark H2 ==\n", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<bookmark-tree>\\s*<bookmark internal-destination=\"Bookmark_H1\">\\s*<bookmark-title>Bookmark H1</bookmark-title>\\s*<bookmark internal-destination=\"Bookmark_H2\">\\s*<bookmark-title>Bookmark H2</bookmark-title>\\s*</bookmark>\\s*</bookmark>\\s*</bookmark-tree>").matcher(xslfo).find());
    }

    public void testforTableCSSAttributes_bug336813() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("{| style=\"border-style: solid; border-color: #000; border-width: 1px;\"\n|-\n! header 1\n! header 2\n! header 3\n|-\n| row 1, cell 1\n| row 1, cell 2\n| row 1, cell 3\n|- style=\"border-style: solid; border-color: #000; border-width: 1px;\" \n| row 2, cell 1\n| row 2, cell 2\n| style=\"border-style: solid; border-color: #000; border-width: 1px;\" | row 2, cell 3\n|}");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("{| style=\"border-style: solid; border-color: #000; border-width: 1px;\"\n|-\n! header 1\n! header 2\n! header 3\n|-\n| row 1, cell 1\n| row 1, cell 2\n| row 1, cell 3\n|- style=\"border-style: solid; border-color: #000; border-width: 1px;\" \n| row 2, cell 1\n| row 2, cell 2\n| style=\"border-style: solid; border-color: #000; border-width: 1px;\" | row 2, cell 3\n|}", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-body border-color=\"#000\" border-style=\"solid\" border-width=\"1px\">").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-row border-color=\"#000\" border-style=\"solid\" border-width=\"1px\">").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<block font-size=\"10.0pt\" border-color=\"#000\" border-style=\"solid\" border-width=\"1px\">").matcher(xslfo).find());
    }

    public void testforTableSpan_bug336813() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("{|\n|-\n| Column 1 || Column 2 || Column 3\n|-\n| rowspan=\"2\"| A\n| colspan=\"2\" | B\n|-\n| C <!-- column 1 occupied by cell A -->\n| D \n|-\n| E\n| rowspan=\"2\" colspan=\"2\" | F\n|- \n| G <!-- column 2+3 occupied by cell F -->\n|- \n| colspan=\"3\" | H\n|}");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("{|\n|-\n| Column 1 || Column 2 || Column 3\n|-\n| rowspan=\"2\"| A\n| colspan=\"2\" | B\n|-\n| C <!-- column 1 occupied by cell A -->\n| D \n|-\n| E\n| rowspan=\"2\" colspan=\"2\" | F\n|- \n| G <!-- column 2+3 occupied by cell F -->\n|- \n| colspan=\"3\" | H\n|}", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-cell number-rows-spanned=\"2\" padding-left=\"2pt\" padding-right=\"2pt\" padding-top=\"2pt\" padding-bottom=\"2pt\">").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-cell number-columns-spanned=\"2\" padding-left=\"2pt\" padding-right=\"2pt\" padding-top=\"2pt\" padding-bottom=\"2pt\">").matcher(xslfo).find());
    }

    public void testforTableRowAlign_bug336813() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("{|\n|- valign=\"top\"\n |'''Row heading'''\n| A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- style=\"vertical-align: bottom;\"\n |'''Row heading'''\n|A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("{|\n|- valign=\"top\"\n |'''Row heading'''\n| A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- style=\"vertical-align: bottom;\"\n |'''Row heading'''\n|A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-row display-align=\"before\">").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-row display-align=\"after\">").matcher(xslfo).find());
    }

    public void testforTableCellAlign_bug336813() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("{|\n|- \n |'''Row heading'''\n| valign=\"top\" | A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- \n |'''Row heading'''\n| style=\"vertical-align: bottom;\" | A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("{|\n|- \n |'''Row heading'''\n| valign=\"top\" | A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- \n |'''Row heading'''\n| style=\"vertical-align: bottom;\" | A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-cell display-align=\"before\"").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<block font-size=\"10.0pt\" display-align=\"after\">").matcher(xslfo).find());
    }

    public void testforTableCellTextAlign_bug336813() {
        this.documentBuilder.getConfiguration().setPageNumbering(true);
        this.documentBuilder.getConfiguration().setTitle("Title");
        OutlineItem op = new OutlineParser((MarkupLanguage)new MediaWikiLanguage()).parse("{|\n|- \n |'''Row heading'''\n| align=\"left\" | A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- \n |'''Row heading'''\n| style=\"text-align: right;\" | A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}");
        this.documentBuilder.setOutline(op);
        this.parser.setMarkupLanguage((MarkupLanguage)new MediaWikiLanguage());
        this.parser.parse("{|\n|- \n |'''Row heading'''\n| align=\"left\" | A longer piece of text. Lorem ipsum...\n |A shorter piece of text.\n|- \n |'''Row heading'''\n| style=\"text-align: right;\" | A longer piece of text. Lorem ipsum... \n |A shorter piece of text.\n|}", true);
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<table-cell text-align=\"left\"").matcher(xslfo).find());
        XslfoDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<block font-size=\"10.0pt\" text-align=\"right\">").matcher(xslfo).find());
    }

    public void testforXslFoLinks() {
        this.documentBuilder.getConfiguration().setPageNumbering(false);
        this.documentBuilder.getConfiguration().setTitle("Title");
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.parser.parse("\"INTERN-LABEL\":#intern_label\n\"*INTERN-BOLD-LABEL*\":#intern_bold_label\n\"EXTERN-LABEL\":http://extern-label.com/\n");
        String xslfo = this.out.toString();
        XslfoDocumentBuilderTest.assertTrue((boolean)xslfo.contains("<basic-link internal-destination=\"intern_label\">INTERN-LABEL</basic-link>"));
        XslfoDocumentBuilderTest.assertTrue((boolean)xslfo.contains("<basic-link internal-destination=\"intern_bold_label\"><inline font-weight=\"bold\">INTERN-BOLD-LABEL</inline></basic-link>"));
        XslfoDocumentBuilderTest.assertTrue((boolean)xslfo.contains("<basic-link external-destination=\"url(http://extern-label.com/)\">EXTERN-LABEL</basic-link>"));
    }
}

