/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.dialogs;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsUiPlugin;
import org.eclipse.mylyn.internal.reviews.ui.dialogs.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.review.IReviewRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CommentInputDialog
extends FormDialog {
    private Text fCommentInputTextField;
    private static final int BUTTON_REPLY_ID = 2;
    private static final int BUTTON_REPLY_DONE_ID = 3;
    private static final int BUTTON_DISCARD_ID = 4;
    private static final int BUTTON_EDIT_ID = 5;
    private static final int BUTTON_SAVE_ID = 6;
    private static final String RESIZABLE_DIALOG_SETTINGS = "MyResizableDialogSettings";
    private final ReviewBehavior reviewBehavior;
    private final IReviewItem reviewitem;
    private final LineRange range;
    private List<IComment> commentList;
    private List<Button> commentButtons;
    private boolean isUpdate = false;
    private boolean isDiscard = false;
    private boolean isSave = false;
    private boolean isDone = false;
    private boolean isReply = false;
    private String currentUuid;
    private Composite buttonparent;
    private final Shell parent;

    public CommentInputDialog(Shell aParentShell, ReviewBehavior reviewBehavior, IReviewItem reviewitm, LineRange range) {
        super(aParentShell);
        this.setShellStyle(112);
        this.reviewBehavior = reviewBehavior;
        this.reviewitem = reviewitm;
        this.range = range;
        this.parent = aParentShell;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = ReviewsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(RESIZABLE_DIALOG_SETTINGS);
        if (section == null) {
            return settings.addNewSection(RESIZABLE_DIALOG_SETTINGS);
        }
        return section;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.buttonPressed(0);
            this.parent.setFocus();
            return;
        }
        IComment comment = IReviewsFactory.INSTANCE.createComment();
        comment.setDescription(this.fCommentInputTextField.getText().trim());
        switch (buttonId) {
            case 5: {
                comment.setId(this.currentUuid);
                this.disposeButtons();
                this.createSaveDiscard();
                return;
            }
            case 4: {
                comment.setId(this.currentUuid);
                this.isDiscard = true;
                break;
            }
            case 2: {
                comment.setId(this.currentUuid);
                this.isSave = true;
                this.isReply = true;
                this.disposeButtons();
                this.createSave();
                this.fCommentInputTextField.setText("");
                break;
            }
            case 3: {
                this.isSave = true;
                this.isDone = true;
                comment.setDescription(Messages.CommentInputDialog_Done);
                comment.setId("");
                break;
            }
            case 6: {
                comment.setId(this.currentUuid);
                this.isSave = true;
                if (!this.isReply) break;
                this.isDone = true;
                comment.setId("");
                this.isReply = false;
            }
        }
        comment.setDraft(true);
        comment.setAuthor(this.getCurrentUser());
        comment.setCreationDate(new Date());
        ILineLocation location = this.getSelectedLineLocation();
        if (location != null) {
            comment.getLocations().add(location);
        }
        if (buttonId != 2) {
            this.performOperation(comment);
            super.buttonPressed(0);
        }
    }

    private ILineLocation getSelectedLineLocation() {
        ILineLocation location = IReviewsFactory.INSTANCE.createLineLocation();
        ILineRange lineRange = IReviewsFactory.INSTANCE.createLineRange();
        lineRange.setStart(this.range.getStartLine());
        lineRange.setEnd(this.range.getStartLine() + this.range.getNumberOfLines());
        location.getRanges().add(lineRange);
        return location;
    }

    private IUser getCurrentUser() {
        if (this.reviewitem != null && this.reviewitem.getReview() != null && this.reviewitem.getReview().getRepository() != null) {
            return this.reviewitem.getReview().getRepository().getAccount();
        }
        return null;
    }

    private boolean performOperation(final IComment comment) {
        final IReviewItem item = this.reviewitem;
        final AtomicReference result = new AtomicReference();
        if (this.isSave || this.isDiscard) {
            Job job = new Job(Messages.CommandServerOperation){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = null;
                    if (CommentInputDialog.this.isSave) {
                        status = CommentInputDialog.this.reviewBehavior.addComment(item, comment, monitor);
                        if (status.isOK()) {
                            result.set(status);
                            CommentInputDialog.this.updateClient(comment, item);
                            return Status.OK_STATUS;
                        }
                    } else {
                        status = CommentInputDialog.this.reviewBehavior.discardComment(item, comment, monitor);
                        if (status.isOK()) {
                            result.set(status);
                            CommentInputDialog.this.updateClient(comment, item);
                            return Status.OK_STATUS;
                        }
                    }
                    CommentInputDialog.this.processServerError(status.getMessage());
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return true;
    }

    private void updateClient(IComment comment, IReviewItem item) {
        List commentlist;
        comment.setAuthor(this.getCurrentUser());
        if (!this.isUpdate || this.isDone) {
            item.getComments().add(comment);
        } else if (this.isDiscard) {
            commentlist = item.getComments();
            Iterator iter = commentlist.iterator();
            while (iter.hasNext()) {
                IComment element = (IComment)iter.next();
                if (element.getId() == null || !element.getId().equals(this.currentUuid)) continue;
                iter.remove();
                break;
            }
        } else {
            commentlist = item.getComments();
            int i = 0;
            while (i < commentlist.size()) {
                if (((IComment)commentlist.get(i)).getId() != null && ((IComment)commentlist.get(i)).getId().equals(this.currentUuid)) {
                    item.getComments().set(i, comment);
                    break;
                }
                ++i;
            }
        }
        IFileItem file = null;
        if (item instanceof IFileItem) {
            file = (IFileItem)item;
        } else if (item instanceof IFileVersion) {
            file = ((IFileVersion)item).getFile();
        }
        if (file != null && file.getReview() != null) {
            this.updateConsumer(file);
        }
    }

    private void processServerError(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(null, Messages.CommentInputDialog_ServerError, null, message, 1, new String[]{IDialogConstants.CANCEL_LABEL}, 0);
                dialog.open();
            }
        });
    }

    private void updateConsumer(IFileItem file) {
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(this.reviewBehavior.getTask().getConnectorKind(), this.reviewBehavior.getTask().getRepositoryUrl());
        ReviewsConnector connector = (ReviewsConnector)TasksUiPlugin.getConnector((String)this.reviewBehavior.getTask().getConnectorKind());
        IReviewRemoteFactoryProvider factoryProvider = (IReviewRemoteFactoryProvider)connector.getReviewClient(taskRepository).getFactoryProvider();
        RemoteEmfConsumer consumer = factoryProvider.getReviewItemSetContentFactory().getConsumerForLocalKey((EObject)file.getSet(), (Object)file.getSet().getId());
        consumer.updateObservers();
        consumer.release();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.selectComment(this.commentList.get(this.commentList.size() - 1));
        this.commentButtons.get(this.commentButtons.size() - 1).setSelection(true);
        return contents;
    }

    protected void createFormContent(IManagedForm mform) {
        ScrolledForm scrolledform = mform.getForm();
        scrolledform.setExpandVertical(true);
        scrolledform.setExpandHorizontal(true);
        Composite composite = scrolledform.getBody();
        scrolledform.setContent((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        this.commentButtons = new ArrayList<Button>();
        for (final IComment comment : this.commentList) {
            Button commentSelectionButton = new Button(composite, 16);
            commentSelectionButton.setBackground(composite.getBackground());
            String authorAndDate = comment.getAuthor() != null ? String.valueOf(comment.getAuthor().getDisplayName()) + " " + comment.getCreationDate().toString() : String.valueOf(Messages.CommentInputDialog_No_author) + " " + comment.getCreationDate().toString();
            String commentPrefix = StringUtils.abbreviate((String)comment.getDescription(), (int)50);
            if (comment.isDraft()) {
                commentSelectionButton.setText(NLS.bind((String)Messages.CommentInputDialog_Draft, (Object)authorAndDate, (Object)commentPrefix));
            } else {
                commentSelectionButton.setText(String.valueOf(authorAndDate) + " " + commentPrefix);
            }
            commentSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CommentInputDialog.this.selectComment(comment);
                }
            });
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)commentSelectionButton);
            this.commentButtons.add(commentSelectionButton);
        }
        this.fCommentInputTextField = new Text(composite, 2114);
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 2;
        textGridData.minimumHeight = this.fCommentInputTextField.getLineHeight() * 4;
        this.fCommentInputTextField.setToolTipText(Messages.ReviewsCommentToolTip);
        this.fCommentInputTextField.setLayoutData((Object)textGridData);
        this.fCommentInputTextField.setEnabled(false);
        this.fCommentInputTextField.setFocus();
        this.setHelpAvailable(false);
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        composite.setLayoutData((Object)new GridData(16384, 1024, true, false));
        composite.setFont(parent.getFont());
        Control buttonSection = super.createButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)buttonSection.getLayoutData()).grabExcessVerticalSpace = false;
        buttonSection.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CommentInputDialog.this.buttonBar.pack();
            }
        });
        return composite;
    }

    public void createButtonsForButtonBar(Composite parent) {
        this.buttonparent = parent;
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    public void setComments(List<IComment> commentList) {
        this.commentList = commentList;
    }

    private void selectComment(IComment comment) {
        this.disposeButtons();
        if (comment.isDraft()) {
            this.createEdit();
        } else {
            this.createReplyReplyDone();
        }
        this.currentUuid = comment.getId();
        this.fCommentInputTextField.setText(comment.getDescription());
        this.isUpdate = true;
    }

    private void disposeButtons() {
        int[] nArray = new int[]{2, 3, 4, 5, 6};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int buttonId = nArray[n2];
            Button button = this.getButton(buttonId);
            if (button != null) {
                button.dispose();
            }
            ++n2;
        }
        if (this.fCommentInputTextField != null) {
            this.fCommentInputTextField.setEnabled(false);
        }
    }

    private void createEdit() {
        this.createButton(this.buttonparent, 5, Messages.CommentInputDialog_Edit, true);
        this.buttonBar.pack();
    }

    private void createReplyReplyDone() {
        this.createButton(this.buttonparent, 2, Messages.CommentInputDialog_Reply, true);
        this.createButton(this.buttonparent, 3, Messages.CommentInputDialog_ReplyDone, true);
        this.buttonBar.pack();
    }

    private void createSaveDiscard() {
        this.createButton(this.buttonparent, 6, Messages.CommentInputDialog_Save, true);
        this.createButton(this.buttonparent, 4, Messages.CommentInputDialog_Discard, true);
        this.fCommentInputTextField.setEnabled(true);
        this.buttonBar.pack();
    }

    private void createSave() {
        this.createButton(this.buttonparent, 6, Messages.CommentInputDialog_Save, true);
        this.fCommentInputTextField.setEnabled(true);
        this.buttonBar.pack();
    }
}

