/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.Version;

public class GerritVersion {
    public static final Version VERSION_2_4_0 = new Version(2, 4, 0);
    public static final Version VERSION_2_5_0 = new Version(2, 5, 0);
    public static final Version VERSION_2_6_0 = new Version(2, 6, 0);
    public static final Version VERSION_2_7_0 = new Version(2, 7, 0);
    public static final Version VERSION_2_8_0 = new Version(2, 8, 0);
    public static final Version VERSION_2_9_0 = new Version(2, 9, 0);
    private static final Pattern MAJOR_MINOR_MICRO_VERSION_PATTERN = Pattern.compile("V?\\d+\\.\\d+(\\.\\d+)?");
    private static final Pattern MAJOR_MINOR_QUALIFIER_VERSION_PATTERN = Pattern.compile("V?(\\d+)\\.(\\d+)-([-\\w]+).*");
    private static final Pattern MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN = Pattern.compile("V?(\\d+)\\.(\\d+)\\.(\\d+)[-\\.]([-\\w]+).*");

    private GerritVersion() {
    }

    public static Version parseGerritVersion(String version) {
        Assert.isLegal((version != null ? 1 : 0) != 0);
        Assert.isLegal((!version.isEmpty() ? 1 : 0) != 0);
        Matcher matcher = MAJOR_MINOR_MICRO_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return Version.parseVersion((String)version);
        }
        matcher = MAJOR_MINOR_QUALIFIER_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), 0, matcher.group(3));
        }
        matcher = MAJOR_MINOR_MICRO_QUALIFIER_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4));
        }
        throw new IllegalArgumentException("Unrecognized version pattern : " + version);
    }

    public static boolean isVersion26OrLater(Version version) {
        return version.compareTo((Object)VERSION_2_6_0) >= 0;
    }

    public static boolean isVersion27OrLater(Version version) {
        return version.compareTo((Object)VERSION_2_7_0) >= 0;
    }

    public static boolean isVersion28OrLater(Version version) {
        return version.compareTo((Object)VERSION_2_8_0) >= 0;
    }

    public static boolean isVersion29OrLater(Version version) {
        return version.compareTo((Object)VERSION_2_9_0) >= 0;
    }

    public static boolean isVersion24x(Version version) {
        return version.compareTo((Object)VERSION_2_4_0) >= 0 && version.compareTo((Object)VERSION_2_5_0) < 0;
    }
}

