/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ToggleStarRequest;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethodBase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient27;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo28;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CherryPickInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RevisionInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class GerritClient28
extends GerritClient27 {
    private final Cache<Project.NameKey, Set<String>> projectBranchMap = CacheBuilder.newBuilder().build();

    protected GerritClient28(TaskRepository repository, Version version) {
        super(repository, version);
    }

    @Override
    public VoidResult setStarred(String reviewId, final boolean starred, IProgressMonitor monitor) throws GerritException {
        Change.Id id = new Change.Id(this.id(reviewId));
        final ToggleStarRequest req = new ToggleStarRequest();
        req.toggle(id, starred);
        final String uri = "/a/accounts/self/starred.changes/" + id.get();
        return this.execute(monitor, new GerritClient.Operation<VoidResult>((GerritClient)this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                if (starred) {
                    GerritClient28.this.executePutRestRequest(uri, req, (Type)((Object)ToggleStarRequest.class), GerritClient28.this.createErrorHandler(), monitor);
                } else {
                    GerritClient28.this.executeDeleteRestRequest(uri, req, (Type)((Object)ToggleStarRequest.class), GerritClient28.this.createErrorHandler(), monitor);
                }
            }
        });
    }

    @Override
    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        ChangeDetailX changeDetail = super.getChangeDetail(reviewId, monitor);
        ChangeInfo28 changeInfo = this.getAdditionalChangeInfo(reviewId, monitor);
        if (changeInfo != null) {
            this.setRevisionParentCommit(changeInfo, changeDetail);
        }
        return changeDetail;
    }

    protected void setRevisionParentCommit(ChangeInfo changeInfo, ChangeDetailX changeDetail) {
        if (changeInfo.getRevisions() != null) {
            for (Map.Entry<String, RevisionInfo> revisions : changeInfo.getRevisions().entrySet()) {
                CommitInfo commit;
                RevisionInfo revision = revisions.getValue();
                if (revision.getCommit() == null || (commit = revision.getCommit()).getParents().length < 1) continue;
                if (changeDetail.getParents() == null) {
                    changeDetail.setParents(new HashMap<Integer, CommitInfo[]>());
                }
                changeDetail.getParents().put(revision.getNumber(), commit.getParents());
            }
        }
    }

    protected ChangeInfo28 getAdditionalChangeInfo(int reviewId, IProgressMonitor monitor) {
        ChangeInfo28 changeInfo28 = null;
        try {
            changeInfo28 = (ChangeInfo28)this.executeGetRestRequest("/changes/" + Integer.toString(reviewId) + "/?o=ALL_REVISIONS&o=CURRENT_ACTIONS&o=ALL_COMMITS", (Type)((Object)ChangeInfo28.class), monitor);
        }
        catch (GerritException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
        }
        return changeInfo28;
    }

    @Override
    public ChangeDetail cherryPick(String reviewId, int patchSetId, String message, String destBranch, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        String url = "/changes/" + id.getParentKey() + "/revisions/" + id.get() + "/cherrypick";
        CherryPickInput input = new CherryPickInput(message, destBranch);
        ChangeInfo result = (ChangeInfo)this.executePostRestRequest(url, input, (Type)((Object)ChangeInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg)) {
                    errorMsg = NLS.bind((String)"Cannot cherry pick: {0}", (Object)errorMsg);
                } else if (this.isConflict(method)) {
                    errorMsg = NLS.bind((String)"Request Conflict: {0}", (Object)errorMsg);
                } else if (this.isBadRequest(method)) {
                    errorMsg = NLS.bind((String)"Bad Request: {0}", (Object)errorMsg);
                }
                throw new GerritException(errorMsg);
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && msg.toLowerCase().startsWith("cherry pick not permitted");
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }

            private boolean isBadRequest(HttpMethodBase method) {
                return method.getStatusCode() == 400;
            }
        }, monitor);
        return this.getChangeDetail(result.getNumber(), monitor);
    }

    @Override
    public GerritConfiguration refreshConfigOnce(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        GerritConfiguration config = super.refreshConfigOnce(project, monitor);
        if (project != null && this.getCachedBranches(project) == null) {
            this.cacheBranches(project, monitor);
        }
        return config;
    }

    @Override
    public GerritConfiguration refreshConfig(IProgressMonitor monitor) throws GerritException {
        this.refreshAllCachedProjectBranches(monitor);
        return super.refreshConfig(monitor);
    }

    private void refreshAllCachedProjectBranches(IProgressMonitor monitor) throws GerritException {
        Set projects = this.projectBranchMap.asMap().keySet();
        for (Project.NameKey project : projects) {
            this.cacheBranches(project, monitor);
        }
    }

    private void cacheBranches(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        ImmutableSet<String> branchNames = this.getBranchNames(project, monitor);
        this.projectBranchMap.put((Object)project, branchNames);
    }

    private ImmutableSet<String> getBranchNames(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        return FluentIterable.from(Arrays.asList(this.getRemoteProjectBranches(project.get(), monitor))).transform((Function)new Function<BranchInfo, String>(){

            public String apply(BranchInfo input) {
                return input.getRef();
            }
        }).toSet();
    }

    @Override
    public boolean supportsBranchCreation() throws GerritException {
        return true;
    }

    @Override
    public BranchInfo[] getRemoteProjectBranches(String projectName, IProgressMonitor monitor) throws GerritException {
        String url = this.getProjectBranchesUrl(projectName);
        return (BranchInfo[])this.executeGetRestRequest(url, (Type)((Object)BranchInfo[].class), monitor);
    }

    @Override
    public void createRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        String url = String.valueOf(this.getProjectBranchesUrl(projectName)) + branchName;
        BranchInput input = new BranchInput(branchName, revision);
        this.executePutRestRequest(url, input, (Type)((Object)BranchInput.class), this.createErrorHandler(), monitor);
    }

    @Override
    public void deleteRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        String url = String.valueOf(this.getProjectBranchesUrl(projectName)) + branchName;
        BranchInput input = new BranchInput(branchName, revision);
        this.executeDeleteRestRequest(url, input, (Type)((Object)BranchInput.class), this.createErrorHandler(), monitor);
    }

    @Override
    public Set<String> getCachedBranches(Project.NameKey project) {
        return (Set)this.projectBranchMap.getIfPresent((Object)project);
    }

    private String getProjectBranchesUrl(String projectName) throws GerritException {
        try {
            String encodedProjectName = URLEncoder.encode(projectName, "UTF-8");
            return "/projects/" + encodedProjectName + "/branches/";
        }
        catch (UnsupportedEncodingException e) {
            throw new GerritException(e);
        }
    }

    public void clearCachedBranches(Project.NameKey project) {
        this.projectBranchMap.invalidate((Object)project);
    }
}

