/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.AccountService;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeListService;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.ToggleStarRequest;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gson.reflect.TypeToken;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritAuthenticationState;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient24;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient26;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient27;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient28;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient29;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClientStateListener;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHtmlProcessor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.ProjectByNameComparator;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeManageService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchDetailService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectAdminService;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritQueryResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AbandonInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AddReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.BranchInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.RestoreInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ReviewerInput;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.SubmitInput;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.spi.ReviewsClient;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class GerritClient
extends ReviewsClient {
    final String NOT_SIGNED_IN = "Not Signed In";
    private static final Pattern GERRIT_VERSION_PATTERN = Pattern.compile("Powered by Gerrit Code Review (.+)</p>");
    private static final String GET_LABELS_OPTION = "LABELS";
    private GerritHttpClient client;
    private volatile GerritConfiguration config;
    private Account myAcount;
    private final Version version;
    private Map<Class<? extends RemoteJsonService>, RemoteJsonService> serviceByClass;
    private GerritClientStateListener stateListener;
    private volatile boolean configRefreshed;

    private boolean isAuthenticationException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Invalid xsrfKey in request".equals(((GerritException)exception).getMessage());
        }
        return false;
    }

    public boolean isNotSignedInException(Throwable exception) {
        if (exception instanceof GerritException) {
            return ((GerritException)exception).getCode() == -32603 && "Not Signed In".equalsIgnoreCase(((GerritException)exception).getMessage());
        }
        return false;
    }

    public static GerritAuthenticationState authStateFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritAuthenticationState)support.parseResponse(token, (Type)((Object)GerritAuthenticationState.class));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String authStateToString(GerritAuthenticationState authState) {
        if (authState == null) {
            return null;
        }
        try {
            JSonSupport support = new JSonSupport();
            return support.toJson(authState);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static GerritClient create(TaskRepository repository, AbstractWebLocation location) {
        return GerritClient.create(repository, location, null, null, null, null);
    }

    public static GerritClient create(TaskRepository repository, AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey, GerritClientStateListener stateListener) {
        Version version = Version.emptyVersion;
        GerritClient versionDiscoveryClient = new GerritClient(repository, version);
        versionDiscoveryClient.initialize(location, config, authState, xsrfKey, stateListener);
        try {
            version = versionDiscoveryClient.getVersion((IProgressMonitor)new NullProgressMonitor());
        }
        catch (GerritException gerritException) {}
        GerritClient client = null;
        client = GerritVersion.isVersion29OrLater(version) ? new GerritClient29(repository, version) : (GerritVersion.isVersion28OrLater(version) ? new GerritClient28(repository, version) : (GerritVersion.isVersion27OrLater(version) ? new GerritClient27(repository, version) : (GerritVersion.isVersion26OrLater(version) ? new GerritClient26(repository, version) : (GerritVersion.isVersion24x(version) ? new GerritClient24(repository, version) : new GerritClient(repository, version)))));
        client.initialize(location, config, authState, xsrfKey, stateListener);
        return client;
    }

    protected GerritClient(TaskRepository repository, Version version) {
        super(repository);
        Assert.isNotNull((Object)version);
        this.version = version;
    }

    protected void initialize(AbstractWebLocation location, GerritConfiguration config, GerritAuthenticationState authState, String xsrfKey, final GerritClientStateListener stateListener) {
        this.stateListener = stateListener;
        this.client = new GerritHttpClient(location){

            @Override
            protected void sessionChanged(Cookie cookie) {
                GerritAuthenticationState authState = new GerritAuthenticationState();
                authState.setCookie(cookie);
                if (stateListener != null) {
                    stateListener.authStateChanged(authState);
                }
            }
        };
        if (authState != null) {
            this.client.setXsrfCookie(authState.getCookie());
        }
        if (xsrfKey != null) {
            this.client.setXsrfKey(xsrfKey);
        }
        this.serviceByClass = new HashMap<Class<? extends RemoteJsonService>, RemoteJsonService>();
        this.config = config;
    }

    protected PatchLineComment createDraftComment(Patch.Key patchKey, String message, int line, short side, String parentUuid, String uuid, IProgressMonitor monitor) throws GerritException {
        PatchLineComment.Key id = new PatchLineComment.Key(patchKey, uuid);
        PatchLineComment comment = new PatchLineComment(id, line, this.getAccount(monitor).getId(), parentUuid);
        comment.setMessage(message);
        comment.setSide(side);
        return comment;
    }

    public PatchLineComment saveDraft(Patch.Key patchKey, String message, int line, short side, String parentUuid, String uuid, IProgressMonitor monitor) throws GerritException {
        final PatchLineComment comment = this.createDraftComment(patchKey, message, line, side, parentUuid, uuid, monitor);
        return this.execute(monitor, new Operation<PatchLineComment>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).saveDraft(comment, this);
            }
        });
    }

    public VoidResult deleteDraft(Patch.Key patchkey, String uuid, IProgressMonitor monitor) throws GerritException {
        final PatchLineComment.Key id = new PatchLineComment.Key(patchkey, uuid);
        return this.execute(monitor, new Operation<VoidResult>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).deleteDraft(id, this);
            }
        });
    }

    public ChangeDetail abandon(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        String uri = "/a/changes/" + id.getParentKey().get() + "/abandon";
        this.executePostRestRequest(uri, new AbandonInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public ChangeDetailX getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        final Change.Id changeId = new Change.Id(reviewId);
        ChangeDetailX changeDetail = null;
        changeDetail = this.execute(monitor, new Operation<ChangeDetailX>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeDetailService(monitor).changeDetailX(changeId, this);
            }
        });
        changeDetail.setDateCreated(changeDetail.getChange().getCreatedOn());
        changeDetail.setLastModified(changeDetail.getChange().getLastUpdatedOn());
        return changeDetail;
    }

    protected List<ReviewerInfo> listReviewers(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/reviewers/";
        TypeToken<List<ReviewerInfo>> reviewersListType = new TypeToken<List<ReviewerInfo>>(){};
        return (List)this.executeGetRestRequest(uri, reviewersListType.getType(), monitor);
    }

    protected boolean hasAllReviewers(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        for (ReviewerInfo reviewer : reviewers) {
            AccountInfo cachedAccount = accounts.get(new Account.Id(reviewer.getId()));
            if (cachedAccount != null && !this.isAnonymous(cachedAccount)) continue;
            return false;
        }
        return true;
    }

    private boolean isAnonymous(AccountInfo accountInfo) {
        return accountInfo.getFullName() == null && accountInfo.getPreferredEmail() == null;
    }

    protected void merge(AccountInfoCache accounts, List<ReviewerInfo> reviewers) {
        HashSet<AccountInfo> accountInfos = new HashSet<AccountInfo>(reviewers.size());
        for (ReviewerInfo reviewer : reviewers) {
            accountInfos.add(reviewer.toAccountInfo());
        }
        AccountInfoCache accountInfoCache = new AccountInfoCache(accountInfos);
        accounts.merge(accountInfoCache);
    }

    public ChangeInfo getChangeInfo(int reviewId, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + reviewId + "/revisions/current/review";
        return (ChangeInfo)this.executeGetRestRequest(uri, (Type)((Object)ChangeInfo.class), monitor);
    }

    public void loadPatchSetContent(PatchSetContent patchSetContent, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id baseId = patchSetContent.getBase() != null ? patchSetContent.getBase().getId() : null;
        PatchSet.Id targetId = patchSetContent.getTarget().getId();
        if (patchSetContent.getTargetDetail() == null) {
            PatchSetDetail targetDetail = this.getPatchSetDetail(baseId, targetId, monitor);
            patchSetContent.setTargetDetail(targetDetail);
        }
        for (Patch patch : patchSetContent.getTargetDetail().getPatches()) {
            PatchScriptX patchScript = this.getPatchScript(patch.getKey(), baseId, targetId, monitor);
            if (patchScript == null) continue;
            patchSetContent.putPatchScriptByPatchKey(patch.getKey(), patchScript);
        }
    }

    public GerritConfigX getGerritConfig() {
        return this.config == null ? null : this.config.getGerritConfig();
    }

    public GerritConfiguration getConfiguration() {
        return this.config;
    }

    public GerritSystemInfo getInfo(IProgressMonitor monitor) throws GerritException {
        List<ContributorAgreement> contributorAgreements = null;
        Account account = null;
        if (!this.isAnonymous()) {
            account = this.getAccount(monitor);
        } else {
            this.executeQuery(monitor, "status:open");
        }
        this.refreshConfigOnce(monitor);
        return new GerritSystemInfo(this.getVersion(), contributorAgreements, account);
    }

    PatchScriptX getPatchScript(final Patch.Key key, final PatchSet.Id leftId, final PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        final AccountDiffPreference diffPrefs = this.createAccountDiffPreference();
        PatchScriptX patchScript = this.execute(monitor, new Operation<PatchScriptX>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getPatchDetailService(monitor).patchScriptX(key, leftId, rightId, diffPrefs, this);
            }
        });
        if (patchScript.isBinary()) {
            this.fetchLeftBinaryContent(patchScript, key, leftId, monitor);
            this.fetchRightBinaryContent(patchScript, key, rightId, monitor);
        }
        return patchScript;
    }

    protected void fetchLeftBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id leftId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.ADDED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSetOrBase(key, leftId), monitor);
            patchScript.setBinaryA(binaryContent);
        }
    }

    protected void fetchRightBinaryContent(PatchScriptX patchScript, Patch.Key key, PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        if (patchScript.getChangeType() != Patch.ChangeType.DELETED) {
            byte[] binaryContent = this.fetchBinaryContent(this.getUrlForPatchSet(key, rightId), monitor);
            patchScript.setBinaryB(binaryContent);
        }
    }

    protected String getUrlForPatchSetOrBase(Patch.Key key, PatchSet.Id id) throws GerritException {
        if (id == null) {
            return this.getUrlForBase(key);
        }
        return this.getUrlForPatchSet(key, id);
    }

    private String getUrlForBase(Patch.Key key) throws GerritException {
        return GerritClient.encode(String.valueOf(key.toString()) + "^1");
    }

    protected String getUrlForPatchSet(Patch.Key key, PatchSet.Id id) throws GerritException {
        return GerritClient.encode(id + "," + key.getFileName() + "^0");
    }

    protected byte[] fetchBinaryContent(String url, IProgressMonitor monitor) throws GerritException {
        TypeToken<Byte[]> byteArrayType = new TypeToken<Byte[]>(){};
        byte[] bin = (byte[])this.executeGetRestRequest("/cat/" + url, byteArrayType.getType(), monitor);
        if (GerritClient.isZippedContent(bin)) {
            return GerritClient.unzip(bin);
        }
        return bin;
    }

    public static boolean isZippedContent(byte[] bin) {
        return bin != null && bin.length > 4 && bin[0] == 80 && bin[1] == 75 && bin[2] == 3 && bin[3] == 4;
    }

    public static byte[] unzip(byte[] zip) throws GerritException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        try {
            zis.getNextEntry();
            byte[] byArray = IOUtils.toByteArray((InputStream)zis);
            return byArray;
        }
        catch (IOException e) {
            throw new GerritException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private AccountDiffPreference createAccountDiffPreference() {
        AccountDiffPreference diffPrefs = new AccountDiffPreference(null);
        diffPrefs.setLineLength(Integer.MAX_VALUE);
        diffPrefs.setTabSize(4);
        diffPrefs.setContext((short)-1);
        diffPrefs.setIgnoreWhitespace(AccountDiffPreference.Whitespace.IGNORE_NONE);
        diffPrefs.setIntralineDifference(false);
        return diffPrefs;
    }

    private PatchSetDetail getPatchSetDetail(final PatchSet.Id idBase, final PatchSet.Id idTarget, IProgressMonitor monitor) throws GerritException {
        PatchSetDetail patchSetDetail;
        block6: {
            patchSetDetail = null;
            try {
                patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        this.getChangeDetailService(monitor).patchSetDetail2(idBase, idTarget, this.createAccountDiffPreference(), this);
                    }
                });
            }
            catch (GerritException e) {
                try {
                    if (!this.isNoSuchServiceError(e)) {
                        throw e;
                    }
                    patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                        @Override
                        public void execute(IProgressMonitor monitor) throws GerritException {
                            this.getChangeDetailService(monitor).patchSetDetail(idTarget, this);
                        }
                    });
                }
                catch (GerritException e2) {
                    String message = e2.getMessage();
                    if (message != null && message.contains("Error parsing request")) {
                        patchSetDetail = this.execute(monitor, new Operation<PatchSetDetail>(this){

                            @Override
                            public void execute(IProgressMonitor monitor) throws GerritException {
                                this.getChangeDetailService(monitor).patchSetDetail(idBase, idTarget, this.createAccountDiffPreference(), this);
                            }
                        });
                        break block6;
                    }
                    throw e2;
                }
            }
        }
        return patchSetDetail;
    }

    boolean isNoSuchServiceError(GerritException e) {
        String message = e.getMessage();
        return message != null && message.contains("No such service method");
    }

    public PatchSetPublishDetailX getPatchSetPublishDetail(final PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetPublishDetailX publishDetail = this.execute(monitor, new Operation<PatchSetPublishDetailX>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeDetailService(monitor).patchSetPublishDetailX(id, this);
            }
        });
        return publishDetail;
    }

    public GerritChange getChange(String reviewId, IProgressMonitor monitor) throws GerritException {
        int id;
        GerritChange gerritChange = new GerritChange();
        try {
            id = this.id(reviewId);
        }
        catch (GerritException e) {
            List<GerritQueryResult> result = this.executeQuery(monitor, reviewId);
            if (result.size() == 1) {
                id = result.get(0).getNumber();
            }
            throw e;
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id, monitor);
        ArrayList<PatchSetDetail> patchSets = new ArrayList<PatchSetDetail>(changeDetail.getPatchSets().size());
        HashMap<PatchSet.Id, PatchSetPublishDetailX> patchSetPublishDetailByPatchSetId = new HashMap<PatchSet.Id, PatchSetPublishDetailX>();
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            try {
                PatchSetDetail patchSetDetail = this.getPatchSetDetail(null, patchSet.getId(), monitor);
                patchSets.add(patchSetDetail);
                if (this.isAnonymous()) continue;
                PatchSetPublishDetailX patchSetPublishDetail = this.getPatchSetPublishDetail(patchSet.getId(), monitor);
                this.applyPatchSetInfo(patchSetDetail, patchSetPublishDetail, monitor);
                patchSetPublishDetailByPatchSetId.put(patchSet.getId(), patchSetPublishDetail);
                changeDetail.setCurrentPatchSetDetail(patchSetDetail);
            }
            catch (GerritException e) {
                this.handleMissingPatchSet(NLS.bind((String)"Patch Set {0} items for Review {1}", (Object)patchSet.getPatchSetId(), (Object)reviewId), e);
            }
        }
        gerritChange.setChangeDetail(changeDetail);
        gerritChange.setPatchSets(patchSets);
        gerritChange.setPatchSetPublishDetailByPatchSetId(patchSetPublishDetailByPatchSetId);
        return gerritChange;
    }

    protected void applyPatchSetInfo(PatchSetDetail patchSetDetail, PatchSetPublishDetailX patchSetPublishDetail, IProgressMonitor monitor) throws GerritException {
    }

    private void handleMissingPatchSet(String desc, GerritException e) {
        GerritCorePlugin.logWarning(NLS.bind((String)"Couldn't load {0}. (Perhaps the Patch Set has been removed from repository?)", (Object)desc), e);
    }

    public int id(String id) throws GerritException {
        if (id == null) {
            throw new GerritException("Invalid ID (null)");
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GerritException(NLS.bind((String)"Invalid ID (''{0}'')", (Object)id));
        }
    }

    public void publishComments(String reviewId, int patchSetId, String message, Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        ReviewInput reviewInput = new ReviewInput(message);
        Map<String, CommentInfo[]> drafts = this.listDrafts(id, monitor);
        Map<String, CommentInput[]> comments = this.convert(drafts);
        if (!comments.isEmpty()) {
            reviewInput.setComments(comments);
        }
        reviewInput.setApprovals(approvals);
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/review";
        this.executePostRestRequest(uri, reviewInput, (Type)((Object)ReviewInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String msg;
                if (method.getStatusCode() == 403 && (msg = this.getResponseBodyAsString(method)).startsWith("Applying label") && msg.endsWith("is restricted")) {
                    throw new GerritException(msg);
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    String msg = method.getResponseBodyAsString();
                    return msg.trim();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }, monitor);
    }

    private Map<String, CommentInfo[]> listDrafts(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/drafts/";
        TypeToken<Map<String, CommentInfo[]>> resultType = new TypeToken<Map<String, CommentInfo[]>>(){};
        return (Map)this.executeGetRestRequest(uri, resultType.getType(), monitor);
    }

    private Map<String, CommentInput[]> convert(Map<String, CommentInfo[]> commentInfos) {
        if (commentInfos == null || commentInfos.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, CommentInput[]> commentInputs = new HashMap<String, CommentInput[]>(commentInfos.size());
        Set<Map.Entry<String, CommentInfo[]>> entrySet = commentInfos.entrySet();
        for (Map.Entry<String, CommentInfo[]> entry : entrySet) {
            CommentInfo[] infos = entry.getValue();
            ArrayList<CommentInput> inputs = new ArrayList<CommentInput>(infos.length);
            CommentInfo[] commentInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                CommentInfo info = commentInfoArray[n2];
                inputs.add(new CommentInput(info));
                ++n2;
            }
            commentInputs.put(entry.getKey(), inputs.toArray(new CommentInput[inputs.size()]));
        }
        return commentInputs;
    }

    public ReviewerResult addReviewers(String reviewId, List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        Assert.isLegal((reviewers != null ? 1 : 0) != 0, (String)"reviewers cannot be null");
        Change.Id id = new Change.Id(this.id(reviewId));
        String uri = "/a/changes/" + id.get() + "/reviewers";
        HashSet<ReviewerInfo> reviewerInfos = new HashSet<ReviewerInfo>(reviewers.size());
        ReviewerResult reviewerResult = new ReviewerResult();
        for (String reviewerId : reviewers) {
            try {
                AddReviewerResult addReviewerResult = (AddReviewerResult)this.executePostRestRequest(uri, new ReviewerInput(reviewerId), (Type)((Object)AddReviewerResult.class), null, monitor);
                reviewerInfos.addAll(addReviewerResult.getReviewers());
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 422) continue;
                reviewerResult.addError(new ReviewerResult.Error(null, reviewerId));
            }
        }
        ChangeDetailX changeDetail = this.getChangeDetail(id.get(), monitor);
        ArrayList<ApprovalDetail> approvalDetails = new ArrayList<ApprovalDetail>(reviewerInfos.size());
        for (ReviewerInfo reviewerInfo : reviewerInfos) {
            approvalDetails.add(reviewerInfo.toApprovalDetail(changeDetail.getCurrentPatchSet()));
        }
        changeDetail.setApprovals(approvalDetails);
        reviewerResult.setChange((ChangeDetail)changeDetail);
        return reviewerResult;
    }

    public List<GerritQueryResult> queryAllReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "status:open");
    }

    public List<GerritQueryResult> queryByProject(IProgressMonitor monitor, String project) throws GerritException {
        return this.executeQuery(monitor, "status:open project:" + project);
    }

    public List<GerritQueryResult> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQueryRest(monitor, "owner:self OR reviewer:self", GET_LABELS_OPTION);
    }

    public List<GerritQueryResult> queryWatchedReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "is:watched status:open");
    }

    private GerritConfigX refreshGerritConfig(final IProgressMonitor monitor) throws GerritException {
        try {
            GerritConfigX gerritConfig = this.client.execute(new GerritHttpClient.Request<GerritConfigX>(){

                @Override
                public HttpMethodBase createMethod() throws IOException {
                    return new GetMethod(String.valueOf(GerritClient.this.client.getUrl()) + "/");
                }

                @Override
                public GerritConfigX process(HttpMethodBase method) throws IOException {
                    InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                    try {
                        GerritHtmlProcessor processor = new GerritHtmlProcessor();
                        processor.parse(in, method.getResponseCharSet());
                        GerritConfigX gerritConfigX = processor.getConfig();
                        return gerritConfigX;
                    }
                    finally {
                        in.close();
                    }
                }
            }, monitor);
            if (gerritConfig == null) {
                throw new GerritException("Failed to obtain Gerrit configuration");
            }
            return gerritConfig;
        }
        catch (UnknownHostException cause) {
            GerritException e = new GerritException("Unknown host: " + cause.getMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IOException cause) {
            GerritException e = new GerritException(cause.getMessage());
            e.initCause(cause);
            throw e;
        }
    }

    public GerritConfiguration refreshConfig(IProgressMonitor monitor) throws GerritException {
        Account account;
        List<Project> projects;
        GerritConfigX gerritConfig;
        block3: {
            this.configRefreshed = true;
            gerritConfig = this.refreshGerritConfig(monitor);
            projects = this.getVisibleProjects(monitor, gerritConfig);
            account = null;
            try {
                account = this.getAccount(monitor);
            }
            catch (GerritException e) {
                if (this.isNotSignedInException(e)) break block3;
                throw e;
            }
        }
        this.config = new GerritConfiguration(gerritConfig, projects, account);
        if (this.stateListener != null) {
            this.stateListener.configurationChanged(this.config);
        }
        return this.config;
    }

    public GerritConfiguration refreshConfigOnce(IProgressMonitor monitor) throws GerritException {
        return this.refreshConfigOnce(null, monitor);
    }

    public GerritConfiguration refreshConfigOnce(Project.NameKey project, IProgressMonitor monitor) throws GerritException {
        if (!this.configRefreshed && this.config == null) {
            try {
                this.refreshConfig(monitor);
            }
            catch (GerritException gerritException) {}
        }
        return this.getConfiguration();
    }

    public Set<String> getCachedBranches(Project.NameKey project) {
        return Collections.emptySet();
    }

    public void createRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        throw new GerritException("Branch creation requests can only be done in Gerrit versions 2.8 or later");
    }

    public void deleteRemoteBranch(String projectName, String branchName, String revision, IProgressMonitor monitor) throws GerritException {
        throw new GerritException("Branch deletion requests can only be done in Gerrit versions 2.8 or later");
    }

    public BranchInfo[] getRemoteProjectBranches(String projectName, IProgressMonitor monitor) throws GerritException {
        throw new GerritException("Executing Branch Info requests can only be done in Gerrit versions 2.8 or later");
    }

    public ChangeDetail rebase(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeManageService(monitor).rebaseChange(id, this);
            }
        });
    }

    public ChangeDetail restore(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id;
        block2: {
            id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
            String uri = "/a/changes/" + id.getParentKey().get() + "/restore";
            try {
                this.executePostRestRequest(uri, new RestoreInput(message), (Type)((Object)ChangeInfo.class), null, monitor);
            }
            catch (GerritHttpException e) {
                if (e.getResponseCode() != 409) break block2;
                throw new GerritException("Not Found", e);
            }
        }
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public ChangeDetail submit(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.submitRest(id, monitor);
    }

    private ChangeDetail submitRest(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String uri = "/a/changes/" + id.getParentKey().get() + "/revisions/" + id.get() + "/submit";
        this.executePostRestRequest(uri, new SubmitInput(true), (Type)((Object)SubmitInfo.class), new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                String errorMsg = this.getResponseBodyAsString(method);
                if (this.isNotPermitted(method, errorMsg) || this.isConflict(method)) {
                    throw new GerritException(NLS.bind((String)"Cannot submit change: {0}", (Object)errorMsg));
                }
            }

            private String getResponseBodyAsString(HttpMethodBase method) {
                try {
                    return method.getResponseBodyAsString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private boolean isNotPermitted(HttpMethodBase method, String msg) {
                return method.getStatusCode() == 403 && "submit not permitted\n".equals(msg);
            }

            private boolean isConflict(HttpMethodBase method) {
                return method.getStatusCode() == 409;
            }
        }, monitor);
        return this.getChangeDetail(id.getParentKey().get(), monitor);
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, String queryString) throws GerritException {
        return this.executeQuery(monitor, queryString, GET_LABELS_OPTION);
    }

    public List<GerritQueryResult> executeQuery(IProgressMonitor monitor, String queryString, String optionString) throws GerritException {
        return this.executeQueryRest(monitor, queryString, optionString);
    }

    public List<GerritQueryResult> executeQueryRest(IProgressMonitor monitor, String queryString) throws GerritException {
        return this.executeQueryRest(monitor, queryString, null);
    }

    public List<GerritQueryResult> executeQueryRest(IProgressMonitor monitor, String queryString, String optionString) throws GerritException {
        String uri = "/changes/?q=" + GerritClient.encode(queryString);
        if (StringUtils.isNotBlank((String)optionString)) {
            uri = String.valueOf(uri) + "&o=" + GerritClient.encode(optionString);
        }
        TypeToken<List<GerritQueryResult>> queryResultListType = new TypeToken<List<GerritQueryResult>>(){};
        return (List)this.executeGetRestRequest(uri, queryResultListType.getType(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myAcount != null) {
                return this.myAcount;
            }
        }
        Account account = this.executeAccount(monitor);
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myAcount = account;
        }
        return this.myAcount;
    }

    protected Account executeAccount(IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<Account>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getAccountService(monitor).myAccount((AsyncCallback)this);
            }
        });
    }

    private AccountService getAccountService(IProgressMonitor monitor) {
        return this.getService(AccountService.class, monitor);
    }

    private ChangeDetailService getChangeDetailService(IProgressMonitor monitor) {
        return this.getService(ChangeDetailService.class, monitor);
    }

    ChangeListService getChangeListService(IProgressMonitor monitor) {
        return this.getService(ChangeListService.class, monitor);
    }

    ChangeManageService getChangeManageService(IProgressMonitor monitor) {
        return this.getService(ChangeManageService.class, monitor);
    }

    PatchDetailService getPatchDetailService(IProgressMonitor monitor) {
        return this.getService(PatchDetailService.class, monitor);
    }

    private List<Project> getVisibleProjects(IProgressMonitor monitor, GerritConfig gerritConfig) throws GerritException {
        ArrayList<Project> result = new ArrayList<Project>();
        try {
            List<ProjectDetailX> projectDetails = this.execute(monitor, new Operation<List<ProjectDetailX>>(this){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    this.getProjectAdminService(monitor).visibleProjectDetails(this);
                }
            });
            for (ProjectDetailX projectDetail : projectDetails) {
                if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
                result.add(projectDetail.project);
            }
        }
        catch (GerritException e) {
            if (this.isNoSuchServiceError(e)) {
                this.addProjectsWhenNoSuchService(monitor, gerritConfig, result);
            }
            throw e;
        }
        Collections.sort(result, new ProjectByNameComparator());
        return result;
    }

    protected void addProjectsWhenNoSuchService(IProgressMonitor monitor, GerritConfig gerritConfig, List<Project> result) throws GerritException {
        List<Project> projects = this.execute(monitor, new Operation<List<Project>>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getProjectAdminService(monitor).visibleProjects(this);
            }
        });
        for (Project project : projects) {
            ProjectDetailX projectDetail = new ProjectDetailX();
            projectDetail.setProject(project);
            if (GerritUtil.isPermissionOnlyProject(projectDetail, gerritConfig)) continue;
            result.add(project);
        }
    }

    private ProjectAdminService getProjectAdminService(IProgressMonitor monitor) {
        return this.getService(ProjectAdminService.class, monitor);
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    protected <T> T execute(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        try {
            T t;
            GerritService.GerritRequest.setCurrentRequest(new GerritService.GerritRequest(monitor));
            try {
                t = this.executeOnce(monitor, operation);
            }
            catch (GerritException e) {
                block7: {
                    if (!this.isAuthenticationException(e)) break block7;
                    operation.reset();
                    T t2 = this.executeOnce(monitor, operation);
                    GerritService.GerritRequest.setCurrentRequest(null);
                    return t2;
                }
                throw e;
            }
            return t;
        }
        finally {
            GerritService.GerritRequest.setCurrentRequest(null);
        }
    }

    protected <T> T executePostRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.postRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executeGetRestRequest(final String url, final Type resultType, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.getRestRequest(url, resultType, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executePutRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.putRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executeDeleteRestRequest(final String url, final Object input, final Type resultType, final GerritHttpClient.ErrorHandler handler, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<T>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    this.setResult(client.deleteRestRequest(url, input, resultType, handler, monitor));
                }
                catch (IOException e) {
                    throw new GerritException(e);
                }
            }
        });
    }

    protected <T> T executeOnce(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        operation.execute(monitor);
        if (operation.getException() instanceof GerritException) {
            throw (GerritException)operation.getException();
        }
        if (operation.getException() instanceof OperationCanceledException) {
            throw (OperationCanceledException)operation.getException();
        }
        if (operation.getException() instanceof RuntimeException) {
            throw (RuntimeException)operation.getException();
        }
        if (operation.getException() != null) {
            GerritException e = new GerritException();
            e.initCause(operation.getException());
            throw e;
        }
        return operation.getResult();
    }

    private synchronized <T extends RemoteJsonService> T getService(Class<T> clazz, IProgressMonitor monitor) {
        Object service = this.serviceByClass.get(clazz);
        if (service == null) {
            service = GerritService.create(clazz, this.client, this.getVersion());
            this.serviceByClass.put((Class<? extends RemoteJsonService>)clazz, (RemoteJsonService)service);
        }
        return (T)((RemoteJsonService)clazz.cast(service));
    }

    public AbstractRemoteEmfFactoryProvider<IRepository, IReview> createFactoryProvider() {
        return new GerritRemoteFactoryProvider(this);
    }

    public boolean supportsBranchCreation() throws GerritException {
        return false;
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getVersion(IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<Version>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                try {
                    GerritHttpClient.Request<String> request = new GerritHttpClient.Request<String>(){

                        @Override
                        public HttpMethodBase createMethod() throws IOException {
                            return new GetMethod(String.valueOf(client.getUrl()) + "/tools/hooks/");
                        }

                        @Override
                        public String process(HttpMethodBase method) throws IOException {
                            String content = method.getResponseBodyAsString();
                            Matcher matcher = GERRIT_VERSION_PATTERN.matcher(content);
                            if (matcher.find()) {
                                return matcher.group(1);
                            }
                            return null;
                        }
                    };
                    String result = client.execute(request, false, monitor);
                    Version version = GerritVersion.parseGerritVersion(result);
                    this.onSuccess(version);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }
        });
    }

    public String toReviewId(String id, IProgressMonitor monitor) throws GerritException {
        try {
            Integer.parseInt(id);
            return id;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                List<GerritQueryResult> results = this.executeQuery(monitor, id);
                if (results.size() != 1) {
                    throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id));
                }
                return Integer.toString(results.get(0).getNumber());
            }
            catch (GerritException e2) {
                throw new GerritException(NLS.bind((String)"{0} is not a valid review ID", (Object)id), e2);
            }
        }
    }

    private static String encode(String string) throws GerritException {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new GerritException(e);
        }
    }

    public VoidResult setStarred(String reviewId, boolean starred, IProgressMonitor monitor) throws GerritException {
        Change.Id id = new Change.Id(this.id(reviewId));
        final ToggleStarRequest req = new ToggleStarRequest();
        req.toggle(id, starred);
        return this.execute(monitor, new Operation<VoidResult>(this){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                this.getChangeListService(monitor).toggleStars(req, (AsyncCallback)this);
            }
        });
    }

    GerritHttpClient.ErrorHandler createErrorHandler() {
        return new GerritHttpClient.ErrorHandler(){

            @Override
            public void handleError(HttpMethodBase method) throws GerritException {
                throw new GerritException(method.getStatusLine().getReasonPhrase());
            }
        };
    }

    public ChangeDetail cherryPick(String reviewId, int patchSetId, String message, String destBranch, IProgressMonitor monitor) throws GerritException {
        throw new GerritException("Cherry Picking not supported before version 2.8");
    }

    abstract class Operation<T>
    implements AsyncCallback<T> {
        private Throwable exception;
        private T result;

        Operation() {
        }

        public abstract void execute(IProgressMonitor var1) throws GerritException;

        public Throwable getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }

        public void onFailure(Throwable exception) {
            if (GerritClient.this.isAuthenticationException(exception)) {
                GerritClient.this.client.setXsrfCookie(null);
            }
            this.exception = exception;
        }

        public void onSuccess(T result) {
            this.setResult(result);
        }

        protected void setResult(T result) {
            this.result = result;
        }

        public void reset() {
            this.result = null;
            this.exception = null;
        }
    }
}

