/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.io.InputStream;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class MarkupDocumentProvider
extends TextFileDocumentProvider {
    private MarkupLanguage markupLanguage;

    public MarkupDocumentProvider() {
        super((IDocumentProvider)new MarkupFileDocumentProvider());
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        IDocument document = super.getDocument(element);
        this.connectPartitioner(document);
    }

    private void connectPartitioner(IDocument document) {
        FastMarkupPartitioner partitioner = new FastMarkupPartitioner();
        partitioner.setMarkupLanguage(this.markupLanguage == null ? null : this.markupLanguage.clone());
        partitioner.connect(document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        if (this.dispatchToParent(element)) {
            return null;
        }
        return super.createFileInfo(element);
    }

    private boolean dispatchToParent(Object element) {
        return element instanceof IStorageEditorInput || element instanceof IFileEditorInput;
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, final IDocument document, final boolean overwrite) throws CoreException {
        if (this.dispatchToParent(element)) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    MarkupDocumentProvider.this.getParentProvider().saveDocument(monitor, element, document, overwrite);
                }
            };
        }
        return super.createSaveOperation(element, document, overwrite);
    }

    public static void cleanUpEolMarkers(IDocument document) {
        try {
            String documentLineDelimiter = document.getLineDelimiter(0);
            if (documentLineDelimiter != null) {
                MarkupDocumentProvider.replaceLineDelimiters(document, documentLineDelimiter);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static void replaceLineDelimiters(IDocument document, String newLineDelimiter) {
        document.set(Pattern.compile("(\r\n|\n|\r)").matcher(document.get()).replaceAll(newLineDelimiter));
    }

    private static class MarkupFileDocumentProvider
    extends FileDocumentProvider {
        private MarkupFileDocumentProvider() {
        }

        protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
            super.setDocumentContent(document, contentStream, encoding);
            MarkupDocumentProvider.cleanUpEolMarkers(document);
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            String platformEolMarker = Text.DELIMITER;
            if (platformEolMarker.equals("\r")) {
                Document newDocument = new Document(document.get());
                MarkupDocumentProvider.replaceLineDelimiters((IDocument)newDocument, "\n");
                document = newDocument;
            }
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }
}

