/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import java.util.Date;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.MoveToCategoryMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TaskPriorityFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewCategoryAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryQuery;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.TreeItem;

public class TaskListUiTest
extends TestCase {
    private TaskCategory cat1 = null;
    private AbstractTask cat1task1 = null;
    private AbstractTask cat1task2 = null;
    private AbstractTask cat1task3 = null;
    private AbstractTask cat1task4 = null;
    private AbstractTask cat1task5 = null;
    private AbstractTask cat1task1sub1 = null;
    private TaskCategory cat2 = null;
    private AbstractTask cat2task1 = null;
    private AbstractTask cat2task2 = null;
    private AbstractTask cat2task3 = null;
    private AbstractTask cat2task4 = null;
    private AbstractTask cat2task5 = null;
    private AbstractTask cat2task1sub1 = null;
    private TaskList taskList;
    private static final int CHECK_COMPLETE_FILTER = 1;
    private static final int CHECK_INCOMPLETE_FILTER = 2;
    private static final int CHECK_PRIORITY_FILTER = 3;

    public void setUp() throws Exception {
        this.taskList = TasksUiPlugin.getTaskList();
        TaskTestUtil.resetTaskListAndRepositories();
        TasksUiPlugin.getDefault().getLocalTaskRepository();
        TasksUiUtil.openTasksViewInActivePerspective();
        this.cat1 = new TaskCategory("First Category");
        this.taskList.addCategory(this.cat1);
        this.cat1task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.cat1task1.setPriority(ITask.PriorityLevel.P1.toString());
        this.cat1task1.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task1, (AbstractTaskContainer)this.cat1);
        this.cat1task1sub1 = TasksUiInternal.createNewLocalTask((String)"sub task 1");
        this.cat1task1sub1.setPriority(ITask.PriorityLevel.P1.toString());
        this.cat1task1sub1.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task1sub1, (AbstractTaskContainer)this.cat1task1);
        this.cat1task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        this.cat1task2.setPriority(ITask.PriorityLevel.P2.toString());
        this.taskList.addTask((ITask)this.cat1task2, (AbstractTaskContainer)this.cat1);
        this.cat1task3 = TasksUiInternal.createNewLocalTask((String)"task 3");
        this.cat1task3.setPriority(ITask.PriorityLevel.P3.toString());
        this.cat1task3.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task3, (AbstractTaskContainer)this.cat1);
        this.cat1task4 = TasksUiInternal.createNewLocalTask((String)"task 4");
        this.cat1task4.setPriority(ITask.PriorityLevel.P4.toString());
        this.taskList.addTask((ITask)this.cat1task4, (AbstractTaskContainer)this.cat1);
        this.cat1task5 = TasksUiInternal.createNewLocalTask((String)"task 5");
        this.cat1task5.setPriority(ITask.PriorityLevel.P5.toString());
        this.cat1task5.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat1task5, (AbstractTaskContainer)this.cat1);
        TaskListUiTest.assertEquals((int)this.cat1.getChildren().size(), (int)5);
        this.cat2 = new TaskCategory("Second Category");
        this.taskList.addCategory(this.cat2);
        this.cat2task1 = TasksUiInternal.createNewLocalTask((String)"task 1");
        this.cat2task1.setPriority(ITask.PriorityLevel.P1.toString());
        this.taskList.addTask((ITask)this.cat2task1, (AbstractTaskContainer)this.cat2);
        this.cat2task1sub1 = TasksUiInternal.createNewLocalTask((String)"sub task 1");
        this.cat2task1sub1.setPriority(ITask.PriorityLevel.P1.toString());
        this.taskList.addTask((ITask)this.cat2task1sub1, (AbstractTaskContainer)this.cat2task1);
        this.cat2task2 = TasksUiInternal.createNewLocalTask((String)"task 2");
        this.cat2task2.setPriority(ITask.PriorityLevel.P2.toString());
        this.cat2task2.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat2task2, (AbstractTaskContainer)this.cat2);
        this.cat2task3 = TasksUiInternal.createNewLocalTask((String)"task 3");
        this.cat2task3.setPriority(ITask.PriorityLevel.P3.toString());
        this.taskList.addTask((ITask)this.cat2task3, (AbstractTaskContainer)this.cat2);
        this.cat2task4 = TasksUiInternal.createNewLocalTask((String)"task 4");
        this.cat2task4.setPriority(ITask.PriorityLevel.P4.toString());
        this.cat2task4.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.cat2task4, (AbstractTaskContainer)this.cat2);
        this.cat2task5 = TasksUiInternal.createNewLocalTask((String)"task 5");
        this.cat2task5.setPriority(ITask.PriorityLevel.P5.toString());
        this.taskList.addTask((ITask)this.cat2task5, (AbstractTaskContainer)this.cat2);
    }

    public void tearDown() throws Exception {
    }

    public void testUiFilter() {
        TaskListUiTest.assertNotNull((Object)TaskListView.getFromActivePerspective());
        TreeViewer viewer = TaskListView.getFromActivePerspective().getViewer();
        TaskListView.getFromActivePerspective().addFilter((AbstractTaskListFilter)TaskListView.getFromActivePerspective().getCompleteFilter());
        viewer.refresh();
        viewer.expandAll();
        TreeItem[] items = viewer.getTree().getItems();
        TaskListUiTest.assertTrue((boolean)this.checkFilter(1, items));
        TaskListView.getFromActivePerspective().removeFilter((AbstractTaskListFilter)TaskListView.getFromActivePerspective().getCompleteFilter());
        TaskPriorityFilter filter = TaskListView.getFromActivePerspective().getPriorityFilter();
        filter.displayPrioritiesAbove("P2");
        TaskListView.getFromActivePerspective().addFilter((AbstractTaskListFilter)filter);
        viewer.refresh();
        viewer.expandAll();
        items = viewer.getTree().getItems();
        TaskListUiTest.assertTrue((boolean)this.checkFilter(3, items));
    }

    public void testGetSubMenuManagerContainsAllCategoriesPlusNewCategory() {
        MoveToCategoryMenuContributor moveToMenuContrib = new MoveToCategoryMenuContributor();
        Vector<AbstractTask> selectedElements = new Vector<AbstractTask>();
        selectedElements.add(this.cat1task1);
        int numCategories = this.taskList.getCategories().size();
        int numSeparators = 1;
        int expectedNrOfSubMenuEntries = numCategories + numSeparators + 1;
        NewCategoryAction newCatActon = new NewCategoryAction();
        MenuManager menuManager = moveToMenuContrib.getSubMenuManager(selectedElements);
        IContributionItem[] items = menuManager.getItems();
        IContributionItem item = items[menuManager.getItems().length - 1];
        TaskListUiTest.assertEquals((int)expectedNrOfSubMenuEntries, (int)menuManager.getItems().length);
        if (item instanceof NewCategoryAction) {
            NewCategoryAction action = (NewCategoryAction)item;
            TaskListUiTest.assertEquals((String)newCatActon.getText(), (String)action.getText());
        }
    }

    public void testVisibilityOfSubMenuManager() {
        MoveToCategoryMenuContributor moveToMenuContrib = new MoveToCategoryMenuContributor();
        MenuManager menuManager = null;
        Vector<AbstractTask> selectedElements = new Vector<AbstractTask>();
        selectedElements.add(this.cat1task1);
        Vector emptySelection = new Vector();
        Vector<TaskCategory> categorySelection = new Vector<TaskCategory>();
        categorySelection.add(this.cat1);
        Vector<MockRepositoryQuery> querySelection = new Vector<MockRepositoryQuery>();
        querySelection.add(new MockRepositoryQuery("query", null));
        menuManager = moveToMenuContrib.getSubMenuManager(selectedElements);
        TaskListUiTest.assertTrue((boolean)menuManager.isVisible());
        menuManager = null;
        menuManager = moveToMenuContrib.getSubMenuManager(emptySelection);
        TaskListUiTest.assertFalse((boolean)menuManager.isVisible());
        menuManager = null;
        menuManager = moveToMenuContrib.getSubMenuManager(categorySelection);
        TaskListUiTest.assertFalse((boolean)menuManager.isVisible());
        menuManager = null;
        menuManager = moveToMenuContrib.getSubMenuManager(querySelection);
        TaskListUiTest.assertFalse((boolean)menuManager.isVisible());
    }

    public void testCategoryNameIsShownInMoveToCategoryAction() {
        String catNameWithAtBefore = "@CatName";
        String catNameWithAtExpected = "@CatName@";
        String catNameWithAtActual = "";
        String catNameNoAtBefore = "CatName";
        String catNameNoAtExpected = "CatName";
        String catNameNoAtActual = "";
        MoveToCategoryMenuContributor menuContrib = new MoveToCategoryMenuContributor();
        catNameWithAtActual = menuContrib.handleAcceleratorKeys(catNameWithAtBefore);
        catNameNoAtActual = menuContrib.handleAcceleratorKeys(catNameNoAtBefore);
        TaskListUiTest.assertEquals((String)catNameWithAtExpected, (String)catNameWithAtActual);
        TaskListUiTest.assertEquals((String)catNameNoAtExpected, (String)catNameNoAtActual);
    }

    public boolean checkFilter(int type, TreeItem[] items) {
        switch (type) {
            case 1: {
                return this.checkCompleteIncompleteFilter(items, false);
            }
            case 2: {
                return this.checkCompleteIncompleteFilter(items, true);
            }
            case 3: {
                return this.checkPriorityFilter(items);
            }
        }
        return false;
    }

    public boolean checkCompleteIncompleteFilter(TreeItem[] items, boolean checkComplete) {
        TaskListUiTest.assertEquals((int)2, (int)items.length);
        int count = 0;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof TaskCategory) {
                TreeItem[] sub;
                TreeItem[] treeItemArray2 = sub = item.getItems();
                int n3 = sub.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem element = treeItemArray2[n4];
                    TaskListUiTest.assertTrue((boolean)(element.getData() instanceof ITask));
                    ITask task = (ITask)element.getData();
                    if (checkComplete) {
                        TaskListUiTest.assertTrue((boolean)task.isCompleted());
                    } else {
                        TaskListUiTest.assertFalse((boolean)task.isCompleted());
                    }
                    ++count;
                    ++n4;
                }
            }
            ++n2;
        }
        TaskListUiTest.assertEquals((int)5, (int)count);
        return true;
    }

    public boolean checkPriorityFilter(TreeItem[] items) {
        TaskListUiTest.assertEquals((int)2, (int)items.length);
        int p2Count = 0;
        int p1Count = 0;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof TaskCategory) {
                TreeItem[] sub;
                TreeItem[] treeItemArray2 = sub = item.getItems();
                int n3 = sub.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem element = treeItemArray2[n4];
                    TaskListUiTest.assertTrue((boolean)(element.getData() instanceof ITask));
                    ITask task = (ITask)element.getData();
                    TaskListUiTest.assertTrue((task.getPriority().equals("P2") || task.getPriority().equals("P1") ? 1 : 0) != 0);
                    if (task.getPriority().equals("P2")) {
                        ++p2Count;
                    } else {
                        ++p1Count;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        TaskListUiTest.assertEquals((int)2, (int)p1Count);
        TaskListUiTest.assertEquals((int)2, (int)p2Count);
        return true;
    }
}

