/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

abstract class AbstractHtmlBlock
extends SourceBlock {
    AbstractHtmlBlock() {
    }

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Line line;
        Line firstLine = line = lineSequence.getCurrentLine();
        while (line != null) {
            String lineText = line.getText();
            builder.charactersUnescaped(lineText);
            builder.charactersUnescaped("\n");
            lineSequence.advance();
            if (firstLine.equals(line)) {
                Matcher matcher = this.startPattern().matcher(lineText);
                Preconditions.checkState((boolean)matcher.matches());
                int offset = matcher.end(1);
                if (offset < lineText.length() - 1) {
                    Matcher closeMatcher = this.closePattern().matcher(lineText);
                    closeMatcher.region(offset, lineText.length());
                    if (closeMatcher.find()) {
                        break;
                    }
                }
            } else if (this.closePattern().matcher(lineText).find()) break;
            line = lineSequence.getCurrentLine();
        }
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        if (line != null) {
            return this.startPattern().matcher(line.getText()).matches();
        }
        return false;
    }

    protected abstract Pattern closePattern();

    protected abstract Pattern startPattern();
}

