/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.core.wikitext;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.eclipse.mylyn.docs.epub.core.Publication;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.util.XmlStreamWriter;

public class MarkupToOPS {
    private MarkupLanguage markupLanguage;

    public File parse(Publication ops, File markupFile) throws IOException, FileNotFoundException {
        if (this.markupLanguage == null) {
            throw new IllegalStateException("must set markupLanguage");
        }
        File workingFolder = File.createTempFile("wikitext_", null);
        if (workingFolder.delete() && workingFolder.mkdirs()) {
            Item item2;
            File htmlFile = new File(workingFolder.getAbsolutePath() + File.separator + "markup.html");
            FileWriter out = new FileWriter(htmlFile);
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder(out){

                protected XmlStreamWriter createXmlStreamWriter(Writer out) {
                    return HtmlDocumentBuilder.createFormattingXmlStreamWriter((Writer)out);
                }
            };
            List<Item> stylesheets = ops.getItemsByMIMEType("text/css");
            for (Item item2 : stylesheets) {
                File file = new File(item2.getFile());
                HtmlDocumentBuilder.Stylesheet css = new HtmlDocumentBuilder.Stylesheet(file);
                builder.addCssStylesheet(css);
            }
            builder.setEmitDtd(true);
            builder.setHtmlDtd("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
            builder.setXhtmlStrict(true);
            MarkupParser markupParser = new MarkupParser();
            markupParser.setBuilder((DocumentBuilder)builder);
            markupParser.setMarkupLanguage(this.markupLanguage);
            markupParser.parse((Reader)new FileReader(markupFile));
            ops.setGenerateToc(true);
            ops.setIncludeReferencedResources(true);
            item2 = ops.addItem(htmlFile);
            item2.setSourcePath(markupFile.getAbsolutePath());
        }
        return workingFolder;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }
}

