/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TypeConformanceResult {
    private final EnumSet<ConformanceHint> hints;
    private LightweightTypeReference from;
    private LightweightTypeReference to;

    public static TypeConformanceResult create(TypeConformanceComputationArgument argument, ConformanceHint hint) {
        if (argument.rawType) {
            if (ConformanceHint.RAW == hint) {
                throw new IllegalArgumentException();
            }
            return new TypeConformanceResult(EnumSet.of(ConformanceHint.RAW, hint));
        }
        return new TypeConformanceResult(EnumSet.of(hint));
    }

    public static TypeConformanceResult create(TypeConformanceComputationArgument argument, ConformanceHint hint, ConformanceHint ... hints) {
        EnumSet<ConformanceHint> hintsAsSet = EnumSet.of(hint);
        hintsAsSet.addAll(Arrays.asList(hints));
        if (argument.rawType) {
            hintsAsSet.add(ConformanceHint.RAW);
        }
        return new TypeConformanceResult(hintsAsSet);
    }

    public static TypeConformanceResult merge(TypeConformanceResult first, TypeConformanceResult second) {
        TypeConformanceResult result = new TypeConformanceResult(first.getConformanceHints());
        result.getConformanceHints().addAll(second.getConformanceHints());
        result.from = first.from;
        result.to = first.to;
        return result;
    }

    TypeConformanceResult(EnumSet<ConformanceHint> hints) {
        this.hints = hints;
        if (this.isConformant()) {
            hints.add(ConformanceHint.SUCCESS);
        }
    }

    public boolean isConformant() {
        return !this.hints.contains((Object)ConformanceHint.INCOMPATIBLE) && !this.hints.contains((Object)ConformanceHint.EXCEPTION);
    }

    protected void setConversion(LightweightTypeReference from, LightweightTypeReference to) {
        this.from = from;
        this.to = to;
    }

    public LightweightTypeReference getConvertFrom() {
        return this.from;
    }

    public LightweightTypeReference getConvertTo() {
        return this.to;
    }

    public EnumSet<ConformanceHint> getConformanceHints() {
        return this.hints;
    }

    public String toString() {
        return "TypeConformanceResult [hints=" + this.hints + "]";
    }
}

