/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConformanceHint {
    SUCCESS,
    INCOMPATIBLE,
    EXCEPTION,
    SUBTYPE,
    PRIMITIVE_WIDENING,
    BOXING,
    UNBOXING,
    RAWTYPE_CONVERSION,
    DEMAND_CONVERSION,
    SYNONYM,
    VAR_ARG,
    CHECKED,
    SEALED,
    UNCHECKED,
    RAW,
    LAMBDA_RAW_COMPATIBLE,
    LAMBDA_PARAMETER_COMPATIBLE,
    MERGED,
    EXPECTATION_INDEPENDENT,
    NO_IMPLICIT_RETURN,
    EXPLICIT_VOID_RETURN,
    PROPAGATED_TYPE;

    private static ConformanceHint[] shallowCheckedHints;

    static {
        shallowCheckedHints = new ConformanceHint[]{SYNONYM, VAR_ARG};
    }

    public static int compareHints(EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance) {
        if (leftConformance.contains((Object)SUCCESS) != rightConformance.contains((Object)SUCCESS)) {
            if (leftConformance.contains((Object)SUCCESS)) {
                return -1;
            }
            return 1;
        }
        if (leftConformance.contains((Object)LAMBDA_RAW_COMPATIBLE) != rightConformance.contains((Object)LAMBDA_RAW_COMPATIBLE)) {
            if (leftConformance.contains((Object)LAMBDA_RAW_COMPATIBLE)) {
                return -1;
            }
            return 1;
        }
        if (leftConformance.contains((Object)LAMBDA_PARAMETER_COMPATIBLE) != rightConformance.contains((Object)LAMBDA_PARAMETER_COMPATIBLE)) {
            if (leftConformance.contains((Object)LAMBDA_PARAMETER_COMPATIBLE)) {
                return -1;
            }
            return 1;
        }
        if (leftConformance.contains((Object)EXCEPTION) != rightConformance.contains((Object)EXCEPTION)) {
            if (leftConformance.contains((Object)EXCEPTION)) {
                return 1;
            }
            return -1;
        }
        ConformanceHint[] conformanceHintArray = shallowCheckedHints;
        int n = shallowCheckedHints.length;
        int n2 = 0;
        while (n2 < n) {
            boolean rightContains;
            ConformanceHint hint = conformanceHintArray[n2];
            boolean leftContains = leftConformance.contains((Object)hint);
            if (leftContains != (rightContains = rightConformance.contains((Object)hint))) {
                if (leftContains) {
                    return 1;
                }
                return -1;
            }
            ++n2;
        }
        return 0;
    }

    protected int compareByConformanceHint(EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance, ConformanceHint unexpectedHint) {
        boolean rightContains;
        boolean leftContains = leftConformance.contains((Object)unexpectedHint);
        if (leftContains != (rightContains = rightConformance.contains((Object)unexpectedHint))) {
            if (leftContains) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

