/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.ui.editor.hover.html.IEObjectHoverDocumentationProvider;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.JvmModelGenerator;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.hover.HoverLinkHelper;
import org.eclipse.xtext.xbase.ui.hover.HoverReference;
import org.eclipse.xtext.xbase.ui.hover.XbaseDeclarativeHoverSignatureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseHoverDocumentationProvider
implements IEObjectHoverDocumentationProvider {
    protected static final String BLOCK_TAG_START = "<dl>";
    protected static final String BLOCK_TAG_END = "</dl>";
    protected static final String BlOCK_TAG_ENTRY_START = "<dd>";
    protected static final String BlOCK_TAG_ENTRY_END = "</dd>";
    protected static final String PARAM_NAME_START = "<b>";
    protected static final String PARAM_NAME_END = "</b> ";
    protected String rawJavaDoc = "";
    protected EObject context = null;
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    protected IWorkspace workspace;
    @Inject
    protected IJvmModelAssociations associations;
    @Inject
    protected IEObjectDocumentationProvider documentationProvider;
    @Inject
    protected JvmModelGenerator jvmModelGenerator;
    @Inject
    private XbaseDeclarativeHoverSignatureProvider hoverSignatureProvider;
    protected StringBuffer buffer;
    protected int fLiteralContent;
    private static final String LINEBREAK = "\n";

    public String getDocumentation(EObject object) {
        return String.valueOf(this.computeDocumentation(object)) + this.getDerivedOrOriginalDeclarationInformation(object);
    }

    public String computeDocumentation(EObject object) {
        boolean hasExceptions;
        List fragments;
        this.buffer = new StringBuffer();
        this.context = object;
        this.fLiteralContent = 0;
        List<String> parameterNames = this.initParameterNames();
        Map<String, URI> exceptionNamesToURI = this.initExceptionNamesToURI();
        this.addAnnotations(object);
        this.getDocumentationWithPrefix(object);
        Javadoc javadoc = this.getJavaDoc();
        if (javadoc == null) {
            return "";
        }
        TagElement deprecatedTag = null;
        TagElement start = null;
        ArrayList<TagElement> parameters = new ArrayList<TagElement>();
        TagElement returnTag = null;
        ArrayList<TagElement> exceptions = new ArrayList<TagElement>();
        ArrayList<TagElement> versions = new ArrayList<TagElement>();
        ArrayList<TagElement> authors = new ArrayList<TagElement>();
        ArrayList<TagElement> sees = new ArrayList<TagElement>();
        ArrayList<TagElement> since = new ArrayList<TagElement>();
        ArrayList<TagElement> rest = new ArrayList<TagElement>();
        List tags = javadoc.tags();
        for (TagElement tag : tags) {
            String name;
            Object first;
            String tagName = tag.getTagName();
            if (tagName == null) {
                start = tag;
                continue;
            }
            if ("@param".equals(tagName)) {
                int paramIndex;
                parameters.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((first = fragments.get(0)) instanceof SimpleName) || (paramIndex = parameterNames.indexOf(name = ((SimpleName)first).getIdentifier())) == -1) continue;
                parameterNames.set(paramIndex, null);
                continue;
            }
            if ("@return".equals(tagName)) {
                if (returnTag != null) continue;
                returnTag = tag;
                continue;
            }
            if ("@exception".equals(tagName) || "@throws".equals(tagName)) {
                exceptions.add(tag);
                fragments = tag.fragments();
                if (fragments.size() <= 0 || !((first = fragments.get(0)) instanceof Name) || !exceptionNamesToURI.containsKey(name = ASTNodes.getSimpleNameIdentifier((Name)((Name)first)))) continue;
                exceptionNamesToURI.put(name, null);
                continue;
            }
            if ("@since".equals(tagName)) {
                since.add(tag);
                continue;
            }
            if ("@version".equals(tagName)) {
                versions.add(tag);
                continue;
            }
            if ("@author".equals(tagName)) {
                authors.add(tag);
                continue;
            }
            if ("@see".equals(tagName)) {
                sees.add(tag);
                continue;
            }
            if ("@deprecated".equals(tagName)) {
                if (deprecatedTag != null) continue;
                deprecatedTag = tag;
                continue;
            }
            rest.add(tag);
        }
        boolean hasParameters = parameters.size() > 0;
        boolean hasReturnTag = returnTag != null;
        boolean bl = hasExceptions = exceptions.size() > 0;
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (start != null) {
            fragments = start.fragments();
            this.handleContentElements(fragments);
        }
        if (hasParameters || hasReturnTag || hasExceptions || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || rest.size() > 0 || this.buffer.length() > 0 && (parameterNames.size() > 0 || exceptionNamesToURI.size() > 0)) {
            this.handleSuperMethodReferences(object);
            this.buffer.append(BLOCK_TAG_START);
            this.handleParameters(object, parameters, parameterNames);
            this.handleReturnTag(returnTag);
            this.handleExceptionTags(exceptions, exceptionNamesToURI);
            this.handleBlockTags("Since:", since);
            this.handleBlockTags("Version:", versions);
            this.handleBlockTags("Author:", authors);
            this.handleBlockTags("See Also:", sees);
            this.handleBlockTags(rest);
            this.buffer.append(BLOCK_TAG_END);
        } else if (this.buffer.length() > 0) {
            this.handleSuperMethodReferences(object);
        }
        String result = this.buffer.toString();
        this.buffer = null;
        this.rawJavaDoc = null;
        this.context = null;
        return result;
    }

    public String getDerivedOrOriginalDeclarationInformation(EObject object) {
        String derivedInformation = this.getDerivedElementInformation(object);
        if (derivedInformation != null && derivedInformation.length() > 0) {
            return this.getDerivedElementInformation(object);
        }
        return this.getOriginalDeclarationInformation(object);
    }

    protected List<String> initParameterNames() {
        ArrayList result = Lists.newArrayList();
        if (this.context instanceof JvmExecutable) {
            for (JvmFormalParameter param : ((JvmExecutable)this.context).getParameters()) {
                result.add(param.getName());
            }
        }
        return result;
    }

    protected Map<String, URI> initExceptionNamesToURI() {
        HashMap result = Maps.newHashMap();
        if (this.context instanceof JvmExecutable) {
            for (JvmTypeReference exception : ((JvmExecutable)this.context).getExceptions()) {
                result.put(exception.getSimpleName(), EcoreUtil.getURI((EObject)exception.getType()));
            }
        }
        return result;
    }

    protected void addAnnotations(EObject object) {
        EObject associatedElement;
        Set jvmElements = this.associations.getJvmElements(object);
        if (jvmElements.size() > 0 && (associatedElement = (EObject)Lists.newArrayList((Iterable)jvmElements).get(0)) instanceof JvmAnnotationTarget) {
            EList annotations = ((JvmAnnotationTarget)associatedElement).getAnnotations();
            for (JvmAnnotationReference annotationReference : annotations) {
                this.buffer.append("@");
                this.buffer.append(HoverLinkHelper.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)annotationReference.getAnnotation()), annotationReference.getAnnotation().getSimpleName()));
                if (annotationReference.getValues().size() > 0) {
                    this.buffer.append("(");
                    for (JvmAnnotationValue value : annotationReference.getValues()) {
                        FakeTreeAppendable appendable = new FakeTreeAppendable();
                        this.jvmModelGenerator.toJava(value, (ITreeAppendable)appendable);
                        String java = appendable.getContent();
                        this.buffer.append(java);
                    }
                    this.buffer.append(")");
                }
                this.buffer.append("<br>");
            }
        }
    }

    protected void getDocumentationWithPrefix(EObject object) {
        String startTag = "/**";
        String endTag = "*/";
        String documentation = this.documentationProvider.getDocumentation(object);
        if (documentation == null) {
            EObject primarySourceElement;
            DocumentationAdapter adapter = (DocumentationAdapter)EcoreUtil.getAdapter((List)object.eAdapters(), DocumentationAdapter.class);
            if (adapter != null) {
                documentation = adapter.getDocumentation();
            }
            if ((primarySourceElement = this.associations.getPrimarySourceElement(object)) != null) {
                documentation = this.documentationProvider.getDocumentation(primarySourceElement);
            }
        }
        if (documentation != null && documentation.length() > 0) {
            BufferedReader reader = new BufferedReader(new StringReader(documentation));
            StringBuilder builder = new StringBuilder(String.valueOf(startTag) + LINEBREAK);
            try {
                String line = "";
                while ((line = reader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    builder.append(String.valueOf(line) + LINEBREAK);
                }
                builder.append(endTag);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.rawJavaDoc = builder.toString();
        }
    }

    protected void handleSuperMethodReferences(EObject context) {
    }

    protected String createMethodInTypeLinks(JvmOperation overridden) {
        String methodLink = this.createSimpleMemberLink((EObject)overridden);
        String typeLink = this.createSimpleMemberLink((EObject)overridden.getDeclaringType());
        String methodInType = MessageFormat.format("{0} in {1}", methodLink, typeLink);
        return methodInType;
    }

    protected String createSimpleMemberLink(EObject type) {
        String label = "";
        if (type instanceof JvmDeclaredType) {
            label = ((JvmDeclaredType)type).getSimpleName();
        } else if (type instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)type;
            label = operation.getSimpleName();
            if (operation.getParameters().size() > 0) {
                label = String.valueOf(label) + "(...)";
            }
        }
        return HoverLinkHelper.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)type), label);
    }

    protected boolean handleValueTag(TagElement node) {
        this.handleText(node.toString());
        return true;
    }

    protected boolean handleInheritDoc(TagElement node) {
        if (!"@inheritDoc".equals(node.getTagName())) {
            return false;
        }
        this.handleText(node.toString());
        return true;
    }

    protected boolean handleDocRoot(TagElement node) {
        IFolder sourceFolder;
        if (!"@docRoot".equals(node.getTagName())) {
            return false;
        }
        URI uri = EcoreUtil.getURI((EObject)this.context);
        String projectName = uri.segment(1);
        String sourceFolderName = uri.segment(2);
        IProject project = this.workspace.getRoot().getProject(projectName);
        if (project.exists() && project.isOpen() && (sourceFolder = project.getFolder(sourceFolderName)).exists()) {
            this.buffer.append(sourceFolder.getLocationURI().toASCIIString());
        }
        return true;
    }

    protected void handleLink(List<?> fragments) {
        if (fragments.size() > 0) {
            URI elementURI = null;
            String firstFragment = fragments.get(0).toString();
            int hashIndex = firstFragment.indexOf("#");
            HoverReference reference = new HoverReference(TypesPackage.Literals.JVM_TYPE);
            IScope scope = this.scopeProvider.getScope(this.context, (EReference)reference);
            if (hashIndex != -1) {
                EObject resolvedDeclarator;
                IEObjectDescription declarator = scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName(firstFragment.substring(0, hashIndex)));
                if (declarator != null && !(resolvedDeclarator = this.context.eResource().getResourceSet().getEObject(declarator.getEObjectURI(), true)).eIsProxy() && resolvedDeclarator instanceof JvmGenericType) {
                    JvmGenericType castedDeclarator = (JvmGenericType)resolvedDeclarator;
                    String signature = firstFragment.substring(hashIndex + 1);
                    int indexOfOpenBracket = signature.indexOf("(");
                    int indexOfClosingBracket = signature.indexOf(")");
                    String[] splitedParameter = signature.substring(indexOfOpenBracket + 1, indexOfClosingBracket).split(",");
                    if (indexOfOpenBracket != -1) {
                        String simpleNameOfFeature = signature.substring(0, indexOfOpenBracket);
                        Iterable possibleCandidates = castedDeclarator.findAllFeaturesByName(simpleNameOfFeature);
                        Iterator featureIterator = possibleCandidates.iterator();
                        while (elementURI == null && featureIterator.hasNext()) {
                            JvmExecutable executable;
                            EList parameters;
                            JvmFeature feature = (JvmFeature)featureIterator.next();
                            boolean valid = false;
                            if (feature instanceof JvmField) {
                                valid = true;
                            } else if (feature instanceof JvmExecutable && (parameters = (executable = (JvmExecutable)feature).getParameters()).size() == splitedParameter.length) {
                                valid = true;
                                int i = 0;
                                while (i < parameters.size() && valid) {
                                    URI parameterTypeURI = EcoreUtil.getURI((EObject)((JvmFormalParameter)parameters.get(i)).getParameterType().getType());
                                    IEObjectDescription expectedParameter = this.scopeProvider.getScope(this.context, (EReference)reference).getSingleElement(this.qualifiedNameConverter.toQualifiedName(splitedParameter[i]));
                                    if (expectedParameter == null || !expectedParameter.getEObjectURI().equals((Object)parameterTypeURI)) {
                                        valid = false;
                                    }
                                    ++i;
                                }
                            }
                            if (!valid) continue;
                            elementURI = EcoreUtil.getURI((EObject)feature);
                        }
                    }
                }
            } else {
                IEObjectDescription singleElement = scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName(firstFragment));
                if (singleElement != null) {
                    elementURI = singleElement.getEObjectURI();
                }
            }
            String label = "";
            if (fragments.size() > 1) {
                int i = 1;
                while (i < fragments.size()) {
                    String portentialLabel = fragments.get(i).toString();
                    if (portentialLabel.trim().length() > 0) {
                        label = String.valueOf(label) + portentialLabel;
                    }
                    ++i;
                }
            }
            if (label.length() == 0) {
                label = firstFragment;
            }
            if (elementURI == null) {
                this.buffer.append(label);
            } else {
                this.buffer.append(HoverLinkHelper.createLinkWithLabel("eclipse-xtext-doc", elementURI, label));
            }
        }
    }

    protected void handleBlockTags(List<TagElement> tags) {
        for (TagElement tag : tags) {
            this.handleBlockTagTitle(tag.getTagName());
            this.buffer.append(BlOCK_TAG_ENTRY_START);
            List fragments = tag.fragments();
            this.handleContentElements(fragments);
            this.buffer.append(BlOCK_TAG_ENTRY_END);
        }
    }

    protected void handleBlockTags(String title, List<TagElement> tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        for (TagElement tag : tags) {
            this.buffer.append(BlOCK_TAG_ENTRY_START);
            if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else {
                List fragments = tag.fragments();
                this.handleContentElements(fragments);
            }
            this.buffer.append(BlOCK_TAG_ENTRY_END);
        }
    }

    protected void handleSeeTag(TagElement tag) {
        this.handleLink(tag.fragments());
    }

    protected void handleExceptionTags(List<TagElement> tags, Map<String, URI> exceptionNamesToURI) {
        if (tags.size() == 0 && this.containsOnlyNull(exceptionNamesToURI.values())) {
            return;
        }
        this.handleBlockTagTitle("Throws:");
        for (TagElement tag : tags) {
            this.buffer.append(BlOCK_TAG_ENTRY_START);
            this.handleThrowsTag(tag);
            this.buffer.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < exceptionNamesToURI.size()) {
            String name = (String)Lists.newArrayList(exceptionNamesToURI.keySet()).get(i);
            if (name != null && exceptionNamesToURI.get(name) != null) {
                this.buffer.append(BlOCK_TAG_ENTRY_START);
                this.buffer.append(HoverLinkHelper.createLinkWithLabel("eclipse-xtext-doc", exceptionNamesToURI.get(name), name));
                this.buffer.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private boolean containsOnlyNull(Collection<?> list) {
        Iterator<?> iter = list.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    protected void handleThrowsTag(TagElement tag) {
        List fragments = tag.fragments();
        int size = fragments.size();
        if (size > 0) {
            this.handleLink(fragments.subList(0, 1));
            if (size > 1) {
                this.buffer.append(JavaElementLabels.CONCAT_STRING);
                this.handleContentElements(fragments.subList(1, size));
            }
        }
    }

    protected void handleDeprecatedTag(TagElement tag) {
        this.buffer.append("<p><b>");
        this.buffer.append("Deprecated.");
        this.buffer.append("</b> <i>");
        List fragments = tag.fragments();
        this.handleContentElements(fragments);
        this.buffer.append("</i></p>");
    }

    protected void handleContentElements(List<? extends ASTNode> nodes) {
        this.handleContentElements(nodes, false);
    }

    protected void handleContentElements(List<? extends ASTNode> nodes, boolean skipLeadingWhitespace) {
        ASTNode previousNode = null;
        for (ASTNode aSTNode : nodes) {
            int childStart;
            int previousEnd;
            if (previousNode != null && (previousEnd = previousNode.getStartPosition() + previousNode.getLength()) <= (childStart = aSTNode.getStartPosition()) && previousEnd != childStart) {
                String textWithStars = this.rawJavaDoc.substring(previousEnd, childStart);
                String text = this.removeDocLineIntros(textWithStars);
                this.buffer.append(text);
            }
            previousNode = aSTNode;
            if (aSTNode instanceof TextElement) {
                String text = ((TextElement)aSTNode).getText();
                if (skipLeadingWhitespace) {
                    text = text.replaceFirst("^\\s+", "");
                }
                this.handleText(text);
                continue;
            }
            if (aSTNode instanceof TagElement) {
                this.handleInlineTagElement((TagElement)aSTNode);
                continue;
            }
            int start = aSTNode.getStartPosition();
            String text = this.rawJavaDoc.substring(start, start + aSTNode.getLength());
            this.buffer.append(this.removeDocLineIntros(text));
        }
    }

    protected void handleInlineTagElement(TagElement node) {
        String name = node.getTagName();
        if ("@value".equals(name) && this.handleValueTag(node)) {
            return;
        }
        boolean isLink = "@link".equals(name);
        boolean isLinkplain = "@linkplain".equals(name);
        boolean isCode = "@code".equals(name);
        boolean isLiteral = "@literal".equals(name);
        if (isLiteral || isCode) {
            ++this.fLiteralContent;
        }
        if (isLink || isCode) {
            this.buffer.append("<code>");
        }
        if (isLink || isLinkplain) {
            this.handleLink(node.fragments());
        } else if (isCode || isLiteral) {
            List fragments = node.fragments();
            this.handleContentElements(fragments, true);
        } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
            int start = node.getStartPosition();
            String text = this.rawJavaDoc.substring(start, start + node.getLength());
            this.buffer.append(this.removeDocLineIntros(text));
        }
        if (isLink || isCode) {
            this.buffer.append("</code>");
        }
        if (isLiteral || isCode) {
            --this.fLiteralContent;
        }
    }

    protected void handleText(String text) {
        if (this.fLiteralContent == 0) {
            this.buffer.append(text);
        } else {
            this.appendEscaped(this.buffer, text);
        }
    }

    protected void appendEscaped(StringBuffer buf, String text) {
        int nextToCopy = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            String rep = null;
            switch (ch) {
                case '&': {
                    rep = "&amp;";
                    break;
                }
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                }
            }
            if (rep != null) {
                if (nextToCopy < i) {
                    buf.append(text.substring(nextToCopy, i));
                }
                buf.append(rep);
                nextToCopy = i + 1;
            }
            ++i;
        }
        if (nextToCopy < length) {
            buf.append(text.substring(nextToCopy));
        }
    }

    protected String removeDocLineIntros(String textWithStars) {
        String lineBreakGroup = "(\\r\\n?|\\n)";
        String noBreakSpace = "[^\r\n&&\\s]";
        return textWithStars.replaceAll(String.valueOf(lineBreakGroup) + noBreakSpace + "*\\*", "$1");
    }

    protected void handleParameters(EObject object, List<TagElement> parameters, List<String> parameterNames) {
        if (parameters.size() == 0 && this.containsOnlyNull(parameterNames)) {
            return;
        }
        this.handleBlockTagTitle("Parameters:");
        for (TagElement tag : parameters) {
            this.buffer.append(BlOCK_TAG_ENTRY_START);
            this.handleParamTag(tag);
            this.buffer.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < parameterNames.size()) {
            String name = parameterNames.get(i);
            if (name != null) {
                this.buffer.append(BlOCK_TAG_ENTRY_START);
                this.buffer.append(PARAM_NAME_START);
                this.buffer.append(name);
                this.buffer.append(PARAM_NAME_END);
                this.buffer.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    protected void handleParamTag(TagElement tag) {
        List fragments = tag.fragments();
        int i = 0;
        int size = fragments.size();
        if (size > 0) {
            String firstText;
            Object first = fragments.get(0);
            this.buffer.append(PARAM_NAME_START);
            if (first instanceof SimpleName) {
                String name = ((SimpleName)first).getIdentifier();
                this.buffer.append(name);
                ++i;
            } else if (first instanceof TextElement && "<".equals(firstText = ((TextElement)first).getText())) {
                Object second;
                this.buffer.append("&lt;");
                ++i;
                if (size > 1 && (second = fragments.get(1)) instanceof SimpleName) {
                    Object third;
                    String thirdText;
                    String name = ((SimpleName)second).getIdentifier();
                    this.buffer.append(name);
                    ++i;
                    if (size > 2 && ">".equals(thirdText = ((TextElement)(third = fragments.get(2))).getText())) {
                        this.buffer.append("&gt;");
                        ++i;
                    }
                }
            }
            this.buffer.append(PARAM_NAME_END);
            this.handleContentElements(fragments.subList(i, fragments.size()));
        }
    }

    protected void handleReturnTag(TagElement tag) {
        if (tag == null) {
            return;
        }
        this.handleBlockTagTitle("Returns:");
        this.buffer.append(BlOCK_TAG_ENTRY_START);
        List fragments = tag.fragments();
        this.handleContentElements(fragments);
        this.buffer.append(BlOCK_TAG_ENTRY_END);
    }

    protected void handleBlockTagTitle(String title) {
        this.buffer.append("<dt>");
        this.buffer.append(title);
        this.buffer.append("</dt>");
    }

    public Javadoc getJavaDoc() {
        if (this.context == null) {
            return null;
        }
        Object classpathURIContext = ((XtextResourceSet)this.context.eResource().getResourceSet()).getClasspathURIContext();
        if (classpathURIContext instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)classpathURIContext;
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(javaProject);
            Map options = javaProject.getOptions(true);
            options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            parser.setCompilerOptions(options);
            String source = String.valueOf(this.rawJavaDoc) + "class C{}";
            parser.setSource(source.toCharArray());
            CompilationUnit root = (CompilationUnit)parser.createAST(null);
            if (root == null) {
                return null;
            }
            List types = root.types();
            if (types.size() != 1) {
                return null;
            }
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
            return type.getJavadoc();
        }
        return null;
    }

    protected String getDerivedElementInformation(EObject o) {
        StringBuffer buf = new StringBuffer();
        List<EObject> jvmElements = this.getFilteredDerivedElements(o, TypesPackage.Literals.JVM_MEMBER);
        if (jvmElements.size() > 0) {
            buf.append("<dt>Derived element:</dt>");
            for (EObject jvmElement : jvmElements) {
                buf.append(BlOCK_TAG_ENTRY_START);
                buf.append(this.computeLinkToElement(jvmElement));
                buf.append(BlOCK_TAG_ENTRY_END);
            }
        }
        return buf.toString();
    }

    protected String getOriginalDeclarationInformation(EObject o) {
        StringBuffer buf = new StringBuffer();
        List<EObject> sourceElements = this.getFilteredSourceElements(o, null);
        if (sourceElements.size() > 0) {
            buf.append("<dt>Original declaration:</dt>");
            for (EObject sourceElement : sourceElements) {
                buf.append(BlOCK_TAG_ENTRY_START);
                buf.append(this.computeLinkToElement(sourceElement));
                buf.append(BlOCK_TAG_ENTRY_END);
            }
        }
        return buf.toString();
    }

    protected List<EObject> getFilteredDerivedElements(EObject o, final EClass type) {
        ArrayList jvmElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.associations.getJvmElements(o), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                if (input instanceof JvmConstructor && ((JvmConstructor)input).getParameters().size() == 0) {
                    return false;
                }
                if (type == null) {
                    return true;
                }
                return EcoreUtil2.isAssignableFrom((EClass)type, (EClass)input.eClass());
            }
        }));
        return jvmElements;
    }

    protected List<EObject> getFilteredSourceElements(EObject o, final EClass type) {
        ArrayList sourceElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.associations.getSourceElements(o), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                if (type == null) {
                    return true;
                }
                return EcoreUtil2.isAssignableFrom((EClass)type, (EClass)input.eClass());
            }
        }));
        return sourceElements;
    }

    private String computeLinkToElement(EObject jvmElement) {
        String imageURL = this.hoverSignatureProvider.getImageTag(jvmElement);
        String signature = this.hoverSignatureProvider.getDerivedOrSourceSignature(jvmElement);
        return String.valueOf(imageURL) + HoverLinkHelper.createLinkWithLabel("eclipse-xtext-doc", EcoreUtil.getURI((EObject)jvmElement), signature);
    }
}

