/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.navigation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;

public class LinkToOriginDetector
extends AbstractHyperlinkDetector {
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    private DerivedResourceMarkers derivedResourceMarkers;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        try {
            IJavaElement[] javaElements;
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (textEditor == null) {
            }
            IEditorInput editorInput = textEditor.getEditorInput();
            if (editorInput == null) {
            }
            ICompilationUnit adaptedJavaElement = (ICompilationUnit)Platform.getAdapterManager().getAdapter((Object)editorInput, IJavaElement.class);
            if (adaptedJavaElement == null) {
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)adaptedJavaElement.getAncestor(5);
            if (compilationUnit == null) {
            }
            IRegion selectedWord = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
            IJavaElement[] iJavaElementArray = javaElements = compilationUnit.codeSelect(selectedWord.getOffset(), selectedWord.getLength());
            int n = javaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IType selectedType;
                IResource resource;
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof IType && (resource = (selectedType = (IType)javaElement).getResource()) instanceof IFile) {
                    IMarker[] markers = this.derivedResourceMarkers.findDerivedResourceMarkers((IFile)resource);
                    if (!canShowMultipleHyperlinks && markers.length > 1) {
                    }
                    ArrayList result = Lists.newArrayListWithCapacity((int)markers.length);
                    IMarker[] iMarkerArray = markers;
                    int n3 = markers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMarker marker = iMarkerArray[n4];
                        String source = this.derivedResourceMarkers.getSource(marker);
                        if (source != null) {
                            try {
                                URI uri = URI.createURI((String)source);
                                XtextHyperlink hyperlink = (XtextHyperlink)this.hyperlinkProvider.get();
                                hyperlink.setHyperlinkRegion(new Region(selectedWord.getOffset(), selectedWord.getLength()));
                                hyperlink.setURI(uri);
                                hyperlink.setHyperlinkText("Go to " + uri.lastSegment());
                                hyperlink.setTypeLabel("Navigate to source artifact");
                                result.add(hyperlink);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                    if (result.isEmpty()) {
                    }
                    return result.toArray(new IHyperlink[result.size()]);
                }
                ++n2;
            }
        }
        finally {
            return null;
        }
    }
}

