/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.util.StringInputStream;

public class EclipseResourceFileSystemAccess2
extends AbstractFileSystemAccess {
    private IProject project;
    private IProgressMonitor monitor;
    private IFileCallback callBack;

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setPostProcessor(IFileCallback callBack) {
        this.callBack = callBack;
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void generateFile(String fileName, String outputName, CharSequence contents) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        OutputConfiguration outputConfig = this.getOutputConfig(outputName);
        IFolder folder = this.getFolder(outputConfig);
        if (!folder.exists()) {
            if (outputConfig.isCreateOutputDirectory()) {
                try {
                    this.createFolder(folder);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            } else {
                return;
            }
        }
        IFile file = this.getFile(fileName, outputName);
        String contentsAsString = contents.toString();
        if (file.exists()) {
            if (outputConfig.isOverrideExistingResources()) {
                try {
                    StringInputStream newContent = this.getInputStream(contentsAsString, file.getCharset(true));
                    if (this.hasContentsChanged(file, newContent)) {
                        newContent.reset();
                        file.setContents((InputStream)newContent, true, true, this.monitor);
                        if (file.isDerived() != outputConfig.isSetDerivedProperty()) {
                            file.setDerived(outputConfig.isSetDerivedProperty());
                        }
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                this.callBack.afterFileUpdate(file);
            }
        } else {
            try {
                this.ensureParentExists(file);
                file.create((InputStream)this.getInputStream(contentsAsString, file.getCharset(true)), true, this.monitor);
                if (outputConfig.isSetDerivedProperty()) {
                    file.setDerived(true);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            this.callBack.afterFileCreation(file);
        }
    }

    protected void createFolder(IFolder folder) throws CoreException {
        this.ensureExists((IContainer)folder);
    }

    protected void ensureParentExists(IFile file) throws CoreException {
        if (!file.exists()) {
            this.ensureExists(file.getParent());
        }
    }

    protected void ensureExists(IContainer container) throws CoreException {
        if (container.exists()) {
            return;
        }
        if (container instanceof IFolder) {
            this.ensureExists(container.getParent());
            ((IFolder)container).create(true, true, this.monitor);
        }
    }

    protected StringInputStream getInputStream(String contentsAsString, String encoding) {
        try {
            return new StringInputStream(contentsAsString, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected IFolder getFolder(OutputConfiguration outputConfig) {
        return this.project.getFolder((IPath)new Path(outputConfig.getOutputDirectory()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasContentsChanged(IFile file, StringInputStream newContent) {
        boolean contentChanged = false;
        BufferedInputStream oldContent = null;
        try {
            try {
                oldContent = new BufferedInputStream(file.getContents());
                int newByte = newContent.read();
                int oldByte = oldContent.read();
                while (newByte != -1 && oldByte != -1 && newByte == oldByte) {
                    newByte = newContent.read();
                    oldByte = oldContent.read();
                }
                contentChanged = newByte != oldByte;
                return contentChanged;
            }
            catch (CoreException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
            catch (IOException e) {
                contentChanged = true;
                if (oldContent == null) return contentChanged;
                try {
                    oldContent.close();
                    return contentChanged;
                }
                catch (IOException iOException) {}
                return contentChanged;
            }
        }
        finally {
            if (oldContent != null) {
                try {
                    oldContent.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void deleteFile(String fileName, String outputName) {
        try {
            IFile file = this.getFile(fileName, outputName);
            if (this.callBack.beforeFileDeletion(file) && file.exists()) {
                file.delete(2, this.monitor);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected IFile getFile(String fileName, String outputName) {
        OutputConfiguration configuration = this.getOutputConfig(outputName);
        Path path = new Path(String.valueOf(configuration.getOutputDirectory()) + "/" + fileName);
        return this.project.getFile((IPath)path);
    }

    public static interface IFileCallback {
        public void afterFileUpdate(IFile var1);

        public void afterFileCreation(IFile var1);

        public boolean beforeFileDeletion(IFile var1);
    }
}

