/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Exceptions;

class SerializationExtensions {
    SerializationExtensions() {
    }

    public static <T extends ENamedElement> T readEcoreElement(ObjectInput in) {
        URI uri = SerializationExtensions.readURI(in);
        URI _trimFragment = uri.trimFragment();
        String _string = _trimFragment.toString();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(_string);
        Resource _eResource = ePackage.eResource();
        String _fragment = uri.fragment();
        EObject _eObject = _eResource.getEObject(_fragment);
        return (T)((ENamedElement)_eObject);
    }

    public static void writeEcoreElement(ObjectOutput out, ENamedElement namedElement) {
        URI uri = EcoreUtil.getURI((EObject)namedElement);
        SerializationExtensions.writeURI(out, uri);
    }

    public static <T> T readCastedObject(ObjectInput in) {
        try {
            Object _readObject = in.readObject();
            return (T)_readObject;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static URI readURI(ObjectInput in) {
        String stringRep;
        block3: {
            try {
                stringRep = in.readUTF();
                boolean _equals = Objects.equal((Object)stringRep, (Object)"NULL");
                if (!_equals) break block3;
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        return URI.createURI((String)stringRep);
    }

    public static void writeURI(ObjectOutput out, URI uri) {
        try {
            boolean _equals = Objects.equal((Object)uri, null);
            if (_equals) {
                out.writeUTF("NULL");
            } else {
                String _string = uri.toString();
                out.writeUTF(_string);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static QualifiedName readQualifiedName(ObjectInput in) {
        try {
            Object _readObject = in.readObject();
            return QualifiedName.create((ArrayList)_readObject);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void writeQualifiedName(ObjectOutput out, QualifiedName name) {
        try {
            List<String> _segments = name.getSegments();
            ArrayList<String> _arrayList = new ArrayList<String>(_segments);
            out.writeObject(_arrayList);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

