/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.xtext.ui.util.FeatureProjectFactory;
import org.eclipse.xtext.ui.util.IProjectFactoryContributor;
import org.eclipse.xtext.ui.util.PluginProjectFactory;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.ui.wizard.AbstractProjectCreator;
import org.eclipse.xtext.xtext.ui.wizard.project.DslProjectContributor;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;
import org.eclipse.xtext.xtext.ui.wizard.project.TestProjectContributor;
import org.eclipse.xtext.xtext.ui.wizard.project.XtextProjectInfo;

public class XtextProjectCreator
extends AbstractProjectCreator {
    protected static final String[] DSL_PROJECT_NATURES = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature"};
    protected static final String[] DSL_UI_PROJECT_NATURES = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", "org.eclipse.xtext.ui.shared.xtextNature"};
    protected static final String[] BUILDERS = new String[]{"org.eclipse.jdt.core.javabuilder", "org.eclipse.pde.ManifestBuilder", "org.eclipse.pde.SchemaBuilder", "org.eclipse.xtext.ui.shared.xtextBuilder"};
    protected static final String[] GENERATOR_PROJECT_NATURES = DSL_UI_PROJECT_NATURES;
    protected static final String[] TEST_PROJECT_NATURES = DSL_UI_PROJECT_NATURES;
    protected static final String SRC_GEN_ROOT = "src-gen";
    protected static final String SRC_ROOT = "src";
    protected static final String XTEND_GEN_ROOT = "xtend-gen";
    protected static final List<String> SRC_FOLDER_LIST = ImmutableList.of((Object)"src", (Object)"src-gen");
    @Inject
    private Provider<PluginProjectFactory> projectFactoryProvider;
    @Inject
    private Provider<FeatureProjectFactory> featureProjFactoryProvider;

    protected XtextProjectInfo getXtextProjectInfo() {
        return (XtextProjectInfo)this.getProjectInfo();
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getCreateModelProjectMessage(), (int)this.getMonitorTicks());
        IProject project = this.createDslProject((IProgressMonitor)subMonitor.newChild(1));
        this.createDslUiProject((IProgressMonitor)subMonitor.newChild(1));
        if (this.getXtextProjectInfo().isCreateTestProject()) {
            this.createTestProject((IProgressMonitor)subMonitor.newChild(1));
        }
        if (this.getXtextProjectInfo().isCreateFeatureProject()) {
            this.createFeatureProject(subMonitor.newChild(1));
        }
        IFile dslGrammarFile = project.getFile(String.valueOf(this.getModelFolderName()) + "/" + this.getXtextProjectInfo().getGrammarFilePath());
        BasicNewResourceWizard.selectAndReveal((IResource)dslGrammarFile, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        this.setResult(dslGrammarFile);
    }

    protected int getMonitorTicks() {
        int ticks = 2;
        int n = ticks = this.getXtextProjectInfo().isCreateTestProject() ? ticks + 1 : ticks;
        if (this.getXtextProjectInfo().isCreateFeatureProject()) {
            ++ticks;
        }
        return ticks;
    }

    protected PluginProjectFactory createProjectFactory() {
        return (PluginProjectFactory)this.projectFactoryProvider.get();
    }

    protected FeatureProjectFactory createFeatureFactory() {
        return (FeatureProjectFactory)this.featureProjFactoryProvider.get();
    }

    protected String getCreateModelProjectMessage() {
        return String.valueOf(Messages.XtextProjectCreator_CreatingProjectsMessage2) + this.getXtextProjectInfo().getProjectName();
    }

    protected IProject createDslUiProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureDslUiProjectFactory(factory);
        return factory.createProject(monitor, null);
    }

    protected void configureDslUiProjectFactory(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        factory.addFolders(Collections.singletonList(XTEND_GEN_ROOT));
        List<String> requiredBundles = this.getDslUiProjectRequiredBundles();
        factory.setProjectName(this.getXtextProjectInfo().getUiProjectName());
        factory.addProjectNatures(this.getDslUiProjectNatures());
        factory.addRequiredBundles(requiredBundles);
        factory.setProjectDefaultCharset(Charsets.UTF_8.name());
        factory.setLocation(this.getXtextProjectInfo().getUiProjectLocation());
    }

    protected List<String> getDslUiProjectRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{String.valueOf(this.getXtextProjectInfo().getProjectName()) + ";visibility:=reexport", "org.eclipse.xtext.ui", "org.eclipse.ui.editors;bundle-version=\"3.5.0\"", "org.eclipse.ui.ide;bundle-version=\"3.5.0\""});
        return requiredBundles;
    }

    protected String[] getDslUiProjectNatures() {
        return DSL_UI_PROJECT_NATURES;
    }

    protected IProject createDslProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureDslProjectFactory(factory);
        return factory.createProject(monitor, null);
    }

    protected void configureDslProjectFactory(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        factory.addFolders(Collections.singletonList(XTEND_GEN_ROOT));
        factory.setProjectName(this.getXtextProjectInfo().getProjectName());
        factory.addProjectNatures(this.getDslProjectNatures());
        factory.addRequiredBundles(this.getDslProjectRequiredBundles());
        factory.addDevelopmentTimeBundles(this.getDslProjectDevelopmentBundles());
        factory.setLocation(this.getXtextProjectInfo().getDslProjectLocation());
        factory.setProjectDefaultCharset(Charsets.UTF_8.name());
        factory.addContributor(this.createDslProjectContributor());
    }

    protected List<String> getDslProjectRequiredBundles() {
        String[] bundles;
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{"org.eclipse.xtext;visibility:=reexport", "org.eclipse.equinox.common;bundle-version=\"3.5.0\""});
        String[] stringArray = bundles = this.getXtextProjectInfo().getWizardContribution().getRequiredBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            requiredBundles.add(String.valueOf(bundleId.trim()) + ";resolution:=optional");
            ++n2;
        }
        for (String bundleId : this.getAdditionalRequiredBundles()) {
            requiredBundles.add(bundleId.trim());
        }
        return requiredBundles;
    }

    protected List<String> getDslProjectDevelopmentBundles() {
        return Lists.newArrayList((Object[])new String[]{"org.eclipse.xtext.xbase", "org.eclipse.xtext.generator", "org.apache.commons.logging", "org.eclipse.emf.codegen.ecore", "org.eclipse.emf.mwe.utils", "org.eclipse.emf.mwe2.launch", "org.eclipse.xtext.common.types", "org.objectweb.asm"});
    }

    protected String[] getDslProjectNatures() {
        return DSL_PROJECT_NATURES;
    }

    protected PluginProjectFactory configureProjectFactory(ProjectFactory factory) {
        PluginProjectFactory result = (PluginProjectFactory)factory;
        result.addWorkingSets(Arrays.asList(this.getXtextProjectInfo().getWorkingSets()));
        result.addBuilderIds(this.getBuilderIDs());
        result.addImportedPackages(this.getImportedPackages());
        result.addFolders(this.getAllFolders());
        return result;
    }

    protected String[] getBuilderIDs() {
        return BUILDERS;
    }

    protected String[] getTestProjectNatures() {
        return TEST_PROJECT_NATURES;
    }

    protected IProject createTestProject(IProgressMonitor monitor) throws CoreException {
        PluginProjectFactory factory = this.createProjectFactory();
        this.configureTestProjectFactory(factory);
        factory.addContributor((IProjectFactoryContributor)this.createTestProjectContributor());
        return factory.createProject(monitor, null);
    }

    private TestProjectContributor createTestProjectContributor() {
        return new TestProjectContributor(this.getXtextProjectInfo());
    }

    protected IProject createFeatureProject(SubMonitor monitor) throws CoreException {
        FeatureProjectFactory factory = this.createFeatureFactory();
        this.configureFeatureProjectFactory(factory);
        return factory.createProject((IProgressMonitor)monitor, null);
    }

    protected void configureFeatureProjectFactory(FeatureProjectFactory factory) {
        factory.setProjectName(this.getXtextProjectInfo().getFeatureProjectName());
        factory.setLocation(this.getXtextProjectInfo().getFeatureProjectLocation());
        factory.setFeatureLabel(String.format(Messages.XtextProjectCreator_FeatureLabel, this.getXtextProjectInfo().getLanguageNameAbbreviation()));
        factory.addProjectNatures(new String[]{"org.eclipse.pde.FeatureNature"});
        factory.addBuilderIds(new String[]{"org.eclipse.pde.FeatureBuilder"});
        factory.addBundle(this.getXtextProjectInfo().getProjectName());
        factory.addBundle(this.getXtextProjectInfo().getUiProjectName());
        factory.addWorkingSets(Arrays.asList(this.getXtextProjectInfo().getWorkingSets()));
    }

    protected void configureTestProjectFactory(PluginProjectFactory factory) {
        this.configureProjectFactory((ProjectFactory)factory);
        factory.addFolders(Collections.singletonList(XTEND_GEN_ROOT));
        List<String> requiredBundles = this.getTestProjectRequiredBundles();
        factory.setProjectName(this.getXtextProjectInfo().getTestProjectName());
        factory.addProjectNatures(this.getTestProjectNatures());
        factory.addRequiredBundles(requiredBundles);
        factory.addImportedPackages(this.getTestProjectImportedPackages());
        factory.setProjectDefaultCharset(Charsets.UTF_8.name());
        factory.setLocation(this.getXtextProjectInfo().getTestProjectLocation());
    }

    protected List<String> getTestProjectImportedPackages() {
        return Lists.newArrayList((Object[])new String[]{"org.junit;version=\"4.5.0\"", "org.junit.runner;version=\"4.5.0\"", "org.junit.runner.manipulation;version=\"4.5.0\"", "org.junit.runner.notification;version=\"4.5.0\"", "org.junit.runners;version=\"4.5.0\"", "org.junit.runners.model;version=\"4.5.0\"", "org.hamcrest.core"});
    }

    protected List<String> getTestProjectRequiredBundles() {
        ArrayList requiredBundles = Lists.newArrayList((Object[])new String[]{this.getXtextProjectInfo().getProjectName(), this.getXtextProjectInfo().getUiProjectName(), "org.eclipse.core.runtime", "org.eclipse.xtext.junit4", "org.eclipse.xtext.xbase.lib", "org.eclipse.ui.workbench;resolution:=optional"});
        return requiredBundles;
    }

    protected List<String> getImportedPackages() {
        return Lists.newArrayList((Object[])new String[]{"org.apache.log4j"});
    }

    protected Collection<String> getAdditionalRequiredBundles() {
        return Collections.emptyList();
    }

    protected String getModelFolderName() {
        return SRC_ROOT;
    }

    protected List<String> getAllFolders() {
        return SRC_FOLDER_LIST;
    }

    protected IProjectFactoryContributor createDslProjectContributor() {
        DslProjectContributor dslProjectContributor = new DslProjectContributor(this.getXtextProjectInfo());
        dslProjectContributor.setSourceRoot(SRC_ROOT);
        return dslProjectContributor;
    }
}

