/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.templates;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.Messages;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class EnumTemplateVariableResolver
extends AbstractTemplateVariableResolver {
    public EnumTemplateVariableResolver() {
        super(Messages.EnumTemplateVariableResolver_0, String.valueOf(Messages.EnumTemplateVariableResolver_1) + Messages.EnumTemplateVariableResolver_2);
    }

    @Override
    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext castedContext) {
        String enumerationName = (String)variable.getVariableType().getParams().iterator().next();
        Grammar grammar = this.getGrammar(castedContext);
        if (grammar == null) {
            return Collections.emptyList();
        }
        EEnum enumeration = (EEnum)this.getEClassifierForGrammar(enumerationName, grammar);
        if (enumeration == null) {
            return Collections.emptyList();
        }
        return Lists.transform((List)enumeration.getELiterals(), (Function)new Function<EEnumLiteral, String>(){

            public String apply(EEnumLiteral enumLiteral) {
                return enumLiteral.getLiteral();
            }
        });
    }
}

