/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.EnumSet;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeData;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionBasedComputationResult
implements ITypeComputationResult {
    private final XExpression expression;
    private final ResolvedTypes resolution;

    public ResolutionBasedComputationResult(XExpression expression, ResolvedTypes resolution) {
        this.expression = expression;
        this.resolution = resolution;
    }

    @Override
    public LightweightTypeReference getActualExpressionType() {
        return this.resolution.getActualType(this.expression);
    }

    @Override
    public LightweightTypeReference getReturnType() {
        return this.resolution.getReturnType(this.expression);
    }

    @Override
    public XExpression getExpression() {
        return this.expression;
    }

    @Override
    public LightweightTypeReference getExpectedExpressionType() {
        return this.resolution.getExpectedType(this.expression);
    }

    @Override
    public LightweightTypeReference getExpectedReturnType() {
        return this.resolution.getExpectedReturnType(this.expression);
    }

    @Override
    public EnumSet<ConformanceHint> getConformanceHints() {
        TypeData typeData = this.resolution.getTypeData(this.expression, false);
        if (typeData == null) {
            return EnumSet.noneOf(ConformanceHint.class);
        }
        return typeData.getConformanceHints();
    }

    @Override
    public EnumSet<ConformanceHint> getCheckedConformanceHints() {
        TypeData typeData = this.resolution.getTypeData(this.expression, false);
        if (typeData == null) {
            return EnumSet.noneOf(ConformanceHint.class);
        }
        return this.resolution.getConformanceHints(typeData, false);
    }

    public String toString() {
        return String.format("Result %s for %s", this.getActualExpressionType(), this.expression);
    }
}

