/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.outline;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.editor.GlobalURIEditorOpener;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeElementOpener;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class JvmOutlineNodeElementOpener
extends OutlineNodeElementOpener {
    private static Logger LOG = Logger.getLogger(JvmOutlineNodeElementOpener.class);
    @Inject
    private IJavaElementFinder javaElementFinder;
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private GlobalURIEditorOpener globalURIEditorOpener;

    protected void openEObject(EObject state) {
        try {
            IJavaElement javaElement;
            if (state instanceof JvmIdentifiableElement && (javaElement = this.javaElementFinder.findElementFor((JvmIdentifiableElement)state)) instanceof IMember) {
                ISourceRange sourceRange;
                ILocationInResource sourceInformation;
                ITrace traceToSource;
                IResource resource = javaElement.getResource();
                if (resource instanceof IStorage && (traceToSource = this.traceInformation.getTraceToSource((IStorage)resource)) != null && (sourceInformation = traceToSource.getBestAssociatedLocation((ITextRegion)new TextRegion((sourceRange = ((IMember)javaElement).getSourceRange()).getOffset(), sourceRange.getLength()))) != null) {
                    this.globalURIEditorOpener.open(sourceInformation.getAbsoluteResourceURI(), (Object)javaElement, true);
                    return;
                }
                this.globalURIEditorOpener.open(null, (Object)javaElement, true);
                return;
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error opening java editor", (Throwable)exc);
        }
        super.openEObject(state);
    }
}

