/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.typing;

import com.google.common.collect.Sets;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAnnotationUtil {
    public JvmOperation findSingleValueAttribute(JvmAnnotationType type) {
        Iterable operations = type.getDeclaredOperations();
        for (JvmOperation operation : operations) {
            if (!operation.getSimpleName().equals("value")) continue;
            return operation;
        }
        return null;
    }

    public XExpression findValue(XAnnotation annotation, JvmOperation jvmOperation) {
        if (jvmOperation.getSimpleName().equals("value") && annotation.getValue() != null) {
            return annotation.getValue();
        }
        for (XAnnotationElementValuePair pair : annotation.getElementValuePairs()) {
            if (pair.getElement() != jvmOperation) continue;
            return pair.getValue();
        }
        return null;
    }

    public Set<ElementType> getAnnotationTargets(JvmAnnotationType annotation) {
        EList annotations = annotation.getAnnotations();
        for (JvmAnnotationReference annoRef : annotations) {
            EList values;
            JvmAnnotationValue value;
            if (!Target.class.getName().equals(annoRef.getAnnotation().getIdentifier()) || !((value = (JvmAnnotationValue)(values = annoRef.getValues()).get(0)) instanceof JvmEnumAnnotationValue)) continue;
            HashSet result = Sets.newHashSet();
            for (JvmEnumerationLiteral elementType : ((JvmEnumAnnotationValue)value).getValues()) {
                String simpleName = elementType.getSimpleName();
                result.add(ElementType.valueOf(simpleName));
            }
            return result;
        }
        return Collections.emptySet();
    }
}

