/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ITypeLiteralLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeLiteralHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TypeLiteralLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements ITypeLiteralLinkingCandidate {
    private TypeLiteralHelper helper;

    public TypeLiteralLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ExpressionTypeComputationState state) {
        super(featureCall, description, state);
        if (featureCall.isExplicitOperationCallOrBuilderSyntax()) {
            throw new IllegalArgumentException("Cannot be a type literal: " + String.valueOf(featureCall));
        }
        this.helper = new TypeLiteralHelper(state);
    }

    @Override
    public void computeArgumentTypes() {
    }

    @Override
    protected List<XExpression> getArguments() {
        return Collections.emptyList();
    }

    @Override
    protected String getFeatureTypeName() {
        return "type";
    }

    @Override
    public int getArityMismatch() {
        return 0;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean isExtension() {
        return false;
    }

    @Override
    protected boolean hasReceiver() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isTypeLiteral() {
        return true;
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        return this.helper.getAsClassLiteral(feature);
    }

    @Override
    protected List<JvmTypeParameter> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public int getTypeArityMismatch() {
        return 0;
    }

    @Override
    protected int getTypeArgumentConformanceFailures(@Nullable IAcceptor<? super AbstractDiagnostic> acceptor) {
        return 0;
    }

    @Override
    public List<LightweightTypeReference> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    protected void preApply() {
        this.helper.applyPackageFragment((XAbstractFeatureCall)this.getExpression(), this.getType());
    }

    @Override
    public JvmType getType() {
        return (JvmType)this.getFeature();
    }

    @Override
    public void applyToModel() {
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }

    @Override
    protected void internalSetValue(InternalEObject featureCall, EReference structuralFeature, JvmIdentifiableElement newValue) {
        super.internalSetValue(featureCall, structuralFeature, newValue);
        if (featureCall instanceof XFeatureCall) {
            XFeatureCall casted = (XFeatureCall)featureCall;
            if (casted != this.getExpression()) {
                casted.setPackageFragment(true);
            } else {
                casted.setTypeLiteral(true);
            }
        } else if (featureCall instanceof XMemberFeatureCall) {
            XMemberFeatureCall casted = (XMemberFeatureCall)featureCall;
            if (casted != this.getExpression()) {
                casted.setPackageFragment(true);
            } else {
                casted.setTypeLiteral(true);
            }
            XExpression target = casted.getMemberCallTarget();
            IFeatureLinkingCandidate candidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)target);
            if (candidate == null || !candidate.isTypeLiteral()) {
                this.resolveLinkingProxy((InternalEObject)target, newValue, structuralFeature, 0);
            }
        }
    }
}

