/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class TypeData {
    private final XExpression expression;
    private final ITypeExpectation expectation;
    private final LightweightTypeReference type;
    private final EnumSet<ConformanceHint> hints;
    private final boolean returnType;

    public TypeData(XExpression expression, ITypeExpectation expectation, LightweightTypeReference type, EnumSet<ConformanceHint> hints, boolean returnType) {
        if (!hints.contains((Object)ConformanceHint.CHECKED) && !hints.contains((Object)ConformanceHint.UNCHECKED)) {
            throw new IllegalArgumentException("Invalid hints: " + hints);
        }
        this.expression = expression;
        this.expectation = expectation;
        this.type = type;
        this.hints = hints;
        this.returnType = returnType;
    }

    public boolean isOwnedBy(ITypeReferenceOwner owner) {
        return this.expectation.isOwnedBy(owner) && this.type.isOwnedBy(owner);
    }

    public String toString() {
        return "TypeData [expectation=" + this.expectation + ", type=" + this.type + ", conformanceHint=" + this.hints + ", returnType=" + this.returnType + "]";
    }

    public ITypeExpectation getExpectation() {
        return this.expectation;
    }

    public EnumSet<ConformanceHint> getConformanceHints() {
        return this.hints;
    }

    public XExpression getExpression() {
        return this.expression;
    }

    public LightweightTypeReference getActualType() {
        return this.type;
    }

    public boolean isReturnType() {
        return this.returnType;
    }
}

