/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategyProvider;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractRenameStrategy
implements DefaultRenameStrategyProvider.IInitializable {
    private String originalName;
    private URI targetElementOriginalURI;
    private URI targetElementNewURI;
    private EAttribute nameAttribute;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        this.nameAttribute = this.getNameAttribute(targetElement);
        if (this.nameAttribute == null) {
            return false;
        }
        this.targetElementOriginalURI = EcoreUtil.getURI((EObject)targetElement);
        this.originalName = targetElement.eGet((EStructuralFeature)this.nameAttribute).toString();
        return !Strings.isEmpty((String)this.originalName);
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public RefactoringStatus validateNewName(String newName) {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        EObject renamedElement = this.setName(this.targetElementOriginalURI, newName, resourceSet);
        this.targetElementNewURI = EcoreUtil.getURI((EObject)renamedElement);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        if (this.targetElementNewURI == null) {
            return;
        }
        this.setName(this.targetElementNewURI, this.originalName, resourceSet);
    }

    protected EObject setName(URI targetElementURI, String newName, ResourceSet resourceSet) {
        EObject targetElement = resourceSet.getEObject(targetElementURI, false);
        if (targetElement == null) {
            throw new RefactoringException("Target element not loaded.");
        }
        targetElement.eSet((EStructuralFeature)this.nameAttribute, (Object)newName);
        return targetElement;
    }

    protected URI getTargetElementOriginalURI() {
        return this.targetElementOriginalURI;
    }

    protected URI getTargetElementNewURI() {
        return this.targetElementNewURI;
    }

    protected EAttribute getNameAttribute(EObject targetElement) {
        return SimpleAttributeResolver.NAME_RESOLVER.getAttribute(targetElement);
    }

    protected EAttribute getNameAttribute() {
        return this.nameAttribute;
    }
}

