/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.actions;

import com.google.inject.Inject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineNodeElementOpener;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class OutlineWithEditorLinker
implements IPropertyChangeListener {
    protected ISourceViewer textViewer;
    protected TreeViewer treeViewer;
    protected TreeListener treeListener;
    protected TextListener textListener;
    protected boolean isLinkingEnabled;
    protected OutlinePage outlinePage;
    @Inject
    private OutlineNodeElementOpener elementOpener;

    public void activate(OutlinePage outlinePage) {
        this.outlinePage = outlinePage;
        this.treeViewer = outlinePage.getTreeViewer();
        this.treeListener = new TreeListener();
        this.treeViewer.addPostSelectionChangedListener((ISelectionChangedListener)this.treeListener);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.treeListener);
        this.textViewer = outlinePage.getSourceViewer();
        this.textListener = new TextListener();
        ISelectionProvider textSelectionProvider = this.textViewer.getSelectionProvider();
        if (textSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)textSelectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this.textListener);
        } else {
            textSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.textListener);
        }
    }

    public void deactivate() {
        ISelectionProvider textSelectionProvider = this.textViewer.getSelectionProvider();
        if (textSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)textSelectionProvider).removePostSelectionChangedListener((ISelectionChangedListener)this.textListener);
        } else {
            textSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.textListener);
        }
        this.textListener = null;
        this.textViewer = null;
        this.treeViewer.removePostSelectionChangedListener((ISelectionChangedListener)this.treeListener);
        this.treeViewer.removeDoubleClickListener((IDoubleClickListener)this.treeListener);
        this.treeViewer = null;
        this.treeListener = null;
        this.outlinePage = null;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.isLinkingEnabled = enabled;
        if (enabled && this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            ISelection selection = this.treeViewer.getSelection();
            this.selectInTextEditor(selection);
        }
    }

    protected void selectInTextEditor(ISelection selection) {
        IOutlineNode selectedOutlineNode = this.getSelectedOutlineNode(selection);
        this.elementOpener.open(selectedOutlineNode, this.textViewer);
    }

    protected void selectInTreeView(ISelection selection) {
        if (selection instanceof ITextSelection && !this.treeViewer.getTree().isDisposed()) {
            IOutlineNode nodeToBeSelected;
            ITextSelection textSelection = (ITextSelection)selection;
            TextRegion selectedTextRegion = new TextRegion(textSelection.getOffset(), textSelection.getLength());
            Object input = this.treeViewer.getInput();
            if (input instanceof IOutlineNode && (nodeToBeSelected = this.findBestNode((IOutlineNode)input, (ITextRegion)selectedTextRegion)) != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)nodeToBeSelected));
            }
        }
    }

    protected IOutlineNode findBestNode(IOutlineNode input, ITextRegion selectedTextRegion) {
        ITextRegion textRegion = input.getFullTextRegion();
        if (textRegion == null || textRegion.contains(selectedTextRegion)) {
            IOutlineNode currentBestNode = input;
            for (IOutlineNode child : input.getChildren()) {
                IOutlineNode candidate = this.findBestNode(child, selectedTextRegion);
                if (candidate == null || currentBestNode.getFullTextRegion() != null && currentBestNode.getFullTextRegion().getLength() < candidate.getFullTextRegion().getLength()) continue;
                currentBestNode = candidate;
            }
            return currentBestNode;
        }
        return null;
    }

    protected IOutlineNode getSelectedOutlineNode(ISelection selection) {
        Object selectedElement;
        if (selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IOutlineNode) {
            return (IOutlineNode)selectedElement;
        }
        return null;
    }

    protected boolean isOutlineViewActive() {
        IWorkbenchPart activePart = this.outlinePage.getSite().getPage().getActivePart();
        return activePart instanceof ContentOutline;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("ui.outline.linkWithEditor".equals(event.getProperty())) {
            this.setLinkingEnabled(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }

    protected class TextListener
    implements ISelectionChangedListener {
        protected TextListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (OutlineWithEditorLinker.this.isLinkingEnabled && !OutlineWithEditorLinker.this.isOutlineViewActive()) {
                OutlineWithEditorLinker.this.selectInTreeView(event.getSelection());
            }
        }
    }

    protected class TreeListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        protected TreeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (OutlineWithEditorLinker.this.isLinkingEnabled && OutlineWithEditorLinker.this.isOutlineViewActive()) {
                OutlineWithEditorLinker.this.selectInTextEditor(event.getSelection());
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            OutlineWithEditorLinker.this.selectInTextEditor(event.getSelection());
            OutlineWithEditorLinker.this.textViewer.getTextWidget().setFocus();
        }
    }
}

