/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend2.ui.refactoring;

import com.google.inject.Inject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.AbstractJvmModelRenameStrategy;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.JvmMemberRenameStrategy;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmReferenceContext;
import org.eclipse.xtext.xtend2.jvmmodel.IXtend2JvmAssociations;
import org.eclipse.xtext.xtend2.xtend2.XtendClass;
import org.eclipse.xtext.xtend2.xtend2.XtendFunction;

public class Xtend2RenameStrategy
extends AbstractJvmModelRenameStrategy {
    protected Xtend2RenameStrategy(EObject targetElement, EAttribute nameAttribute, ITextRegion originalNameRegion, String nameRuleName, IValueConverterService valueConverterService, IXtend2JvmAssociations jvmModelAssociations) {
        super(targetElement, nameAttribute, originalNameRegion, nameRuleName, valueConverterService, (IJvmModelAssociations)jvmModelAssociations);
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        IPath path = this.getPathToRename(this.getTargetElementOriginalURI(), resourceSet);
        if (path != null) {
            updateAcceptor.accept(this.getTargetElementOriginalURI().trimFragment(), (Change)new RenameResourceChange(path, String.valueOf(newName) + "." + path.getFileExtension()));
        }
    }

    protected IXtend2JvmAssociations getJvmModelAssociations() {
        return (IXtend2JvmAssociations)super.getJvmModelAssociations();
    }

    protected void setInferredJvmElementName(String name, EObject renamedElement) {
        JvmOperation inferredJvmMember;
        if (renamedElement instanceof XtendClass) {
            JvmConstructor inferredConstructor;
            JvmGenericType inferredJvmType = this.getJvmModelAssociations().getInferredType((XtendClass)renamedElement);
            if (inferredJvmType != null) {
                inferredJvmType.setSimpleName(((XtendClass)renamedElement).getName());
                inferredJvmType.setPackageName(((XtendClass)renamedElement).getPackageName());
            }
            if ((inferredConstructor = this.getJvmModelAssociations().getInferredConstructor((XtendClass)renamedElement)) != null) {
                inferredConstructor.setSimpleName(((XtendClass)renamedElement).getName());
            }
        } else if (renamedElement instanceof XtendFunction && (inferredJvmMember = this.getJvmModelAssociations().getDirectlyInferredOperation((XtendFunction)renamedElement)) != null) {
            inferredJvmMember.setSimpleName(((XtendFunction)renamedElement).getName());
        }
    }

    protected IPath getPathToRename(URI elementURI, ResourceSet resourceSet) {
        EObject targetObject = resourceSet.getEObject(elementURI, false);
        if (targetObject instanceof XtendClass) {
            URI resourceURI = EcoreUtil2.getNormalizedResourceURI((EObject)targetObject);
            if (!resourceURI.isPlatformResource()) {
                throw new RefactoringStatusException("Renamed class does not reside in the workspace", true);
            }
            IPath path = new Path("/").append(new Path(resourceURI.path()).removeFirstSegments(1));
            return path;
        }
        return null;
    }

    public static class Provider
    extends DefaultRenameStrategy.Provider {
        @Inject
        private IXtend2JvmAssociations jvmModelAssociations;

        public IRenameStrategy get(EObject targetElement, IRenameElementContext renameElementContext) {
            if (renameElementContext instanceof RenameJvmReferenceContext) {
                return new JvmMemberRenameStrategy((JvmMember)targetElement);
            }
            EAttribute nameAttribute = this.getNameAttribute(targetElement);
            return new Xtend2RenameStrategy(targetElement, nameAttribute, this.getOriginalNameRegion(targetElement, nameAttribute), this.getNameRuleName(targetElement, nameAttribute), this.getValueConverterService(), this.jvmModelAssociations);
        }
    }
}

