/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContext;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XIntLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.typing.AbstractTypeProvider;
import org.eclipse.xtext.xbase.typing.FunctionConversion;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseTypeProvider
extends AbstractTypeProvider {
    @Inject
    private TypesFactory factory;
    @Inject
    private FeatureCallToJavaMapping featureCall2javaMapping;
    @Inject
    private FunctionConversion functionConversion;
    @Inject
    private SuperTypeCollector collector;
    @Inject
    private SynonymTypesProvider synonymTypesProvider;

    protected JvmTypeReference _expectedType(XAssignment assignment, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XASSIGNMENT__VALUE) {
            JvmIdentifiableElement feature = assignment.getFeature();
            JvmTypeReference receiverType = this.getReceiverType(assignment, rawType);
            if (feature instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)feature;
                XExpression expression = this.getExpression(assignment, reference, index);
                List<XExpression> actualArguments = this.featureCall2javaMapping.getActualArguments(assignment);
                int actualIndex = actualArguments.indexOf(expression);
                JvmFormalParameter parameter = this.getParam((JvmExecutable)operation, actualIndex);
                if (parameter != null) {
                    JvmTypeReference declaredType = parameter.getParameterType();
                    TypeArgumentContext context = this.getFeatureCallTypeArgContext(assignment, reference, index, rawType);
                    return context.getLowerBound(declaredType);
                }
                return null;
            }
            JvmTypeReference type = this.getTypeForIdentifiable(feature, rawType);
            if (rawType) {
                return type;
            }
            TypeArgumentContext context = this.getTypeArgumentContextProvider().getReceiverContext(receiverType);
            return context.getLowerBound(type);
        }
        return null;
    }

    protected XExpression getExpression(EObject object, EReference reference, int index) {
        if (index == -1) {
            return (XExpression)object.eGet((EStructuralFeature)reference, true);
        }
        List expressions = (List)object.eGet((EStructuralFeature)reference, true);
        XExpression result = (XExpression)expressions.get(index);
        return result;
    }

    protected JvmTypeReference _expectedType(XAbstractFeatureCall featureCall, EReference reference, int index, boolean rawType) {
        if (featureCall.getFeature() == null || featureCall.getFeature().eIsProxy()) {
            return null;
        }
        if (featureCall instanceof XMemberFeatureCall && (reference == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_ARGUMENTS || reference == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET) || featureCall instanceof XFeatureCall && (reference == XbasePackage.Literals.XFEATURE_CALL__FEATURE_CALL_ARGUMENTS || reference == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__IMPLICIT_RECEIVER)) {
            if (featureCall.getFeature() instanceof JvmOperation) {
                JvmTypeReference result;
                JvmTypeReference receiverType;
                JvmOperation operation = (JvmOperation)featureCall.getFeature();
                XExpression argumentExpression = this.getExpression(featureCall, reference, index);
                List<XExpression> actualArguments = this.featureCall2javaMapping.getActualArguments(featureCall);
                TypeArgumentContext context = this.getFeatureCallTypeArgContext(featureCall, reference, index, rawType);
                int argumentIndex = actualArguments.indexOf(argumentExpression);
                if (argumentIndex >= 0) {
                    if (operation.isVarArgs() && argumentIndex >= operation.getParameters().size() - 1) {
                        JvmTypeReference result2 = this.getExpectedVarArgType((JvmExecutable)operation, context, rawType);
                        return result2;
                    }
                    if (argumentIndex >= operation.getParameters().size()) {
                        return null;
                    }
                    JvmFormalParameter parameter = this.getParam((JvmExecutable)operation, argumentIndex);
                    JvmTypeReference parameterType = parameter.getParameterType();
                    JvmTypeReference result3 = context.getLowerBound(parameterType);
                    return result3;
                }
                JvmParameterizedTypeReference declaringType = this.getTypeReferences().createTypeRef((JvmType)operation.getDeclaringType(), new JvmTypeReference[0]);
                if (rawType) {
                    return declaringType;
                }
                if (!rawType && argumentExpression != null && (receiverType = this.getType(argumentExpression, rawType)) != null && (result = context.getLowerBound(receiverType)) != null && result.getType() instanceof JvmTypeParameter) {
                    return result;
                }
                JvmTypeReference result4 = context.getLowerBound((JvmTypeReference)declaringType);
                return result4;
            }
            if (featureCall.getFeature() instanceof JvmField) {
                JvmField field = (JvmField)featureCall.getFeature();
                return this.getTypeReferences().createTypeRef((JvmType)field.getDeclaringType(), new JvmTypeReference[0]);
            }
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XClosure closure, EReference reference, int index, boolean rawType) {
        JvmTypeReference functionType;
        if (reference == XbasePackage.Literals.XCLOSURE__EXPRESSION && (functionType = this.getExpectedType(closure, rawType)) != null) {
            JvmTypeReference result = this.functionConversion.getReturnType(functionType);
            if (result == null || result.getType() instanceof JvmTypeParameter) {
                return null;
            }
            return result;
        }
        return null;
    }

    @Override
    protected JvmTypeReference handleCycleGetExpectedType(XExpression expression, boolean rawType) {
        Triple<EObject, EReference, Integer> info = this.getContainingInfo(expression);
        if (info.getFirst() instanceof XAbstractFeatureCall) {
            JvmTypeReference result = this._expectedType((XAbstractFeatureCall)info.getFirst(), (EReference)info.getSecond(), (int)((Integer)info.getThird()), rawType);
            return result;
        }
        return super.handleCycleGetExpectedType(expression, rawType);
    }

    protected TypeArgumentContext getFeatureCallTypeArgContext(XAbstractFeatureCall expr, EReference reference, int index, boolean rawType) {
        JvmTypeReference receiverType = this.getReceiverType(expr, rawType);
        if (expr.getFeature() instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)expr.getFeature();
            if (expr.getTypeArguments().isEmpty()) {
                receiverType = this.convertIfNeccessary(expr, receiverType, (JvmIdentifiableElement)operation, rawType);
                JvmTypeReference expectedType = this.getExpectedType(expr, rawType);
                JvmTypeReference[] argTypes = this.getArgumentTypes(expr, rawType);
                TypeArgumentContext context = this.getTypeArgumentContextProvider().getInferredMethodInvocationContext(operation, receiverType, expectedType, argTypes);
                return context;
            }
            TypeArgumentContext result = this.getTypeArgumentContextProvider().getExplicitMethodInvocationContext((JvmTypeParameterDeclarator)operation, receiverType, expr.getTypeArguments());
            return result;
        }
        return this.getTypeArgumentContextProvider().getReceiverContext(receiverType);
    }

    protected JvmTypeReference[] getArgumentTypes(XAbstractFeatureCall expr, boolean rawType) {
        List<XExpression> arguments = this.featureCall2javaMapping.getActualArguments(expr);
        JvmExecutable executable = (JvmExecutable)expr.getFeature();
        return this.getArgumentTypes(executable, arguments, rawType);
    }

    protected JvmTypeReference[] getArgumentTypes(JvmExecutable executable, List<XExpression> actualArguments, boolean rawType) {
        JvmTypeReference[] argTypes = new JvmTypeReference[actualArguments.size()];
        if (actualArguments.isEmpty()) {
            return argTypes;
        }
        int i = 0;
        while (i < argTypes.length) {
            JvmTypeReference type;
            XExpression arg = actualArguments.get(i);
            JvmFormalParameter parameter = this.getParam(executable, i);
            if (parameter != null && (type = this.getType(arg, rawType)) != null) {
                JvmTypeReference synonymType;
                JvmTypeReference parameterType = parameter.getParameterType();
                argTypes[i] = parameterType != null ? ((synonymType = this.synonymTypesProvider.findCompatibleSynonymType(type, parameterType.getType())) != null ? synonymType : type) : type;
            }
            ++i;
        }
        return argTypes;
    }

    protected JvmFormalParameter getParam(JvmExecutable executable, int i) {
        if (executable.getParameters().size() <= i) {
            if (executable.isVarArgs()) {
                return (JvmFormalParameter)executable.getParameters().get(executable.getParameters().size() - 1);
            }
            return null;
        }
        return (JvmFormalParameter)executable.getParameters().get(i);
    }

    protected JvmTypeReference getReceiverType(XAbstractFeatureCall expr, boolean rawType) {
        XExpression receiver = this.featureCall2javaMapping.getActualReceiver(expr);
        JvmTypeReference receiverType = null;
        if (receiver != null) {
            receiverType = this.getType(receiver, rawType);
        }
        return receiverType;
    }

    protected JvmTypeReference _expectedType(XBinaryOperation expr, EReference reference, int index, boolean rawType) {
        JvmOperation operation;
        if (reference == XbasePackage.Literals.XBINARY_OPERATION__RIGHT_OPERAND && expr.getFeature() instanceof JvmOperation) {
            JvmOperation feature = (JvmOperation)expr.getFeature();
            JvmFormalParameter parameter = (JvmFormalParameter)Iterables.getLast((Iterable)feature.getParameters());
            TypeArgumentContext context = this.getFeatureCallTypeArgContext(expr, reference, index, rawType);
            JvmTypeReference parameterType = parameter.getParameterType();
            JvmTypeReference result = context.getLowerBound(parameterType);
            return result;
        }
        if (reference == XbasePackage.Literals.XBINARY_OPERATION__LEFT_OPERAND && expr.getFeature() instanceof JvmOperation && (operation = (JvmOperation)expr.getFeature()).getParameters().size() > 1) {
            JvmFormalParameter parameter = (JvmFormalParameter)operation.getParameters().get(0);
            TypeArgumentContext context = this.getFeatureCallTypeArgContext(expr, reference, index, rawType);
            JvmTypeReference parameterType = parameter.getParameterType();
            JvmTypeReference resolved = context.resolve(parameterType);
            return resolved;
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XVariableDeclaration expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XVARIABLE_DECLARATION__RIGHT) {
            JvmTypeReference type = expr.getType();
            return type;
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XConstructorCall expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__ARGUMENTS) {
            JvmConstructor feature = expr.getConstructor();
            TypeArgumentContext typeArgumentContext = this.getTypeArgumentContextProvider().getReceiverContext(null);
            if (index >= feature.getParameters().size()) {
                if (feature.isVarArgs()) {
                    return this.getExpectedVarArgType((JvmExecutable)feature, typeArgumentContext, rawType);
                }
                return null;
            }
            if (feature.isVarArgs() && index == feature.getParameters().size() - 1) {
                return this.getExpectedVarArgType((JvmExecutable)feature, typeArgumentContext, rawType);
            }
            JvmFormalParameter parameter = (JvmFormalParameter)feature.getParameters().get(index);
            JvmTypeReference parameterType = parameter.getParameterType();
            return typeArgumentContext.getLowerBound(parameterType);
        }
        return null;
    }

    protected JvmTypeReference getExpectedVarArgType(JvmExecutable feature, TypeArgumentContext typeArgumentContext, boolean rawType) {
        JvmFormalParameter lastParameter = (JvmFormalParameter)feature.getParameters().get(feature.getParameters().size() - 1);
        JvmType parameterType = lastParameter.getParameterType().getType();
        if (parameterType instanceof JvmArrayType) {
            JvmTypeReference componentType = ((JvmArrayType)parameterType).getComponentType();
            return typeArgumentContext.getLowerBound(componentType);
        }
        throw new IllegalStateException("Var arg parameter has to be an array type");
    }

    protected JvmTypeReference _expectedType(XBlockExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XBLOCK_EXPRESSION__EXPRESSIONS) {
            if (index + 1 == expr.getExpressions().size()) {
                return this.getExpectedType(expr, rawType);
            }
            return null;
        }
        throw new IllegalStateException("Unhandled reference " + reference);
    }

    protected JvmTypeReference _expectedType(XIfExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XIF_EXPRESSION__IF) {
            return this.getTypeReferences().getTypeForName(Boolean.TYPE, (EObject)expr, new JvmTypeReference[0]);
        }
        return this.getExpectedType(expr, rawType);
    }

    protected JvmTypeReference _expectedType(XForLoopExpression expr, EReference reference, int index, boolean rawType) {
        return null;
    }

    protected JvmTypeReference _expectedType(XAbstractWhileExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__PREDICATE) {
            JvmTypeReference typeForName = this.getTypeReferences().getTypeForName(Boolean.TYPE, (EObject)expr, new JvmTypeReference[0]);
            return typeForName;
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XTryCatchFinallyExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__EXPRESSION) {
            return this.getExpectedType(expr, rawType);
        }
        if (reference == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__CATCH_CLAUSES) {
            return this.getExpectedType(expr, rawType);
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XCatchClause expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XCATCH_CLAUSE__DECLARED_PARAM) {
            return this.getTypeReferences().getTypeForName(Throwable.class, (EObject)expr, new JvmTypeReference[0]);
        }
        return this.getExpectedType((XExpression)expr.eContainer(), rawType);
    }

    protected JvmTypeReference _expectedType(XCastedExpression expr, EReference reference, int index, boolean rawType) {
        return null;
    }

    protected JvmTypeReference _expectedType(XThrowExpression expr, EReference reference, int index, boolean rawType) {
        return this.getTypeReferences().getTypeForName(Throwable.class, (EObject)expr, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _expectedType(XReturnExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XRETURN_EXPRESSION__EXPRESSION) {
            JvmTypeReference expectedReturnType;
            XClosure closure = (XClosure)EcoreUtil2.getContainerOfType((EObject)expr, XClosure.class);
            if (closure != null && (expectedReturnType = this.getExpectedType(closure.getExpression())) != null) {
                return expectedReturnType;
            }
            return this.getTypeReferences().getTypeForName(Object.class, (EObject)expr, new JvmTypeReference[0]);
        }
        return null;
    }

    protected JvmTypeReference _expectedType(XSwitchExpression expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XSWITCH_EXPRESSION__SWITCH) {
            return null;
        }
        return this.getExpectedType(expr, rawType);
    }

    protected JvmTypeReference _expectedType(XCasePart expr, EReference reference, int index, boolean rawType) {
        if (reference == XbasePackage.Literals.XCASE_PART__TYPE_GUARD) {
            return this.getTypeReferences().getTypeForName(Class.class, (EObject)expr, new JvmTypeReference[0]);
        }
        if (reference == XbasePackage.Literals.XCASE_PART__CASE) {
            XSwitchExpression switchExpr = (XSwitchExpression)expr.eContainer();
            if (switchExpr.getSwitch() == null) {
                return this.getTypeReferences().getTypeForName(Boolean.TYPE, (EObject)expr, new JvmTypeReference[0]);
            }
            return null;
        }
        if (reference == XbasePackage.Literals.XCASE_PART__THEN) {
            return this.getExpectedType((XSwitchExpression)expr.eContainer(), rawType);
        }
        return null;
    }

    protected JvmTypeReference _type(XIfExpression object, boolean rawType) {
        ArrayList returnTypes = Lists.newArrayList();
        JvmTypeReference thenType = this.getType(object.getThen(), rawType);
        if (thenType != null) {
            returnTypes.add(thenType);
        }
        JvmAnyTypeReference elseType = this.getTypeReferences().createAnyTypeReference((EObject)object);
        if (object.getElse() != null) {
            elseType = this.getType(object.getElse(), rawType);
        }
        if (elseType != null) {
            returnTypes.add(elseType);
        }
        return this.getCommonType(returnTypes);
    }

    protected JvmTypeReference getCommonType(List<JvmTypeReference> types) {
        JvmTypeReference result;
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            JvmTypeReference result2 = this.getTypeConformanceComputer().getCommonSuperType(types);
            return result2;
        }
        ArrayList filteredTypes = Lists.newArrayListWithExpectedSize((int)types.size());
        for (JvmTypeReference reference : types) {
            if (this.isFilteredFromCommonTypesList(reference)) continue;
            filteredTypes.add(reference);
        }
        if (filteredTypes.isEmpty()) {
            result = this.getTypeConformanceComputer().getCommonSuperType(types);
            return result;
        }
        result = this.getTypeConformanceComputer().getCommonSuperType(filteredTypes);
        return result;
    }

    protected boolean isFilteredFromCommonTypesList(JvmTypeReference reference) {
        if (reference == null) {
            return true;
        }
        if (reference instanceof JvmMultiTypeReference && ((JvmMultiTypeReference)reference).getReferences().isEmpty()) {
            return true;
        }
        if (reference instanceof JvmAnyTypeReference) {
            return false;
        }
        return reference.getType() instanceof JvmVoid && !reference.getType().eIsProxy();
    }

    protected JvmTypeReference _type(XSwitchExpression object, boolean rawType) {
        JvmTypeReference unconverted;
        ArrayList returnTypes = Lists.newArrayList();
        EList<XCasePart> cases = object.getCases();
        for (XCasePart xCasePart : cases) {
            JvmTypeReference unconverted2 = this.getType(xCasePart.getThen(), rawType);
            if (unconverted2 == null) continue;
            returnTypes.add(unconverted2);
        }
        if (object.getDefault() != null && (unconverted = this.getType(object.getDefault(), rawType)) != null) {
            returnTypes.add(unconverted);
        }
        return this.getCommonType(returnTypes);
    }

    protected JvmTypeReference _type(XBlockExpression object, boolean rawType) {
        EList<XExpression> expressions = object.getExpressions();
        if (expressions.isEmpty()) {
            return this.getTypeReferences().createAnyTypeReference((EObject)object);
        }
        JvmTypeReference result = this.getType((XExpression)expressions.get(expressions.size() - 1), rawType);
        return result;
    }

    protected JvmTypeReference _type(XVariableDeclaration object, boolean rawType) {
        return this.getPrimitiveVoid(object);
    }

    protected JvmTypeReference _type(XConstructorCall constructorCall, boolean rawType) {
        JvmTypeParameterDeclarator nearestTypeParameterDeclarator;
        JvmConstructor constructor = constructorCall.getConstructor();
        if (constructor == null || constructor.eIsProxy()) {
            return null;
        }
        JvmTypeReference constructorResultType = this.getTypeForIdentifiable((JvmIdentifiableElement)constructor, rawType);
        if (this.isResolved(constructorResultType, nearestTypeParameterDeclarator = this.getNearestTypeParameterDeclarator(constructorCall), rawType)) {
            return constructorResultType;
        }
        rawType = false;
        JvmTypeParameterDeclarator typeParameterDeclarator = (JvmTypeParameterDeclarator)constructorResultType.getType();
        if (!(!constructorCall.getTypeArguments().isEmpty() || constructor.getTypeParameters().isEmpty() && typeParameterDeclarator.getTypeParameters().isEmpty())) {
            TypeArgumentContext context = this.getTypeArgumentContextProvider().getNullContext();
            JvmTypeReference result = constructorResultType;
            JvmTypeReference[] argumentTypes = this.getArgumentTypes((JvmExecutable)constructor, (List<XExpression>)constructorCall.getArguments(), rawType);
            if ((argumentTypes.length != 0 || constructor.isVarArgs()) && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectArgumentTypeContext(context, constructor, constructorResultType, true, argumentTypes)).getUpperBound(constructorResultType, (Notifier)constructorCall), nearestTypeParameterDeclarator, rawType)) {
                return result;
            }
            JvmTypeReference expectedType = this.getExpectedType(constructorCall, rawType);
            if (expectedType != null && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectExpectedTypeContext(context, constructor, constructorResultType, expectedType)).getUpperBound(constructorResultType, (Notifier)constructorCall), nearestTypeParameterDeclarator, rawType)) {
                return result;
            }
            if (constructor.isVarArgs() && constructor.getParameters().size() > argumentTypes.length && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectArgumentTypeContext(context, constructor, constructorResultType, false, argumentTypes)).getUpperBound(constructorResultType, (Notifier)constructorCall), nearestTypeParameterDeclarator, rawType)) {
                return result;
            }
            if (!this.isResolved(result, nearestTypeParameterDeclarator, rawType) && result instanceof JvmTypeParameter) {
                JvmTypeParameter type = (JvmTypeParameter)result.getType();
                JvmTypeReference upperBound = null;
                for (JvmTypeConstraint constraint : type.getConstraints()) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    if (upperBound != null) {
                        return this.getType(constructorCall, false);
                    }
                    JvmTypeReference reference = constraint.getTypeReference();
                    upperBound = context.getUpperBound(reference, (Notifier)constructorCall);
                }
                if (upperBound != null && !(upperBound.getType() instanceof JvmTypeParameter)) {
                    return upperBound;
                }
                return this.getType(constructorCall, false);
            }
            result = context.getUpperBound(constructorResultType, (Notifier)constructor);
            return result;
        }
        TypeArgumentContext context = this.getTypeArgumentContextProvider().getExplicitMethodInvocationContext(typeParameterDeclarator, null, constructorCall.getTypeArguments());
        return context.getUpperBound(constructorResultType, (Notifier)constructor);
    }

    protected JvmTypeReference _type(XBooleanLiteral object, boolean rawType) {
        return this.getTypeReferences().getTypeForName(Boolean.TYPE, (EObject)object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XNullLiteral object, boolean rawType) {
        JvmAnyTypeReference result = this.getTypeReferences().createAnyTypeReference((EObject)object);
        return result;
    }

    protected JvmTypeReference _type(XIntLiteral object, boolean rawType) {
        return this.getTypeReferences().getTypeForName(Integer.TYPE, (EObject)object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XStringLiteral object, boolean rawType) {
        return this.getTypeReferences().getTypeForName(String.class, (EObject)object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XClosure object, boolean rawType) {
        JvmOperation singleMethod;
        JvmTypeReference expectedType;
        JvmTypeReference type;
        if (rawType) {
            JvmParameterizedTypeReference result = this.functionConversion.createRawFunctionTypeRef(object, object.getFormalParameters().size());
            return result;
        }
        JvmTypeReference returnType = this.getCommonReturnType(object.getExpression(), true);
        if (!rawType && returnType instanceof JvmAnyTypeReference && (type = this.getExpectedType(object.getExpression())) != null) {
            returnType = type;
        }
        ArrayList parameterTypes = Lists.newArrayList();
        EList<JvmFormalParameter> params = object.getFormalParameters();
        for (JvmFormalParameter param : params) {
            parameterTypes.add(param.getParameterType());
        }
        if (!params.isEmpty() && (expectedType = this.getExpectedType(object, rawType)) != null && (singleMethod = this.functionConversion.findSingleMethod(expectedType)) != null) {
            TypeArgumentContext context = this.getTypeArgumentContextProvider().getReceiverContext(expectedType);
            int i = 0;
            while (i < params.size()) {
                JvmTypeReference resultParam = (JvmTypeReference)parameterTypes.get(i);
                if (resultParam == null) {
                    JvmFormalParameter p = this.getParam((JvmExecutable)singleMethod, i);
                    JvmTypeReference resolved = context.getLowerBound(p.getParameterType());
                    parameterTypes.set(i, resolved);
                }
                ++i;
            }
        }
        return this.functionConversion.createFunctionTypeRef(object, parameterTypes, returnType);
    }

    protected JvmTypeReference _type(XCastedExpression object, boolean rawType) {
        return object.getType();
    }

    protected JvmTypeReference _type(XForLoopExpression object, boolean rawType) {
        return this.getPrimitiveVoid(object);
    }

    protected JvmTypeReference _type(XAbstractWhileExpression object, boolean rawType) {
        return this.getPrimitiveVoid(object);
    }

    protected JvmTypeReference _type(XTypeLiteral object, boolean rawType) {
        JvmParameterizedTypeReference typeRef = this.factory.createJvmParameterizedTypeReference();
        typeRef.setType(object.getType());
        return this.getTypeReferences().getTypeForName(Class.class, (EObject)object, new JvmTypeReference[]{typeRef});
    }

    protected JvmTypeReference _type(XInstanceOfExpression object, boolean rawType) {
        return this.getTypeReferences().getTypeForName(Boolean.TYPE, (EObject)object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XThrowExpression object, boolean rawType) {
        JvmTypeReference typeForName = this.getPrimitiveVoid(object);
        return typeForName;
    }

    protected JvmTypeReference _type(XReturnExpression object, boolean rawType) {
        JvmTypeReference typeForName = this.getPrimitiveVoid(object);
        return typeForName;
    }

    protected JvmTypeReference getPrimitiveVoid(XExpression object) {
        return this.getTypeReferences().getTypeForName(Void.TYPE, (EObject)object, new JvmTypeReference[0]);
    }

    protected JvmTypeReference _type(XTryCatchFinallyExpression object, boolean rawType) {
        ArrayList returnTypes = Lists.newArrayList();
        JvmTypeReference getType = this.getType(object.getExpression(), rawType);
        returnTypes.add(getType);
        for (XCatchClause catchClause : object.getCatchClauses()) {
            JvmTypeReference type = this.getType(catchClause.getExpression(), rawType);
            returnTypes.add(type);
        }
        JvmTypeReference commonSuperType = this.getCommonType(returnTypes);
        return commonSuperType;
    }

    protected JvmTypeReference _type(XAbstractFeatureCall featureCall, boolean rawType) {
        JvmTypeParameterDeclarator nearestTypeParameterDeclarator;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature == null || feature.eIsProxy()) {
            return null;
        }
        JvmTypeReference featureType = this.getTypeForIdentifiable(feature, rawType);
        if (this.isResolved(featureType, nearestTypeParameterDeclarator = this.getNearestTypeParameterDeclarator(featureCall), rawType)) {
            return featureType;
        }
        rawType = false;
        JvmTypeReference receiverType2 = this.getReceiverType(featureCall, rawType);
        JvmTypeReference receiverType = this.convertIfNeccessary(featureCall, receiverType2, feature, rawType);
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (featureCall.getTypeArguments().isEmpty()) {
                TypeArgumentContext context = this.getTypeArgumentContextProvider().getNullContext();
                JvmTypeReference result = featureType;
                if (receiverType != null && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectReceiverContext(context, receiverType)).getUpperBound(featureType, (Notifier)featureCall), nearestTypeParameterDeclarator, rawType)) {
                    return result;
                }
                JvmTypeReference[] argumentTypes = this.getArgumentTypes(featureCall, rawType);
                if ((argumentTypes.length != 0 || operation.isVarArgs()) && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectArgumentTypeContext(context, operation, true, argumentTypes)).getUpperBound(featureType, (Notifier)featureCall), nearestTypeParameterDeclarator, rawType)) {
                    return result;
                }
                JvmTypeReference expectedType = this.getExpectedType(featureCall, rawType);
                if (expectedType != null && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectExpectedTypeContext(context, operation, expectedType)).getUpperBound(featureType, (Notifier)featureCall), nearestTypeParameterDeclarator, rawType)) {
                    return result;
                }
                if (operation.isVarArgs() && operation.getParameters().size() > argumentTypes.length && this.isResolved(result = (context = this.getTypeArgumentContextProvider().injectArgumentTypeContext(context, operation, false, argumentTypes)).getUpperBound(featureType, (Notifier)featureCall), nearestTypeParameterDeclarator, rawType)) {
                    return result;
                }
                result = context.getUpperBound(featureType, (Notifier)operation);
                return result;
            }
            TypeArgumentContext context = this.getTypeArgumentContextProvider().getExplicitMethodInvocationContext((JvmTypeParameterDeclarator)operation, receiverType, featureCall.getTypeArguments());
            JvmTypeReference result = context.getUpperBound(featureType, (Notifier)featureCall);
            return result;
        }
        JvmTypeReference expectedType = rawType ? null : this.getExpectedType(featureCall, rawType);
        TypeArgumentContext context = this.getTypeArgumentContextProvider().getReceiverContext(receiverType, featureType, expectedType);
        JvmTypeReference result = context.getUpperBound(featureType, (Notifier)featureCall);
        return result;
    }

    protected JvmTypeReference convertIfNeccessary(XAbstractFeatureCall context, JvmTypeReference toBeConverted, JvmIdentifiableElement feature, boolean rawType) {
        if (toBeConverted != null && feature instanceof JvmMember) {
            JvmDeclaredType declaringType = ((JvmMember)feature).getDeclaringType();
            if (this.synonymTypesProvider.hasSynonymTypes(toBeConverted)) {
                JvmTypeReference findCompatibleSynonymType = this.synonymTypesProvider.findCompatibleSynonymType(toBeConverted, (JvmType)declaringType);
                return findCompatibleSynonymType != null ? findCompatibleSynonymType : toBeConverted;
            }
        }
        return toBeConverted;
    }

    protected JvmTypeReference _typeForIdentifiable(XSwitchExpression object, boolean rawType) {
        if (object.getLocalVarName() != null) {
            JvmTypeReference result = this.getType(object.getSwitch(), rawType);
            return result;
        }
        return null;
    }

    protected JvmTypeReference _typeForIdentifiable(XCasePart object, boolean rawType) {
        if (object.getTypeGuard() != null) {
            return object.getTypeGuard();
        }
        return null;
    }

    protected JvmTypeReference _typeForIdentifiable(XVariableDeclaration object, boolean rawType) {
        if (object.getType() != null) {
            return object.getType();
        }
        return this.getType(object.getRight(), rawType);
    }

    protected JvmTypeReference _typeForIdentifiable(JvmFormalParameter parameter, boolean rawType) {
        if (parameter.getParameterType() == null) {
            if (parameter.eContainer() instanceof XClosure) {
                XClosure closure = (XClosure)parameter.eContainer();
                JvmTypeReference type = this.getExpectedType(closure, rawType);
                if (type == null) {
                    return this.getTypeReferences().getTypeForName(Object.class, (EObject)parameter, new JvmTypeReference[0]);
                }
                int indexOf = closure.getFormalParameters().indexOf((Object)parameter);
                JvmOperation operation = this.functionConversion.findSingleMethod(type);
                if (operation != null && indexOf < operation.getParameters().size()) {
                    JvmFormalParameter declaredParam = this.getParam((JvmExecutable)operation, indexOf);
                    if (rawType && declaredParam.getParameterType().getType() instanceof JvmTypeParameter) {
                        JvmTypeReference result = this._typeForIdentifiable(parameter, false);
                        return result;
                    }
                    TypeArgumentContext context = this.getTypeArgumentContextProvider().getReceiverContext(type);
                    JvmTypeReference result = context.getLowerBound(declaredParam.getParameterType());
                    if (result != null) {
                        return result;
                    }
                    result = context.resolve(declaredParam.getParameterType());
                    return result;
                }
                return null;
            }
            if (parameter.eContainer() instanceof XForLoopExpression) {
                JvmParameterizedTypeReference parameterized;
                XForLoopExpression forLoop = (XForLoopExpression)parameter.eContainer();
                JvmTypeReference reference = this.getType(forLoop.getForExpression(), false);
                if (reference == null) {
                    return null;
                }
                TypeArgumentContext context = this.getTypeArgumentContextProvider().getReceiverContext(reference);
                final String iterableName = Iterable.class.getName();
                if (reference.getType() instanceof JvmArrayType) {
                    JvmTypeReference type = ((JvmArrayType)reference.getType()).getComponentType();
                    return type;
                }
                if (!reference.getType().getIdentifier().equals(iterableName)) {
                    try {
                        Set collectSuperTypes = this.collector.collectSuperTypes(reference);
                        reference = (JvmTypeReference)Iterables.find((Iterable)collectSuperTypes, (Predicate)new Predicate<JvmTypeReference>(){

                            public boolean apply(JvmTypeReference input) {
                                return input.getType().getIdentifier().equals(iterableName);
                            }
                        });
                    }
                    catch (NoSuchElementException e) {
                        return null;
                    }
                }
                if (reference instanceof JvmParameterizedTypeReference && (parameterized = (JvmParameterizedTypeReference)reference).getArguments().size() > 0) {
                    JvmTypeReference result = context.getUpperBound((JvmTypeReference)parameterized.getArguments().get(0), (Notifier)parameter);
                    return result;
                }
            }
        }
        return parameter.getParameterType();
    }

    @Override
    protected JvmTypeReference handleCycleGetTypeForIdentifiable(JvmIdentifiableElement identifiableElement, boolean rawType) {
        if (identifiableElement instanceof JvmFormalParameter && identifiableElement.eContainer() instanceof XClosure) {
            return this._typeForIdentifiable((JvmFormalParameter)identifiableElement, rawType);
        }
        return super.handleCycleGetTypeForIdentifiable(identifiableElement, rawType);
    }

    protected JvmTypeReference _typeForIdentifiable(JvmConstructor constructor, boolean rawType) {
        JvmParameterizedTypeReference reference = this.factory.createJvmParameterizedTypeReference();
        JvmDeclaredType declaringType = constructor.getDeclaringType();
        reference.setType((JvmType)declaringType);
        if (declaringType instanceof JvmGenericType) {
            for (JvmTypeParameter typeParam : ((JvmGenericType)declaringType).getTypeParameters()) {
                reference.getArguments().add((Object)this.getTypeReferences().createTypeRef((JvmType)typeParam, new JvmTypeReference[0]));
            }
        }
        return reference;
    }

    protected JvmTypeReference _typeForIdentifiable(JvmField field, boolean rawType) {
        return field.getType();
    }

    protected JvmTypeReference _typeForIdentifiable(JvmOperation operation, boolean rawType) {
        return operation.getReturnType();
    }

    protected JvmTypeReference _typeForIdentifiable(JvmType type, boolean rawType) {
        return this.getTypeReferences().createTypeRef(type, new JvmTypeReference[0]);
    }

    protected void _earlyExits(XClosure expr, AbstractTypeProvider.EarlyExitAcceptor a) {
    }

    protected void _earlyExits(XReturnExpression expr, AbstractTypeProvider.EarlyExitAcceptor acceptor) {
        JvmTypeReference type;
        if (expr.getExpression() != null && (type = this.getType(expr.getExpression())) != null) {
            acceptor.returns.add(type);
        }
    }

    protected void _earlyExits(XThrowExpression expr, AbstractTypeProvider.EarlyExitAcceptor acceptor) {
        JvmTypeReference type;
        if (expr.getExpression() != null && (type = this.getType(expr.getExpression())) != null) {
            acceptor.thrown.add(type);
        }
    }

    protected void _earlyExits(XConstructorCall expr, AbstractTypeProvider.EarlyExitAcceptor acceptor) {
        Iterable<JvmTypeReference> thrownExceptions = this.getThrownExceptionForIdentifiable((JvmIdentifiableElement)expr.getConstructor());
        if (thrownExceptions != null) {
            acceptor.appendThrown(thrownExceptions);
        }
        this._earlyExits((EObject)expr, acceptor);
    }

    protected void _earlyExits(XAbstractFeatureCall expr, AbstractTypeProvider.EarlyExitAcceptor acceptor) {
        Iterable<JvmTypeReference> thrownExceptions = this.getThrownExceptionForIdentifiable(expr.getFeature());
        if (thrownExceptions != null) {
            acceptor.appendThrown(thrownExceptions);
        }
        this._earlyExits((EObject)expr, acceptor);
    }

    protected void _earlyExits(XTryCatchFinallyExpression expr, AbstractTypeProvider.EarlyExitAcceptor acceptor) {
        AbstractTypeProvider.EarlyExitAcceptor innerAcceptor = new AbstractTypeProvider.EarlyExitAcceptor();
        this.internalCollectEarlyExits(expr.getExpression(), innerAcceptor);
        acceptor.returns.addAll(innerAcceptor.returns);
        for (XCatchClause catchClause : expr.getCatchClauses()) {
            Iterator<JvmTypeReference> iterator = innerAcceptor.thrown.iterator();
            while (iterator.hasNext()) {
                JvmTypeReference thrown = iterator.next();
                if (!this.getTypeConformanceComputer().isConformant(catchClause.getDeclaredParam().getParameterType(), thrown)) continue;
                iterator.remove();
            }
            this.internalCollectEarlyExits(catchClause.getExpression(), acceptor);
        }
        acceptor.thrown.addAll(innerAcceptor.thrown);
        if (expr.getFinallyExpression() != null) {
            this.internalCollectEarlyExits(expr.getFinallyExpression(), acceptor);
        }
    }

    protected TypesFactory getTypesFactory() {
        return this.factory;
    }

    @Override
    public Iterable<JvmTypeReference> getThrownExceptionForIdentifiable(JvmIdentifiableElement identifiable) {
        if (identifiable == null || identifiable.eIsProxy()) {
            return Collections.emptySet();
        }
        if (identifiable instanceof JvmExecutable) {
            return ((JvmExecutable)identifiable).getExceptions();
        }
        return Collections.emptySet();
    }
}

