/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typing.FunctionConversion;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

@Singleton
public class XbaseTypeConformanceComputer
extends TypeConformanceComputer {
    @Inject
    private FunctionConversion functionConversion;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        if (super.isConformant(left, right, ignoreGenerics)) {
            return true;
        }
        if ((this.functionConversion.isFunction(left) || this.functionConversion.isFunction(right)) && this.functionConversion.isConformant(left, right, ignoreGenerics)) {
            return true;
        }
        Iterable<JvmTypeReference> synonymTypes = this.synonymTypeProvider.getSynonymTypes(right);
        for (JvmTypeReference synonymType : synonymTypes) {
            if (!super.isConformant(left, synonymType, ignoreGenerics)) continue;
            return true;
        }
        return false;
    }
}

