/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.scoping.featurecalls.AbstractFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeConformanceComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticMethodsFeatureForTypeProvider
extends AbstractFeaturesForTypeProvider {
    @Inject
    private XbaseTypeConformanceComputer conformanceComputer;
    @Inject
    private TypeReferences typeRefs;
    private Resource context;
    private boolean isExtensionProvider = false;

    @Override
    public Iterable<? extends JvmFeature> getFeaturesForType(JvmTypeReference reference) {
        Iterable<String> staticTypeNames = this.getVisibleTypesContainingStaticMethods(reference);
        ArrayList result = Lists.newArrayList();
        for (String staticTypeName : staticTypeNames) {
            JvmTypeReference staticType = this.typeRefs.getTypeForName(staticTypeName, (Notifier)this.context, new JvmTypeReference[0]);
            if (staticType == null) continue;
            JvmDeclaredType type = (JvmDeclaredType)staticType.getType();
            Iterable operations = type.getDeclaredOperations();
            for (JvmOperation operation : operations) {
                if (!this.isMatchingExtension(reference, operation)) continue;
                result.add(operation);
            }
        }
        return result;
    }

    protected boolean isMatchingExtension(JvmTypeReference expectedParameterTypeReference, JvmOperation operation) {
        if (operation.isStatic()) {
            if (expectedParameterTypeReference == null) {
                return true;
            }
            if (operation.getParameters().size() > 0) {
                JvmFormalParameter firstParam = (JvmFormalParameter)operation.getParameters().get(0);
                return super.isSameTypeOrAssignableToUpperBound(expectedParameterTypeReference, firstParam.getParameterType());
            }
        }
        return false;
    }

    protected abstract Iterable<String> getVisibleTypesContainingStaticMethods(JvmTypeReference var1);

    public void setContext(Resource context) {
        this.context = context;
    }

    protected Resource getContext() {
        return this.context;
    }

    protected XbaseTypeConformanceComputer getConformanceComputer() {
        return this.conformanceComputer;
    }

    protected TypeReferences getTypeRefs() {
        return this.typeRefs;
    }

    @Override
    public boolean isExtensionProvider() {
        return this.isExtensionProvider;
    }

    public void setExtensionProvider(boolean isExtensionProvider) {
        this.isExtensionProvider = isExtensionProvider;
    }
}

