/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.IXtextEditorCallback;
import org.eclipse.xtext.ui.editor.Messages;
import org.eclipse.xtext.ui.editor.SchedulingRuleFactory;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;

public class XtextEditorErrorTickUpdater
extends IXtextEditorCallback.NullImpl
implements IAnnotationModelListener {
    private static final ISchedulingRule SEQUENCE_RULE = SchedulingRuleFactory.INSTANCE.newSequence();
    @Inject
    private IImageHelper imageHelper;
    @Inject
    private IssueUtil issueUtil;
    private Image defaultImage;
    private Severity previousSeverity = null;
    private XtextEditor editor;
    private IAnnotationModel annotationModel;
    private UpdateEditorImageJob updateEditorImageJob;

    public void beforeDispose(XtextEditor xtextEditor) {
        this.unregisterListener();
        if (this.editor != null) {
            if (this.defaultImage != null && !this.defaultImage.isDisposed()) {
                this.editor.updatedTitleImage(this.defaultImage);
            }
            this.editor = null;
        }
    }

    public void afterSetInput(XtextEditor xtextEditor) {
        if (this.editor != null) {
            this.unregisterListener();
            this.updateImageAndRegisterListener();
        }
    }

    public void afterCreatePartControl(XtextEditor xtextEditor) {
        this.editor = xtextEditor;
        this.updateImageAndRegisterListener();
    }

    protected void unregisterListener() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener((IAnnotationModelListener)this);
            this.annotationModel = null;
        }
    }

    protected void updateImageAndRegisterListener() {
        this.defaultImage = this.editor.getDefaultImage();
        this.updateEditorImage(this.editor);
        this.annotationModel = this.editor.getInternalSourceViewer().getAnnotationModel();
        if (this.annotationModel != null) {
            this.annotationModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
    }

    protected void updateEditorImage(XtextEditor xtextEditor) {
        Severity severity = this.getSeverity(xtextEditor);
        if (severity == this.previousSeverity) {
            return;
        }
        this.previousSeverity = severity;
        if (severity != null && severity != Severity.INFO) {
            ImageDescriptor descriptor = severity == Severity.ERROR ? XtextPluginImages.DESC_OVR_ERROR : XtextPluginImages.DESC_OVR_WARNING;
            DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(this.defaultImage, descriptor, 2);
            Image decoratedImage = this.imageHelper.getImage((ImageDescriptor)decorationOverlayIcon);
            if (xtextEditor.getTitleImage() != decoratedImage) {
                this.scheduleUpdateEditorJob(decoratedImage);
            }
        } else {
            this.scheduleUpdateEditorJob(this.defaultImage);
        }
    }

    protected Severity getSeverity(XtextEditor xtextEditor) {
        if (xtextEditor == null || xtextEditor.getInternalSourceViewer() == null) {
            return null;
        }
        IAnnotationModel model = xtextEditor.getInternalSourceViewer().getAnnotationModel();
        if (model != null) {
            Iterator iterator = model.getAnnotationIterator();
            boolean hasWarnings = false;
            boolean hasInfos = false;
            while (iterator.hasNext()) {
                Issue issue;
                Annotation annotation = (Annotation)iterator.next();
                if (annotation.isMarkedDeleted() || (issue = this.issueUtil.getIssueFromAnnotation(annotation)) == null) continue;
                if (issue.getSeverity() == Severity.ERROR) {
                    return Severity.ERROR;
                }
                if (issue.getSeverity() == Severity.WARNING) {
                    hasWarnings = true;
                    continue;
                }
                if (issue.getSeverity() != Severity.INFO) continue;
                hasInfos = true;
            }
            if (hasWarnings) {
                return Severity.WARNING;
            }
            if (hasInfos) {
                return Severity.INFO;
            }
        }
        return null;
    }

    public void scheduleUpdateEditorJob(Image image) {
        UpdateEditorImageJob job = this.updateEditorImageJob;
        if (job == null) {
            this.updateEditorImageJob = job = this.createUpdateEditorImageJob();
        }
        job.scheduleFor(image);
    }

    protected UpdateEditorImageJob createUpdateEditorImageJob() {
        return new UpdateEditorImageJob(SEQUENCE_RULE);
    }

    public void modelChanged(IAnnotationModel model) {
        this.updateEditorImage(this.editor);
    }

    protected class UpdateEditorImageJob
    extends UIJob {
        private volatile Image titleImage;

        public UpdateEditorImageJob(ISchedulingRule schedulingRule) {
            super(Messages.XtextEditorErrorTickUpdater_JobName);
            this.setRule(schedulingRule);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IEditorSite site;
            IEditorSite iEditorSite = site = XtextEditorErrorTickUpdater.this.editor != null ? XtextEditorErrorTickUpdater.this.editor.getEditorSite() : null;
            if (site != null && !monitor.isCanceled() && this.titleImage != null && !this.titleImage.isDisposed() && XtextEditorErrorTickUpdater.this.editor != null) {
                XtextEditorErrorTickUpdater.this.editor.updatedTitleImage(this.titleImage);
            }
            return Status.OK_STATUS;
        }

        protected void scheduleFor(Image image) {
            this.cancel();
            this.titleImage = image;
            this.schedule();
        }
    }
}

