/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.preferences;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.codetemplates.ui.internal.CodetemplatesActivator;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.ISyntheticResourceProvider;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.PartialModelEditor;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.SourceViewerHandle;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.IEditTemplateDialog;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.OperationHistoryListener;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplateDialogMessages;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplatesLanguageConfiguration;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TextViewerAction;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.validation.Issue;

public class EditTemplateDialog
extends StatusDialog
implements IEditTemplateDialog {
    private Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private PartialModelEditor partialModelEditor;
    private Button fInsertVariableButton;
    private Button fAutoInsertCheckbox;
    private boolean fIsNameModifiable;
    private Map<String, TextViewerAction> fGlobalActions = Maps.newHashMapWithExpectedSize((int)10);
    private List<String> fSelectionActions = Lists.newArrayListWithExpectedSize((int)3);
    private String[][] fContextTypes;
    private ContextTypeRegistry fContextTypeRegistry;
    private OperationHistoryListener operationHistoryListener;
    private final String languageName;
    private final TemplatesLanguageConfiguration configuration;
    private final ISyntheticResourceProvider resourceProvider;

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry, TemplatesLanguageConfiguration configuration, ISyntheticResourceProvider resourceProvider, String languageName) {
        super(parent);
        this.configuration = configuration;
        this.resourceProvider = resourceProvider;
        this.languageName = languageName;
        String title = edit ? TemplateDialogMessages.EditTemplateDialog_title_edit : TemplateDialogMessages.EditTemplateDialog_title_new;
        this.setTitle(title);
        this.fTemplate = template;
        this.fIsNameModifiable = isNameModifiable;
        ArrayList contexts = Lists.newArrayList();
        UnmodifiableIterator it = Iterators.filter((Iterator)registry.contextTypes(), TemplateContextType.class);
        while (it.hasNext()) {
            TemplateContextType type = (TemplateContextType)it.next();
            contexts.add(new String[]{type.getId(), type.getName()});
        }
        this.fContextTypes = (String[][])contexts.toArray((T[])new String[contexts.size()][]);
        this.fContextTypeRegistry = registry;
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(this.getStatus().isOK());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_name);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.fNameText = EditTemplateDialog.createText(composite);
            EditTemplateDialog.createLabel(composite, TemplateDialogMessages.EditTemplateDialog_context);
            this.fContextCombo = new Combo(composite, 8);
            this.fContextCombo.setVisibleItemCount(30);
            int i = 0;
            while (i < this.fContextTypes.length) {
                this.fContextCombo.add(this.fContextTypes[i][1]);
                ++i;
            }
            this.fContextCombo.addModifyListener(listener);
            this.fAutoInsertCheckbox = EditTemplateDialog.createCheckbox(composite, TemplateDialogMessages.EditTemplateDialog_autoinsert);
            this.fAutoInsertCheckbox.setSelection(this.fTemplate.isAutoInsertable());
        }
        EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_description);
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData());
        this.fInsertVariableButton.setText(TemplateDialogMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fNameText.addModifyListener(listener);
            this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeId()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditTemplateDialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText || w == this.fContextCombo) {
            this.partialModelEditor.updatePrefix(this.getPrefix());
        }
    }

    protected String getContextName() {
        String result;
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            result = this.fContextCombo.getText();
        } else {
            String contextId = this.fTemplate.getContextTypeId();
            result = this.fContextTypeRegistry.getContextType(contextId).getName();
        }
        if (result.startsWith("Keyword ")) {
            result = result.substring("Keyword ".length());
        }
        return result;
    }

    protected void doSourceChanged(IDocument document) {
        this.updateAction(ITextEditorActionConstants.UNDO);
    }

    protected String getContextId() {
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            String name = this.fContextCombo.getText();
            int i = 0;
            while (i < this.fContextTypes.length) {
                if (name.equals(this.fContextTypes[i][1])) {
                    return this.fContextTypes[i][0];
                }
                ++i;
            }
        }
        return this.fTemplate.getContextTypeId();
    }

    protected Status createErrorStatus(String message, TemplateException e) {
        return new Status(4, CodetemplatesActivator.getInstance().getBundle().getSymbolicName(), message, (Throwable)e);
    }

    private static GridData getButtonGridData() {
        GridData data = new GridData(768);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        SourceViewer viewer = this.createViewer(parent);
        int numberOfLines = viewer.getDocument().getNumberOfLines();
        if (numberOfLines < 7) {
            numberOfLines = 7;
        } else if (numberOfLines > 14) {
            numberOfLines = 14;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(numberOfLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        this.installUndoRedoSupport(viewer);
        return viewer;
    }

    protected void installUndoRedoSupport(SourceViewer viewer) {
        IDocumentUndoManager undoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)viewer.getDocument());
        IUndoContext context = undoManager.getUndoContext();
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        this.operationHistoryListener = new OperationHistoryListener(context, new IUpdate(){

            public void update() {
                EditTemplateDialog.this.updateAction(ITextEditorActionConstants.REDO);
                EditTemplateDialog.this.updateAction(ITextEditorActionConstants.UNDO);
            }
        });
        operationHistory.addOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
    }

    public boolean close() {
        this.uninstallUndoRedoSupport();
        this.configuration.getHighlightingHelper().uninstall();
        return super.close();
    }

    protected void uninstallUndoRedoSupport() {
        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
        operationHistory.removeOperationHistoryListener((IOperationHistoryListener)this.operationHistoryListener);
        this.operationHistoryListener = null;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewerHandle handle = this.configuration.getSourceViewerHandleFactory().create(parent, this.resourceProvider);
        handle.setIssueProcessor(new IValidationIssueProcessor(){

            public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                StringBuilder messages = new StringBuilder();
                for (Issue issue : issues) {
                    if (issue.getSeverity() != Severity.ERROR) continue;
                    if (messages.length() != 0) {
                        messages.append('\n');
                    }
                    messages.append(issue.getMessage());
                }
                if (messages.length() != 0) {
                    result = EditTemplateDialog.this.createErrorStatus(messages.toString(), null);
                }
                final IStatus toBeUpdated = result;
                EditTemplateDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        EditTemplateDialog.this.updateStatus(toBeUpdated);
                    }
                });
            }
        });
        this.partialModelEditor = handle.createPartialEditor(this.getPrefix(), this.fTemplate.getPattern(), "");
        this.configuration.getHighlightingHelper().install(handle.getConfiguration(), handle.getViewer());
        return handle.getViewer();
    }

    protected String getPrefix() {
        String contextName = this.getContextName();
        String name = this.fTemplate.getName();
        if (this.fNameText != null && !this.fNameText.isDisposed()) {
            name = this.fNameText.getText();
        }
        String prefix = "templates for " + this.languageName + " '" + name + "'" + " for " + contextName + " >>";
        return prefix;
    }

    private void initializeActions() {
        final ArrayList handlerActivations = Lists.newArrayListWithExpectedSize((int)3);
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        ActiveShellExpression expression = new ActiveShellExpression(this.fPatternEditor.getControl().getShell());
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }
        });
        this.fPatternEditor.getTextWidget().addFocusListener(new FocusListener((Expression)expression){
            private final /* synthetic */ Expression val$expression;
            {
                this.val$expression = expression;
            }

            public void focusLost(FocusEvent e) {
                handlerService.deactivateHandlers((Collection)handlerActivations);
            }

            public void focusGained(FocusEvent e) {
                IAction action = (IAction)EditTemplateDialog.this.fGlobalActions.get(ITextEditorActionConstants.REDO);
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler(action), this.val$expression));
                action = (IAction)EditTemplateDialog.this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler(action), this.val$expression));
                action = (IAction)EditTemplateDialog.this.fGlobalActions.get("ContentAssistProposal");
                handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)new ActionHandler(action), this.val$expression));
            }
        });
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(TemplateDialogMessages.EditTemplateDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 2);
        action.setText(TemplateDialogMessages.EditTemplateDialog_redo);
        this.fGlobalActions.put(ITextEditorActionConstants.REDO, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(TemplateDialogMessages.EditTemplateDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(TemplateDialogMessages.EditTemplateDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(TemplateDialogMessages.EditTemplateDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(TemplateDialogMessages.EditTemplateDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        action.setText(TemplateDialogMessages.EditTemplateDialog_content_assist);
        this.fGlobalActions.put("ContentAssistProposal", action);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.REDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String contextid) {
        if (contextid == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (contextid.equals(this.fContextTypes[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        String name = this.fNameText == null ? this.fTemplate.getName() : this.fNameText.getText();
        boolean isAutoInsertable = this.fAutoInsertCheckbox != null && this.fAutoInsertCheckbox.getSelection();
        this.fTemplate = new Template(name, this.fDescriptionText.getText(), this.getContextId(), this.getPattern(), isAutoInsertable);
        super.okPressed();
    }

    public Template getTemplate() {
        return this.fTemplate;
    }

    protected String getPattern() {
        return this.partialModelEditor.getEditablePart();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(this.getClass().getName()) + "_dialogBounds";
        IDialogSettings section = this.configuration.getDialogSettings().getSection(sectionName);
        if (section == null) {
            section = this.configuration.getDialogSettings().addNewSection(sectionName);
        }
        return section;
    }
}

