/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.hover;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverDocumentationProvider;

public class XtendHoverDocumentationProvider
extends XbaseHoverDocumentationProvider {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;

    protected JvmDeclaredType getDeclaringType(EObject eObject) {
        JvmOperation jvmOperation;
        if (eObject instanceof XtendFunction && (jvmOperation = this.associations.getDirectlyInferredOperation((XtendFunction)eObject)) != null) {
            return super.getDeclaringType((EObject)jvmOperation);
        }
        return super.getDeclaringType(eObject);
    }

    protected void handleSuperMethodReferences(EObject context) {
        JvmOperation overridden;
        JvmOperation inferredOperation;
        XtendFunction function;
        if (context instanceof XtendFunction && (function = (XtendFunction)context).isOverride() && (inferredOperation = this.associations.getDirectlyInferredOperation(function)) != null && (overridden = this.overrideHelper.findOverriddenOperation(inferredOperation)) != null) {
            this.buffer.append("<div>");
            this.buffer.append("<b>");
            this.buffer.append("Overrides:");
            this.buffer.append("</b> ");
            this.buffer.append(this.createMethodInTypeLinks(overridden));
            this.buffer.append("</div>");
        }
    }

    protected List<String> initParameterNames() {
        List result = super.initParameterNames();
        if (this.context instanceof XtendFunction) {
            for (XtendParameter param : ((XtendFunction)this.context).getParameters()) {
                result.add(param.getName());
            }
        }
        if (this.context instanceof XtendConstructor) {
            for (XtendParameter param : ((XtendConstructor)this.context).getParameters()) {
                result.add(param.getName());
            }
        }
        return result;
    }

    protected Map<String, URI> initExceptionNamesToURI() {
        Map result = super.initExceptionNamesToURI();
        if (this.context instanceof XtendFunction) {
            for (JvmTypeReference exception : ((XtendFunction)this.context).getExceptions()) {
                result.put(exception.getSimpleName(), EcoreUtil.getURI((EObject)exception.getType()));
            }
        }
        if (this.context instanceof XtendConstructor) {
            for (JvmTypeReference exception : ((XtendConstructor)this.context).getExceptions()) {
                result.put(exception.getSimpleName(), EcoreUtil.getURI((EObject)exception.getType()));
            }
        }
        return result;
    }

    protected List<EObject> getFilteredDerivedElements(EObject o, EClass type) {
        List filteredDerivedElements = super.getFilteredDerivedElements(o, type);
        if (filteredDerivedElements.size() > 1) {
            return filteredDerivedElements;
        }
        return Lists.newArrayList();
    }

    protected List<EObject> getFilteredSourceElements(EObject o, EClass type) {
        List filteredSourceElements = super.getFilteredSourceElements(o, type);
        if (filteredSourceElements.size() > 1) {
            return filteredSourceElements;
        }
        return Lists.newArrayList();
    }

    protected String resolveDocumentationForJvmElement(EObject jvmElement) {
        String documentation = this.documentationProvider.getDocumentation(jvmElement);
        if (documentation != null) {
            return documentation;
        }
        DocumentationAdapter adapter = this.getDocumentationAdapter(jvmElement);
        return adapter == null ? null : adapter.getDocumentation();
    }
}

