/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.buildpath;

import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.ide.buildpath.XtendClasspathContainer;
import org.eclipse.xtend.ide.buildpath.XtendContainerInitializer;
import org.eclipse.xtext.util.MergeableManifest;

public class XtendLibClasspathAdder {
    private static final Logger LOG = Logger.getLogger(XtendLibClasspathAdder.class);
    private static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";

    public void addLibsToClasspath(IJavaProject javaProject, IProgressMonitor monitor) {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            IProject project = javaProject.getProject();
            if (!project.hasNature(PLUGIN_NATURE) || !this.addToPluginManifest(project, (IProgressMonitor)progress.newChild(1))) {
                this.addToClasspath(javaProject, (IProgressMonitor)progress.newChild(1));
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error adding Xtend libs to classpath", (Throwable)exc);
        }
    }

    protected boolean addToClasspath(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry xtendContainerEntry = JavaCore.newContainerEntry((IPath)XtendContainerInitializer.XTEND_LIBRARY_PATH);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        IClasspathEntry[] newRawClasspath = new IClasspathEntry[rawClasspath.length + 1];
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)xtendContainerEntry.getPath())) {
                return false;
            }
            newRawClasspath[i + 1] = entry;
            ++i;
        }
        newRawClasspath[0] = xtendContainerEntry;
        javaProject.setRawClasspath(newRawClasspath, monitor);
        return true;
    }

    protected boolean addToPluginManifest(IProject project, IProgressMonitor monitor) throws IOException, CoreException {
        IResource manifestFile = project.findMember("META-INF/MANIFEST.MF");
        if (manifestFile != null && manifestFile.isAccessible() && !manifestFile.getResourceAttributes().isReadOnly() && manifestFile instanceof IFile) {
            OutputStream output = null;
            InputStream input = null;
            try {
                MergeableManifest manifest = this.createMergableManifest(manifestFile);
                manifest.addRequiredBundles((Set)Sets.newHashSet((Object[])XtendClasspathContainer.BUNDLE_IDS_TO_INCLUDE));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                output = new BufferedOutputStream(out);
                manifest.write(output);
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                input = new BufferedInputStream(in);
                ((IFile)manifestFile).setContents(input, true, true, monitor);
                return true;
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (input != null) {
                    input.close();
                }
            }
        }
        return false;
    }

    private MergeableManifest createMergableManifest(IResource manifestFile) throws IOException, CoreException {
        InputStream originalManifest = ((IFile)manifestFile).getContents();
        try {
            MergeableManifest mergeableManifest = new MergeableManifest(originalManifest);
            return mergeableManifest;
        }
        finally {
            originalManifest.close();
        }
    }
}

